/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table.renderer;

import fr.proline.studio.utils.DataFormat;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CollectionRenderer
implements TableCellRenderer {
    private TableCellRenderer m_defaultRenderer;
    private int m_digits = -1;

    public CollectionRenderer(TableCellRenderer defaultRenderer, int digits) {
        this.m_defaultRenderer = defaultRenderer;
        this.m_digits = digits;
    }

    public CollectionRenderer(TableCellRenderer defaultRenderer) {
        this.m_defaultRenderer = defaultRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formatedValue = "";
        if (value instanceof Collection) {
            Collection l = (Collection)value;
            formatedValue = l.stream().map(v -> this.m_digits < 0 ? v.toString() : DataFormat.format(((Number)v).floatValue(), this.m_digits)).collect(Collectors.joining(";"));
        } else if (value.getClass().isArray()) {
            formatedValue = Arrays.stream((Object[])value).map(v -> this.m_digits < 0 ? v.toString() : DataFormat.format(((Number)v).floatValue(), this.m_digits)).collect(Collectors.joining(";"));
        }
        return this.m_defaultRenderer.getTableCellRendererComponent(table, formatedValue, isSelected, hasFocus, row, column);
    }
}

