/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import fr.proline.studio.utils.DataFormat;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.tree.DefaultMutableTreeNode;

public class StringUtils {
    private static int STEP_LIMIT = 1000;

    public static final String truncate(String text, int nbCharac) {
        if (text == null) {
            return null;
        }
        int textSize = text.length();
        if (nbCharac > textSize) {
            return text;
        }
        return text.substring(textSize - nbCharac);
    }

    public static int lenghtOfString(String s, FontMetrics fm) {
        if (fm == null || s == null) {
            return 0;
        }
        return fm.stringWidth(s);
    }

    public static List<String> splitString(String msg, int lineSize) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern p = Pattern.compile("\\b.{1," + (lineSize - 1) + "}\\b\\W?");
        Matcher m = p.matcher(msg);
        while (m.find()) {
            System.out.println(m.group().trim());
            res.add(m.group());
        }
        return res;
    }

    public static String formatString(String msg, int lineSize) {
        Pattern p = Pattern.compile(".{1," + (lineSize - 1) + "}\\b\\W?");
        Matcher m = p.matcher(msg);
        StringBuilder builder = new StringBuilder();
        while (m.find()) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            builder.append(m.group());
        }
        return builder.toString();
    }

    public static String formatFloatArray(Float[] floats, int digits) {
        if (floats == null) {
            return "null";
        }
        int iMax = floats.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(DataFormat.format(floats[i], digits));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String formatFloatList(List<Float> floats, int digits) {
        if (floats == null) {
            return "null";
        }
        if (floats.isEmpty()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(DataFormat.format(floats.get(i), digits));
            if (i == floats.size() - 1) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static Pattern compileRegex(String text) {
        String escapedText = "^" + StringUtils.escapeRegex(text) + "$";
        String wildcardsFilter = escapedText.replaceAll("\\*", ".*").replaceAll("\\?", ".");
        return Pattern.compile(wildcardsFilter, 2);
    }

    private static String escapeRegex(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("[](){}.+$^|#\\".indexOf(c) != -1) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractTextFromHtml(String html) {
        try {
            String htmlTag = "<html>";
            String htmlEndTag = "</html>";
            String[] lines = html.split("\n");
            StringBuffer sb = new StringBuffer();
            for (String s : lines) {
                sb.append(htmlTag).append(s).append(htmlEndTag);
            }
            StringReader reader = new StringReader(sb.toString());
            final StringBuilder resultText = new StringBuilder();
            ParserDelegator parserDelegator = new ParserDelegator();
            HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

                @Override
                public void handleText(char[] data, int pos) {
                    resultText.append(data);
                }

                @Override
                public void handleEndTag(HTML.Tag t, int pos) {
                    if (t.equals(HTML.Tag.HTML)) {
                        resultText.append("\n");
                    }
                }
            };
            parserDelegator.parse(reader, parserCallback, true);
            return resultText.toString().trim();
        }
        catch (IOException ex) {
            return html;
        }
    }

    public static String camelCasetoSnakeCase(String camelCaseStr) {
        return camelCaseStr.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String snakeCasetoCamelCase(String snakeCaseStr, boolean startUpperCase) {
        StringBuilder sb = new StringBuilder(snakeCaseStr);
        for (int i = 0; i < sb.length(); ++i) {
            if (startUpperCase && i == 0) {
                sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
            }
            if (sb.charAt(i) != '_') continue;
            sb.deleteCharAt(i);
            sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
        }
        return sb.toString();
    }

    public static String getLabelFromCamelCase(String camelCaseStr) {
        return org.apache.commons.lang3.StringUtils.capitalize((String)org.apache.commons.lang3.StringUtils.join((Object[])org.apache.commons.lang3.StringUtils.splitByCharacterTypeCamelCase((String)camelCaseStr), (String)" "));
    }

    public static String getTimeInMinutes(float seconds, int nbDigit) {
        double min = seconds / 60.0f;
        return DataFormat.format(min, nbDigit);
    }

    public static String getTimeAsMinSecText(long seconds) {
        long min = seconds / 60L;
        long sec = seconds % 60L;
        return String.format("%d min %d sec", min, sec);
    }

    public static JTree createExpandedTreeFromJson(String parameter, String rootName) {
        JTree result = StringUtils.createTreeFromJson(parameter, rootName);
        StringUtils.expandTreeAllNodes(result, 0, result.getRowCount());
        return result;
    }

    public static JTree createTreeFromJson(String parameter, String rootName) {
        Gson gson = new Gson();
        LinkedTreeMap paramMap = new LinkedTreeMap();
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(rootName);
        try {
            paramMap = (LinkedTreeMap)gson.fromJson(parameter, paramMap.getClass());
            StringUtils.createParameterTree(paramMap, parentNode, 0);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JTree(parentNode);
    }

    private static int createParameterTree(LinkedTreeMap params, DefaultMutableTreeNode parent, int childIndex) {
        int PARMETER_STEP_LIMIT = 9000;
        if (childIndex > 9000) {
            return childIndex;
        }
        if (params == null) {
            return childIndex;
        }
        int index = childIndex;
        DefaultMutableTreeNode root = parent;
        for (Object key : params.keySet()) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(key);
            Object value = params.get(key);
            if (value instanceof LinkedTreeMap) {
                root.add(child);
                index = StringUtils.createParameterTree((LinkedTreeMap)value, child, index++);
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList valueList = (ArrayList)value;
                if (!valueList.isEmpty() && valueList.get(0) instanceof LinkedTreeMap) {
                    root.add(child);
                    for (Object item : valueList) {
                        index = StringUtils.createParameterTree((LinkedTreeMap)item, child, index++);
                    }
                    continue;
                }
                String node = child + ":  " + value;
                root.add(new DefaultMutableTreeNode(node));
                continue;
            }
            String node = child + ":  " + value;
            root.add(new DefaultMutableTreeNode(node));
        }
        return index;
    }

    private static void expandTreeAllNodes(JTree tree, int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != rowCount) {
            StringUtils.expandTreeAllNodes(tree, rowCount, tree.getRowCount());
        }
    }
}

