/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command.ui;

import Preprocessing.JSpectrum;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.OutputFilePanel;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.mgf.MGFECleaner;
import fr.profi.mzknife.mzdb.MgfBoostConfigTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbCreateMgfPanel
extends AbstractCommandPanel<CommandArguments.MzDBCreateMgfCommand> {
    private JComboBox<String> precComputerCombo;
    private JTextField mzToleranceTF;
    private JTextField intensityCutoffTF;
    private JCheckBox prolineTitleCbx;
    private JComboBox<String> cleanMethodCombo;
    private JLabel cleanLabelingMethodLabel;
    private JLabel cleanConfigLabel;
    private JComboBox<String> cleanLabelingMethodCombo;
    private JComboBox<String> cleanConfigCombo;
    private final boolean showOutputTF;
    private static final Logger LOG = LoggerFactory.getLogger(MzdbCreateMgfPanel.class);
    private MgfBoostConfigTemplate mgfBoostConfigTemplate = null;
    private String buildCmdErrorMsg;
    private boolean buildCmdSuccess = true;
    private boolean updateOnGoing = false;

    public MzdbCreateMgfPanel() {
        this(true);
    }

    public MzdbCreateMgfPanel(boolean showOutputTF) {
        this.showOutputTF = showOutputTF;
        this.initComponents();
    }

    public MzdbCreateMgfPanel(CommandArguments.MzDBCreateMgfCommand command, boolean showOutputTF) {
        this(showOutputTF);
        this.updatePanelFromCommand(command);
    }

    public void setMgfBoostConfigTemplate(MgfBoostConfigTemplate mgfBoostConfigTemplate) {
        this.mgfBoostConfigTemplate = mgfBoostConfigTemplate;
        if (mgfBoostConfigTemplate != null) {
            String configName = "mgf_boost - " + mgfBoostConfigTemplate.toString();
            this.precComputerCombo.setSelectedItem(configName);
        } else {
            this.precComputerCombo.setSelectedItem("main_precursor_mz");
        }
    }

    public MgfBoostConfigTemplate getMgfBoostConfigTemplate() {
        return this.mgfBoostConfigTemplate;
    }

    @Override
    public boolean buildCommand(CommandArguments.MzDBCreateMgfCommand command) {
        this.buildCmdSuccess = true;
        this.buildCmdErrorMsg = "";
        if (this.showOutputTF) {
            command.outputFile = this.outputFilePanel.getOutputFilepath();
        }
        command.msLevel = 2;
        String[] precComputationParams = ((String)this.precComputerCombo.getSelectedItem()).split("-");
        command.precMzComputation = precComputationParams[0].trim().toLowerCase();
        if (command.precMzComputation.equalsIgnoreCase("mgf_boost")) {
            try {
                command.useHeader = this.mgfBoostConfigTemplate.isUseHeader();
                command.useSelectionWindow = this.mgfBoostConfigTemplate.isUseSelectionWindow();
                command.swMaxPrecursorsCount = this.mgfBoostConfigTemplate.getSwMaxPrecursorsCount();
                command.swIntensityThreshold = Float.valueOf(this.mgfBoostConfigTemplate.getSwIntensityThreshold());
                command.pifThreshold = this.mgfBoostConfigTemplate.getPifThreshold();
                command.rankThreshold = this.mgfBoostConfigTemplate.getRankThreshold();
                command.scanSelectorMode = CommandArguments.ScanSelectorMode.valueOf((String)this.mgfBoostConfigTemplate.getScanSelector().toString());
            }
            catch (IllegalArgumentException iae) {
                this.buildCmdSuccess = false;
                this.buildCmdErrorMsg = this.buildCmdErrorMsg + "\n";
                this.buildCmdErrorMsg = this.buildCmdErrorMsg + "MGF boost config template should be specified ";
            }
        }
        try {
            command.mzTolPPM = Float.valueOf(Float.parseFloat(this.mzToleranceTF.getText()));
            command.intensityCutoff = Float.valueOf(Float.parseFloat(this.intensityCutoffTF.getText()));
        }
        catch (NumberFormatException nfe) {
            if (!this.buildCmdSuccess) {
                this.buildCmdErrorMsg = this.buildCmdErrorMsg + "\n";
            }
            this.buildCmdErrorMsg = this.buildCmdErrorMsg + "Error reading mz Tolerance and/or intensity cutoff";
            this.buildCmdSuccess = false;
        }
        command.exportProlineTitle = this.prolineTitleCbx.isSelected();
        String cleanLabelingMethodName = (String)this.cleanLabelingMethodCombo.getSelectedItem();
        command.cleanMethod = (String)this.cleanMethodCombo.getSelectedItem();
        if (!command.cleanMethod.equalsIgnoreCase("None")) {
            command.cleanConfig = (CommandArguments.CleanConfig)this.cleanConfigCombo.getSelectedItem();
            String string = command.cleanLabelMethodName = cleanLabelingMethodName.equalsIgnoreCase("none") ? "" : cleanLabelingMethodName.toUpperCase();
            if (command.cleanConfig.equals((Object)CommandArguments.CleanConfig.TMT_LABELED)) {
                if (command.cleanLabelMethodName.isEmpty()) {
                    if (!this.buildCmdSuccess) {
                        this.buildCmdErrorMsg = this.buildCmdErrorMsg + "\n";
                    }
                    this.buildCmdErrorMsg = this.buildCmdErrorMsg + "clean labeling method should be specified for " + CommandArguments.CleanConfig.TMT_LABELED.getDisplayValue();
                    this.buildCmdSuccess = false;
                } else if (command.cleanMethod.equalsIgnoreCase("pClean")) {
                    try {
                        JSpectrum.IsobaricTag.valueOf((String)command.cleanLabelMethodName);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!this.buildCmdSuccess) {
                            this.buildCmdErrorMsg = this.buildCmdErrorMsg + "\n";
                        }
                        this.buildCmdErrorMsg = this.buildCmdErrorMsg + "Invalid labeling method specified for " + command.cleanMethod + ":  " + command.cleanLabelMethodName;
                        this.buildCmdSuccess = false;
                    }
                }
            }
        }
        if (!this.buildCmdSuccess) {
            LOG.warn(this.buildCmdErrorMsg);
        }
        return this.buildCmdSuccess;
    }

    @Override
    public void showErrorMessage() {
        if (!this.buildCmdSuccess) {
            JOptionPane.showMessageDialog(this, this.buildCmdErrorMsg, "Create Mgf", 0);
        }
    }

    public void updateComponents() {
        this.cleanConfigUpdated();
        this.cleanLabelingMethodUpdated();
        this.cleanMethodUpdated();
    }

    @Override
    public AbstractCommandPanel<CommandArguments.MzDBCreateMgfCommand> updatePanelFromCommand(CommandArguments.MzDBCreateMgfCommand command) {
        this.precComputerCombo.setSelectedItem(command.precMzComputation);
        this.mzToleranceTF.setText(Float.toString(command.mzTolPPM.floatValue()));
        this.intensityCutoffTF.setText(Float.toString(command.intensityCutoff.floatValue()));
        this.prolineTitleCbx.setSelected(command.exportProlineTitle);
        this.cleanMethodCombo.setSelectedItem(command.cleanMethod);
        this.cleanLabelingMethodCombo.setSelectedItem(command.cleanLabelMethodName.isEmpty() ? "None" : command.cleanLabelMethodName);
        return this;
    }

    private void initComponents() {
        JPanel precursorPanel = new JPanel();
        JLabel precComputerLabel = new JLabel();
        List<String> strings = Arrays.stream(MgfBoostConfigTemplate.values()).map(v -> "mgf_boost - " + v.toString()).collect(Collectors.toList());
        strings.add(0, "main_precursor_mz");
        String[] precComputerValues = strings.toArray(new String[0]);
        this.precComputerCombo = new JComboBox<String>(precComputerValues);
        this.precComputerCombo.addActionListener(e -> this.precComputerConfigUpdated());
        JLabel mzToleranceLabel = new JLabel();
        this.mzToleranceTF = new JTextField();
        JPanel optionsPanel = new JPanel();
        JLabel intensityCutoffLabel = new JLabel();
        this.intensityCutoffTF = new JTextField();
        this.prolineTitleCbx = new JCheckBox();
        JPanel fragmentsPanel = new JPanel();
        String[] cleanMethodValues = new String[]{"None", "eClean", "pClean"};
        this.cleanMethodCombo = new JComboBox<String>(cleanMethodValues);
        this.cleanMethodCombo.setSelectedIndex(0);
        this.cleanMethodCombo.addActionListener(e -> this.cleanMethodUpdated());
        this.cleanLabelingMethodLabel = new JLabel();
        List labelingMethods = Arrays.stream(MGFECleaner.IsobaricTag.values()).map(v -> v.name()).collect(Collectors.toList());
        labelingMethods.add(0, "None");
        String[] labelingMethodValues = (String[])labelingMethods.toArray(String[]::new);
        this.cleanLabelingMethodCombo = new JComboBox<String>(labelingMethodValues);
        this.cleanLabelingMethodCombo.setSelectedIndex(0);
        this.cleanLabelingMethodCombo.addActionListener(e -> this.cleanLabelingMethodUpdated());
        this.cleanConfigLabel = new JLabel();
        CommandArguments.CleanConfig[] configValues = CommandArguments.CleanConfig.values();
        this.cleanConfigCombo = new JComboBox<CommandArguments.CleanConfig>(configValues);
        this.cleanConfigCombo.addActionListener(e -> this.cleanConfigUpdated());
        this.cleanConfigCombo.setSelectedItem(CommandArguments.CleanConfig.LABEL_FREE);
        this.cleanMethodUpdated();
        this.setLayout(new GridBagLayout());
        Insets defaultInsets = new Insets(5, 5, 5, 5);
        GridBagConstraints insidePanelGBC = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, defaultInsets, 0, 0);
        GridBagConstraints globalPanelGBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        globalPanelGBC.gridx = 0;
        globalPanelGBC.gridy = 0;
        if (this.showOutputTF) {
            this.outputFilePanel = new OutputFilePanel();
            this.add((Component)this.outputFilePanel, globalPanelGBC);
            ++globalPanelGBC.gridy;
        }
        precursorPanel.setBorder(new TitledBorder("precursor"));
        precursorPanel.setLayout(new GridBagLayout());
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        precComputerLabel.setText("computation method:");
        precursorPanel.add((Component)precComputerLabel, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        precursorPanel.add(this.precComputerCombo, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.weightx = 0.0;
        insidePanelGBC.fill = 0;
        mzToleranceLabel.setText("mz tolerance (ppm):");
        precursorPanel.add((Component)mzToleranceLabel, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        precursorPanel.add((Component)this.mzToleranceTF, insidePanelGBC);
        this.add((Component)precursorPanel, globalPanelGBC);
        ++globalPanelGBC.gridy;
        optionsPanel.setBorder(new TitledBorder("options"));
        optionsPanel.setLayout(new GridBagLayout());
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        insidePanelGBC.weightx = 0.0;
        insidePanelGBC.fill = 0;
        intensityCutoffLabel.setText("intensity cutoff:");
        optionsPanel.add((Component)intensityCutoffLabel, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        optionsPanel.add((Component)this.intensityCutoffTF, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.gridwidth = 2;
        this.prolineTitleCbx.setText("format spectrum title for Proline");
        optionsPanel.add((Component)this.prolineTitleCbx, insidePanelGBC);
        this.add((Component)optionsPanel, globalPanelGBC);
        ++globalPanelGBC.gridy;
        fragmentsPanel.setBorder(new TitledBorder("fragmentation peaks"));
        fragmentsPanel.setLayout(new GridBagLayout());
        insidePanelGBC.gridx = 0;
        insidePanelGBC.gridy = 0;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 0;
        insidePanelGBC.gridwidth = 1;
        JLabel cleanMethodLabel = new JLabel();
        cleanMethodLabel.setText("clean Method:");
        fragmentsPanel.add((Component)cleanMethodLabel, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        fragmentsPanel.add(this.cleanMethodCombo, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.weightx = 0.0;
        insidePanelGBC.gridwidth = 1;
        insidePanelGBC.fill = 0;
        this.cleanConfigLabel.setText("clean Configuration:");
        fragmentsPanel.add((Component)this.cleanConfigLabel, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        fragmentsPanel.add(this.cleanConfigCombo, insidePanelGBC);
        insidePanelGBC.gridx = 0;
        ++insidePanelGBC.gridy;
        insidePanelGBC.weightx = 0.0;
        insidePanelGBC.gridwidth = 1;
        insidePanelGBC.fill = 0;
        this.cleanLabelingMethodLabel.setText("labeling method:");
        fragmentsPanel.add((Component)this.cleanLabelingMethodLabel, insidePanelGBC);
        ++insidePanelGBC.gridx;
        insidePanelGBC.weightx = 1.0;
        insidePanelGBC.fill = 1;
        fragmentsPanel.add(this.cleanLabelingMethodCombo, insidePanelGBC);
        this.add((Component)fragmentsPanel, globalPanelGBC);
    }

    private void precComputerConfigUpdated() {
        String[] precComputationParams = ((String)this.precComputerCombo.getSelectedItem()).split("-");
        this.mgfBoostConfigTemplate = precComputationParams[0].trim().toLowerCase().equalsIgnoreCase("mgf_boost") ? MgfBoostConfigTemplate.valueOf((String)precComputationParams[1].trim().toUpperCase()) : null;
    }

    private void cleanLabelingMethodUpdated() {
        if (this.updateOnGoing) {
            return;
        }
        try {
            this.updateOnGoing = true;
            if (!((String)this.cleanLabelingMethodCombo.getSelectedItem()).equalsIgnoreCase("none")) {
                this.cleanConfigCombo.setSelectedItem(CommandArguments.CleanConfig.TMT_LABELED);
            }
        }
        finally {
            this.updateOnGoing = false;
        }
    }

    private void cleanConfigUpdated() {
        if (this.updateOnGoing) {
            return;
        }
        try {
            this.updateOnGoing = true;
            if (!this.cleanConfigCombo.getSelectedItem().equals(CommandArguments.CleanConfig.TMT_LABELED)) {
                this.cleanLabelingMethodCombo.setEnabled(false);
                this.cleanLabelingMethodCombo.setSelectedIndex(0);
            } else {
                this.cleanLabelingMethodCombo.setEnabled(true);
            }
        }
        finally {
            this.updateOnGoing = false;
        }
    }

    private void cleanMethodUpdated() {
        if (this.updateOnGoing) {
            return;
        }
        try {
            this.updateOnGoing = true;
            if (this.cleanMethodCombo.getSelectedItem().toString().equalsIgnoreCase("none")) {
                this.cleanLabelingMethodLabel.setEnabled(false);
                this.cleanConfigLabel.setEnabled(false);
                this.cleanLabelingMethodCombo.setEnabled(false);
                this.cleanConfigCombo.setEnabled(false);
            } else {
                this.cleanLabelingMethodLabel.setEnabled(true);
                this.cleanConfigLabel.setEnabled(true);
                this.cleanConfigCombo.setEnabled(true);
                if (!this.cleanConfigCombo.getSelectedItem().equals(CommandArguments.CleanConfig.TMT_LABELED)) {
                    this.cleanLabelingMethodCombo.setEnabled(false);
                } else {
                    this.cleanLabelingMethodCombo.setEnabled(true);
                }
            }
        }
        finally {
            this.updateOnGoing = false;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setLayout(new BorderLayout());
        final MzdbCreateMgfPanel panel = new MzdbCreateMgfPanel();
        f.getContentPane().add((Component)panel, "Center");
        f.pack();
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CommandArguments.MzDBCreateMgfCommand command = new CommandArguments.MzDBCreateMgfCommand();
                if (panel.buildCommand(command)) {
                    System.out.println("Command args : " + ToStringBuilder.reflectionToString((Object)command));
                    System.exit(0);
                } else {
                    panel.showErrorMessage();
                }
            }
        });
        EventQueue.invokeLater(() -> f.setVisible(true));
    }
}

