/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.filelookup;

import fr.profi.mzDBWizard.filelookup.DirectoryWatcher;
import fr.profi.mzDBWizard.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherPoolMonitor
implements Runnable {
    private boolean m_run = false;
    private final int m_delayInSeconds;
    private final File m_lockFile;
    private final File m_monitoredDirectory;
    private final ThreadPoolExecutor m_executor;
    private final ArrayList<Long> m_dispatchTimes;
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public WatcherPoolMonitor(File monitoredDirectory, ThreadPoolExecutor executor, int delayInSeconds) {
        this.m_monitoredDirectory = monitoredDirectory;
        this.m_executor = executor;
        this.m_delayInSeconds = delayInSeconds;
        this.m_lockFile = new File(monitoredDirectory.getAbsolutePath() + File.separator + "mzdb.lock");
        this.m_dispatchTimes = new ArrayList();
    }

    @Override
    public void run() {
        this.m_run = true;
        while (this.m_run) {
            try {
                FileUtility.touch(this.m_lockFile);
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(WatcherPoolMonitor.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.m_executor.getActiveCount() == 0) {
                this.m_logger.debug("Dispatching a watcher service for directory " + this.m_monitoredDirectory.getAbsolutePath());
                try {
                    DirectoryWatcher m_directoryWatcher = new DirectoryWatcher();
                    this.m_executor.submit(m_directoryWatcher);
                    this.m_dispatchTimes.add(System.currentTimeMillis());
                }
                catch (IOException ex) {
                    java.util.logging.Logger.getLogger(WatcherPoolMonitor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                Thread.sleep(this.m_delayInSeconds * 1000);
            }
            catch (InterruptedException e) {
                this.m_logger.error("Interrupted!", (Throwable)e);
                this.m_run = false;
                return;
            }
        }
        this.m_run = false;
    }
}

