/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTextPaneAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger logger = LoggerFactory.getLogger(JTextPaneAppender.class);
    private final PatternLayoutEncoder m_encoder;
    private final JTextPane m_textPane;
    SimpleAttributeSet debugStyle;
    SimpleAttributeSet infoStyle;
    SimpleAttributeSet errorStyle;

    public JTextPaneAppender(JTextPane textPane) {
        this.m_textPane = textPane;
        this.initializeStyles();
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.setContext((Context)lc);
        lc.getLogger("ROOT").addAppender((Appender)this);
        lc.getLogger("ROOT").setLevel(Level.ALL);
        this.m_encoder = new PatternLayoutEncoder();
        this.m_encoder.setContext((Context)lc);
        this.m_encoder.setPattern("%date{dd MMM yyyy HH:mm:ss.SSS} [%thread] %-5level %logger{36} %mdc - %msg%n");
        this.m_encoder.start();
    }

    private void initializeStyles() {
        this.debugStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.debugStyle, "Arial");
        StyleConstants.setForeground(this.debugStyle, Color.BLUE);
        this.infoStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.infoStyle, "Arial");
        StyleConstants.setForeground(this.infoStyle, Color.BLACK);
        this.errorStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.errorStyle, "Arial Black");
        StyleConstants.setForeground(this.errorStyle, Color.RED);
    }

    public void start() {
        super.start();
    }

    public void append(final ILoggingEvent event) {
        this.m_encoder.encode((Object)event);
        final String line = event.getMessage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (event.getLevel() == Level.DEBUG) {
                        JTextPaneAppender.this.m_textPane.getDocument().insertString(JTextPaneAppender.this.m_textPane.getDocument().getLength(), line, JTextPaneAppender.this.debugStyle);
                        JTextPaneAppender.this.m_textPane.getDocument().insertString(JTextPaneAppender.this.m_textPane.getDocument().getLength(), "\n", null);
                    } else if (event.getLevel() == Level.INFO) {
                        JTextPaneAppender.this.m_textPane.getDocument().insertString(JTextPaneAppender.this.m_textPane.getDocument().getLength(), line, JTextPaneAppender.this.infoStyle);
                        JTextPaneAppender.this.m_textPane.getDocument().insertString(JTextPaneAppender.this.m_textPane.getDocument().getLength(), "\n", null);
                    } else if (event.getLevel() == Level.ERROR) {
                        JTextPaneAppender.this.m_textPane.getDocument().insertString(JTextPaneAppender.this.m_textPane.getDocument().getLength(), line, JTextPaneAppender.this.errorStyle);
                        JTextPaneAppender.this.m_textPane.getDocument().insertString(JTextPaneAppender.this.m_textPane.getDocument().getLength(), "\n", null);
                    }
                }
                catch (BadLocationException ex) {
                    logger.error("BadLocationException exception!");
                }
            }
        });
    }
}

