/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.gui.overview;

import fr.profi.mzDBWizard.gui.overview.AttributeEntry;
import fr.profi.mzDBWizard.gui.overview.AttributesTableModel;
import fr.profi.mzDBWizard.gui.overview.ExecutionTableRenderer;
import fr.profi.mzDBWizard.processing.info.TaskInfoManager;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class OverviewScrollPane
extends JScrollPane {
    private AttributesTableModel m_executionTableModel;
    private JTable m_executionTable;
    private static OverviewScrollPane m_singleton = null;

    private OverviewScrollPane() {
        this.init();
    }

    public static OverviewScrollPane getSingleton() {
        if (m_singleton == null) {
            m_singleton = new OverviewScrollPane();
        }
        return m_singleton;
    }

    private void init() {
        this.m_executionTableModel = new AttributesTableModel(TaskInfoManager.getTaskInfoManager().getExecutionModelData());
        this.m_executionTable = new JTable(this.m_executionTableModel);
        this.m_executionTable.setPreferredScrollableViewportSize(new Dimension(this.m_executionTable.getWidth(), 130));
        this.m_executionTable.setTableHeader(null);
        this.m_executionTable.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.m_executionTable.setRowHeight(20);
        this.m_executionTable.setRowSelectionAllowed(true);
        this.m_executionTable.setDefaultRenderer(Object.class, new ExecutionTableRenderer());
        this.getViewport().add(this.m_executionTable);
        this.m_executionTable.setMinimumSize(new Dimension(this.m_executionTable.getWidth(), 130));
        this.setMinimumSize(new Dimension(this.m_executionTable.getWidth(), 130));
        this.setPreferredSize(new Dimension(this.m_executionTable.getWidth(), 130));
        this.validate();
        this.repaint();
    }

    public void update(ArrayList<AttributeEntry> attributes) {
        int[] selection = this.m_executionTable.getSelectedRows();
        this.m_executionTableModel.update(attributes);
        if (selection != null && selection.length > 0) {
            this.m_executionTable.setRowSelectionInterval(selection[0], selection[selection.length - 1]);
        }
    }
}

