/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.jms.queue;

import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.processing.jms.queue.AccessJMSManagerThread;
import fr.profi.mzDBWizard.processing.jms.queue.ConnectionListener;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.swing.event.EventListenerList;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSConnectionManager {
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"mzDB-Task");
    public static final String DEFAULT_SERVICE_REQUEST_QUEUE_NAME = "ProlineServiceRequestQueue";
    public static final String PROLINE_NODE_ID_KEY = "Proline_NodeId";
    public static final String PROLINE_SERVICE_NAME_KEY = "Proline_ServiceName";
    public static final String PROLINE_SERVICE_VERSION_KEY = "Proline_ServiceVersion";
    public static final String PROLINE_SERVICE_SOURCE_KEY = "Proline_ServiceSource";
    public static final String PROLINE_SERVICE_DESCR_KEY = "Proline_ServiceDescription";
    public static final String HORNET_Q_SAVE_STREAM_KEY = "JMS_HQ_SaveStream";
    public static final String HORNET_Q_INPUT_STREAM_KEY = "JMS_HQ_InputStream";
    public static final String JMS_SERVER_HOST_PARAM_KEY = "jms.server.host";
    public static final String JMS_SERVER_PORT_PARAM_KEY = "jms.server.port";
    public static final int JMS_CANCELLED_TASK_ERROR_CODE = -32004;
    public static final int JMS_EXPIRED_MSG_ERROR_CODE = -32003;
    private final EventListenerList m_connectionListenersList = new EventListenerList();
    private int m_connectionState = 0;
    public String m_jmsServerHost = null;
    public static int m_jmsServerPort = 5445;
    private Connection m_connection = null;
    private Queue m_serviceQueue = null;
    private Session m_mainSession = null;
    private static JMSConnectionManager m_jmsConnectionManager = null;

    private JMSConnectionManager() {
    }

    public static synchronized JMSConnectionManager getJMSConnectionManager() {
        if (m_jmsConnectionManager == null) {
            m_jmsConnectionManager = new JMSConnectionManager();
        }
        return m_jmsConnectionManager;
    }

    public int getConnectionState() {
        return this.m_connectionState;
    }

    private void resetConnObjects() {
        this.m_connection = null;
        this.m_serviceQueue = null;
        this.m_mainSession = null;
        this.m_connectionState = 0;
        this.fireConnectionStateChanged(0);
    }

    public void setJMSServerHost(String jmsHost) {
        this.m_jmsServerHost = jmsHost;
        this.resetConnObjects();
    }

    public void setJMSServerPort(int jmsPort) {
        m_jmsServerPort = jmsPort;
        this.resetConnObjects();
    }

    public Connection getJMSConnection() throws Exception {
        if (this.m_connection == null) {
            this.createConnection();
        }
        return this.m_connection;
    }

    public Queue getServiceQueue() throws Exception {
        if (this.m_serviceQueue == null) {
            this.createConnection();
        }
        return this.m_serviceQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConnection() throws JMSException {
        try {
            if (this.m_jmsServerHost == null) {
                throw new RuntimeException("JMS Host not defined ! ");
            }
            String queueName = ConfigurationManager.getServiceRequestQueueName();
            m_loggerProline.info(" Use JMS Queure " + queueName);
            this.m_serviceQueue = HornetQJMSClient.createQueue((String)queueName);
            HashMap<String, Object> connectionParams = new HashMap<String, Object>();
            connectionParams.put("host", this.m_jmsServerHost);
            connectionParams.put("port", m_jmsServerPort);
            TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams);
            HornetQConnectionFactory cf = HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            cf.setReconnectAttempts(10);
            this.m_connection = cf.createConnection();
            this.m_mainSession = this.m_connection.createSession(false, 1);
            this.m_connectionState = 3;
            this.fireConnectionStateChanged(3);
        }
        catch (RuntimeException | JMSException je) {
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                    m_loggerProline.info("JMS Connection closed on error " + je.getMessage());
                }
                catch (Exception exClose) {
                    m_loggerProline.error("Error closing JMS Connection", (Throwable)exClose);
                }
                finally {
                    this.resetConnObjects();
                }
            }
            this.m_connectionState = 2;
            this.fireConnectionStateChanged(2);
            throw je;
        }
    }

    public void closeConnection() {
        if (this.m_connection != null) {
            try {
                AccessJMSManagerThread.getAccessJMSManagerThread().cleanup();
                this.m_mainSession.close();
                this.m_connection.close();
                m_loggerProline.info("JMS Connection closed");
            }
            catch (Exception exClose) {
                m_loggerProline.error("Error closing JMS Connection", (Throwable)exClose);
            }
            finally {
                this.m_connection = null;
            }
        }
        this.resetConnObjects();
        this.m_jmsServerHost = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        EventListenerList eventListenerList = this.m_connectionListenersList;
        synchronized (eventListenerList) {
            this.m_connectionListenersList.add(ConnectionListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        EventListenerList eventListenerList = this.m_connectionListenersList;
        synchronized (eventListenerList) {
            this.m_connectionListenersList.remove(ConnectionListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionStateChanged(int newConnState) {
        EventListenerList eventListenerList = this.m_connectionListenersList;
        synchronized (eventListenerList) {
            ConnectionListener[] allListeners;
            for (ConnectionListener nextOne : allListeners = (ConnectionListener[])this.m_connectionListenersList.getListeners(ConnectionListener.class)) {
                nextOne.connectionStateChanged(newConnState);
            }
        }
    }
}

