/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.jms.task;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.profi.mzDBWizard.configuration.ConfigurationManager;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSCallback;
import fr.profi.mzDBWizard.processing.jms.queue.AbstractJMSTask;
import fr.profi.mzDBWizard.processing.jms.queue.AccessJMSManagerThread;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class MountingPathJMSTask
extends AbstractJMSTask {
    private static final String FILESYSTEM_SERVICE_NAME = "proline/misc/FileSystem";
    private static final String METHOD_NAME = "retrieve_all_mount_points";

    public MountingPathJMSTask(AbstractJMSCallback callback) {
        super(callback, new TaskInfo("Retrieve Mounting Points", 3, false, TaskInfo.VisibilityEnum.VISIBLE_IF_ERROR));
    }

    @Override
    public void taskRun() throws JMSException {
        String log = "Look for mounting paths";
        m_logger.debug(log);
        this.m_taskInfo.addLog(log);
        JSONRPC2Request jsonRequest = new JSONRPC2Request(METHOD_NAME, (Object)this.m_taskInfo.getId());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty(ConfigurationManager.getProlineServiceNameKey(), FILESYSTEM_SERVICE_NAME);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_logger.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_logger.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_logger.debug("JSON Response Id: " + String.valueOf(jsonResponse.getID()));
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_logger.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_logger.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !ArrayList.class.isInstance(result)) {
                m_logger.debug("Invalid result: No projectId returned");
                throw new Exception("Invalid result " + String.valueOf(result));
            }
            m_logger.debug("Result :\n" + String.valueOf(result));
            ArrayList<String> pathLabels = new ArrayList<String>();
            ArrayList resultList = (ArrayList)result;
            for (int i = 0; i < resultList.size(); ++i) {
                Map fileMap = (Map)resultList.get(i);
                String label = (String)fileMap.get("label");
                String directoryType = (String)fileMap.get("directory_type");
                if (!directoryType.equalsIgnoreCase("mzdb_files")) continue;
                pathLabels.add(label);
            }
            ConfigurationManager.setMoutingPointPathLabels(pathLabels);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
        String log = "Finished to look for mounting paths";
        m_logger.debug(log);
        this.m_taskInfo.addLog(log);
    }
}

