/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.queue;

import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.queue.AbstractTaskWithInfo;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
extends AbstractTaskWithInfo {
    protected AbstractCallback m_callback;
    protected Long m_id;
    private static long m_idIncrement = 0L;
    protected TaskError m_taskError = null;
    protected int m_errorId = -1;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public AbstractTask(AbstractCallback callback, TaskInfo taskInfo) {
        super(taskInfo);
        this.m_callback = callback;
        this.logger.debug("Task Info " + taskInfo.getTaskDescription());
        if (++m_idIncrement == Long.MAX_VALUE) {
            m_idIncrement = 0L;
        }
        this.m_id = m_idIncrement;
    }

    public abstract int getType();

    public abstract String getUniqueKey();

    public abstract boolean precheck() throws Exception;

    public abstract boolean runTask();

    public void callback(final boolean success) {
        if (this.m_callback == null) {
            this.getTaskInfo().setFinished(success, this.m_taskError, true);
            return;
        }
        this.m_callback.setErrorMessage(this.m_taskError, this.m_errorId);
        if (this.m_callback.mustBeCalledInAWT()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractTask.this.m_callback.run(success, AbstractTask.this.m_id);
                    AbstractTask.this.getTaskInfo().setFinished(success, AbstractTask.this.getTaskError(), true);
                }
            });
        } else {
            this.m_callback.run(success, this.m_id);
            this.getTaskInfo().setFinished(success, this.getTaskError(), true);
        }
    }

    public TaskError getTaskError() {
        return this.m_taskError;
    }
}

