/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzDBWizard.processing.threading.task;

import fr.profi.mzDBWizard.processing.info.TaskError;
import fr.profi.mzDBWizard.processing.info.TaskInfo;
import fr.profi.mzDBWizard.processing.threading.AbstractCallback;
import fr.profi.mzDBWizard.processing.threading.task.AbstractFileTask;
import fr.profi.mzDBWizard.processing.threading.task.callback.SplitExplorisMzdbCallback;
import fr.profi.mzknife.mzdb.MzDBSplitter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SplitExplorisMzdbTask
extends AbstractFileTask {
    List<File> m_outFiles = new ArrayList<File>();

    public SplitExplorisMzdbTask(AbstractCallback callback, File sourceMzdbFile) {
        super(callback, new TaskInfo("Split mzdb " + sourceMzdbFile.getName(), 4, true, TaskInfo.VisibilityEnum.VISIBLE), sourceMzdbFile);
    }

    @Override
    public int getType() {
        return 3;
    }

    private void setCallbackFiles() {
        if (SplitExplorisMzdbCallback.class.isInstance(this.m_callback)) {
            ((SplitExplorisMzdbCallback)this.m_callback).setMzdbFiles(this.m_outFiles);
        }
    }

    @Override
    protected boolean runTaskImplementation() throws Exception {
        this.logger.debug("  -->  Split file " + this.getFile().getName());
        MzDBSplitter splitter = new MzDBSplitter(this.getFile());
        String tempSplitSuffix = ".split.mzdb.tmp";
        splitter.setOutputFileExtension(tempSplitSuffix);
        boolean splitSuccess = splitter.splitMzDbFile();
        if (!splitSuccess) {
            MzDBSplitter.RETURN_CODE returnCode = splitter.getFinishStateCode();
            if (returnCode.equals((Object)MzDBSplitter.RETURN_CODE.NOT_EXPLORIS) || returnCode.equals((Object)MzDBSplitter.RETURN_CODE.NO_CVS)) {
                this.m_taskInfo.addLog("No split done. File is not an Exploris or has no CVs.");
                this.m_outFiles.add(this.getFile());
                this.setCallbackFiles();
                return true;
            }
            this.m_taskError = new TaskError("Split of mzdb File Failure", "File " + this.getFile().getAbsolutePath());
            String log2 = "File " + this.getFile().getAbsolutePath() + " could not be splitted.";
            this.logger.debug(log2);
            this.m_taskInfo.addLog(log2);
            this.setCallbackFiles();
            return false;
        }
        this.m_outFiles = splitter.getOutputMzdbFiles();
        this.logger.info(" END Splitting {} into {} files : ", (Object)this.getFile().getName(), (Object)this.m_outFiles.size());
        StringBuilder msg = new StringBuilder(" END Splitting ");
        msg.append(this.getFile().getName()).append(" into ").append(this.m_outFiles.size()).append("files : ");
        ArrayList<File> newFile = new ArrayList<File>();
        for (File f : this.m_outFiles) {
            String trueFileName = f.getName().substring(0, f.getName().length() - 4);
            File trueFile = new File(f.getParentFile(), trueFileName);
            boolean result = f.renameTo(trueFile);
            this.logger.info(" Output File: {} should be {}. rename result {}", new Object[]{f.getAbsolutePath(), trueFile.getAbsolutePath(), result});
            msg.append(f.getName()).append(";");
            newFile.add(trueFile);
        }
        this.m_outFiles = newFile;
        this.m_taskInfo.addLog(msg.toString());
        this.setCallbackFiles();
        return true;
    }
}

