/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.data.domain.finance.portfolio.SimpleAsset;
import org.ojalgo.data.domain.finance.portfolio.SimplePortfolio;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.TypeUtils;

abstract class EquilibriumModel
extends FinancePortfolio
implements FinancePortfolio.Context {
    private transient MatrixR064 myAssetReturns;
    private transient MatrixR064 myAssetVolatilities;
    private transient MatrixR064 myAssetWeights;
    private final MarketEquilibrium myMarketEquilibrium;
    private transient Scalar<?> myMeanReturn;
    private transient Scalar<?> myReturnVariance;

    protected EquilibriumModel(FinancePortfolio.Context portfolioContext) {
        this.myMarketEquilibrium = new MarketEquilibrium(portfolioContext.getCovariances());
    }

    protected EquilibriumModel(MarketEquilibrium marketEquilibrium) {
        this.myMarketEquilibrium = marketEquilibrium.copy();
    }

    @Override
    public final double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        MatrixR064 tmpAssetWeights = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{tmpWeights});
        MatrixR064 tmpAssetReturns = this.getAssetReturns();
        return this.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns).doubleValue();
    }

    @Override
    public final double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        MatrixR064 tmpAssetWeights = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{tmpWeights});
        return this.calculatePortfolioVariance(tmpAssetWeights).doubleValue();
    }

    @Override
    public final MatrixR064 getAssetReturns() {
        if (this.myAssetReturns == null) {
            this.myAssetReturns = this.calculateAssetReturns();
        }
        return this.myAssetReturns;
    }

    @Override
    public final MatrixR064 getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            this.myAssetVolatilities = this.myMarketEquilibrium.toCorrelations();
        }
        return this.myAssetVolatilities;
    }

    public final MatrixR064 getAssetWeights() {
        if (this.myAssetWeights == null) {
            this.myAssetWeights = this.calculateAssetWeights();
        }
        return this.myAssetWeights;
    }

    @Override
    public final MatrixR064 getCorrelations() {
        return this.myMarketEquilibrium.toCorrelations();
    }

    @Override
    public final MatrixR064 getCovariances() {
        return this.myMarketEquilibrium.getCovariances();
    }

    public final MarketEquilibrium getMarketEquilibrium() {
        return this.myMarketEquilibrium.copy();
    }

    @Override
    public final double getMeanReturn() {
        if (this.myMeanReturn == null) {
            MatrixR064 tmpAssetWeights = this.getAssetWeights();
            MatrixR064 tmpAssetReturns = this.getAssetReturns();
            if (tmpAssetWeights != null && tmpAssetReturns != null) {
                this.myMeanReturn = this.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns);
            }
        }
        return this.myMeanReturn.doubleValue();
    }

    @Override
    public final double getReturnVariance() {
        if (this.myReturnVariance == null) {
            this.myReturnVariance = this.calculatePortfolioVariance(this.getAssetWeights());
        }
        return this.myReturnVariance.doubleValue();
    }

    public final Scalar<?> getRiskAversion() {
        return this.myMarketEquilibrium.getRiskAversion();
    }

    public final String[] getSymbols() {
        return this.myMarketEquilibrium.getAssetKeys();
    }

    @Override
    public final List<BigDecimal> getWeights() {
        MatrixR064 tmpAssetWeights = this.getAssetWeights();
        if (tmpAssetWeights != null) {
            return Array1D.R256.copy((Access1D)tmpAssetWeights);
        }
        return null;
    }

    public final void setRiskAversion(Comparable<?> factor) {
        this.myMarketEquilibrium.setRiskAversion(factor);
        this.reset();
    }

    @Override
    public int size() {
        return this.myMarketEquilibrium.size();
    }

    public final List<SimpleAsset> toSimpleAssets() {
        MatrixR064 tmpReturns = this.getAssetReturns();
        MatrixR064 tmpCovariances = this.getCovariances();
        List<BigDecimal> tmpWeights = this.getWeights();
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(tmpWeights.size());
        for (int i = 0; i < tmpWeights.size(); ++i) {
            double tmpMeanReturn = tmpReturns.doubleValue(i, 0L);
            double tmpVolatility = PrimitiveMath.SQRT.invoke(tmpCovariances.doubleValue(i, i));
            BigDecimal tmpWeight = tmpWeights.get(i);
            retVal.add(new SimpleAsset(Double.valueOf(tmpMeanReturn), Double.valueOf(tmpVolatility), tmpWeight));
        }
        return retVal;
    }

    public final SimplePortfolio toSimplePortfolio() {
        return new SimplePortfolio(this.getCorrelations(), this.toSimpleAssets());
    }

    @Override
    public String toString() {
        return TypeUtils.format("RAF={} {}", this.getRiskAversion().toString(), super.toString());
    }

    protected abstract MatrixR064 calculateAssetReturns();

    protected final MatrixR064 calculateAssetReturns(MatrixR064 aWeightsVctr) {
        return this.myMarketEquilibrium.calculateAssetReturns(aWeightsVctr);
    }

    protected abstract MatrixR064 calculateAssetWeights();

    protected final MatrixR064 calculateAssetWeights(MatrixR064 aReturnsVctr) {
        return this.myMarketEquilibrium.calculateAssetWeights(aReturnsVctr);
    }

    protected final Scalar<?> calculatePortfolioReturn(MatrixR064 aWeightsVctr, MatrixR064 aReturnsVctr) {
        return MarketEquilibrium.calculatePortfolioReturn(aWeightsVctr, aReturnsVctr);
    }

    protected final Scalar<?> calculatePortfolioVariance(MatrixR064 aWeightsVctr) {
        return this.myMarketEquilibrium.calculatePortfolioVariance(aWeightsVctr);
    }

    protected final void calibrate(MatrixR064 aWeightsVctr, MatrixR064 aReturnsVctr) {
        Scalar<?> tmpRiskAvesrion = this.myMarketEquilibrium.calculateImpliedRiskAversion(aWeightsVctr, aReturnsVctr);
        this.setRiskAversion((Comparable)tmpRiskAvesrion.get());
    }

    @Override
    protected void reset() {
        this.myAssetWeights = null;
        this.myAssetReturns = null;
        this.myMeanReturn = null;
        this.myReturnVariance = null;
    }

    final boolean isDefaultRiskAversion() {
        return this.myMarketEquilibrium.isDefaultRiskAversion();
    }
}

