/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PredicateFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.QuadrupleAggregator;
import org.ojalgo.function.constant.QuadrupleMath;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.type.context.NumberContext;

public final class QuadrupleFunction
extends FunctionSet<Quadruple> {
    private static final QuadrupleFunction SET = new QuadrupleFunction();

    public static QuadrupleFunction getSet() {
        return SET;
    }

    private QuadrupleFunction() {
    }

    @Override
    public UnaryFunction<Quadruple> abs() {
        return QuadrupleMath.ABS;
    }

    @Override
    public UnaryFunction<Quadruple> acos() {
        return QuadrupleMath.ACOS;
    }

    @Override
    public UnaryFunction<Quadruple> acosh() {
        return QuadrupleMath.ACOSH;
    }

    @Override
    public BinaryFunction<Quadruple> add() {
        return QuadrupleMath.ADD;
    }

    @Override
    public AggregatorSet<Quadruple> aggregator() {
        return QuadrupleAggregator.getSet();
    }

    @Override
    public UnaryFunction<Quadruple> asin() {
        return QuadrupleMath.ASIN;
    }

    @Override
    public UnaryFunction<Quadruple> asinh() {
        return QuadrupleMath.ASINH;
    }

    @Override
    public UnaryFunction<Quadruple> atan() {
        return QuadrupleMath.ATAN;
    }

    @Override
    public BinaryFunction<Quadruple> atan2() {
        return QuadrupleMath.ATAN2;
    }

    @Override
    public UnaryFunction<Quadruple> atanh() {
        return QuadrupleMath.ATANH;
    }

    @Override
    public UnaryFunction<Quadruple> cardinality() {
        return QuadrupleMath.CARDINALITY;
    }

    @Override
    public UnaryFunction<Quadruple> cbrt() {
        return QuadrupleMath.CBRT;
    }

    @Override
    public UnaryFunction<Quadruple> ceil() {
        return QuadrupleMath.CEIL;
    }

    @Override
    public UnaryFunction<Quadruple> conjugate() {
        return QuadrupleMath.CONJUGATE;
    }

    @Override
    public UnaryFunction<Quadruple> cos() {
        return QuadrupleMath.COS;
    }

    @Override
    public UnaryFunction<Quadruple> cosh() {
        return QuadrupleMath.COSH;
    }

    @Override
    public BinaryFunction<Quadruple> divide() {
        return QuadrupleMath.DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> Quadruple.valueOf(context.enforce(t));
    }

    @Override
    public UnaryFunction<Quadruple> exp() {
        return QuadrupleMath.EXP;
    }

    @Override
    public UnaryFunction<Quadruple> expm1() {
        return QuadrupleMath.EXPM1;
    }

    @Override
    public UnaryFunction<Quadruple> floor() {
        return QuadrupleMath.FLOOR;
    }

    @Override
    public BinaryFunction<Quadruple> hypot() {
        return QuadrupleMath.HYPOT;
    }

    @Override
    public UnaryFunction<Quadruple> invert() {
        return QuadrupleMath.INVERT;
    }

    @Override
    public UnaryFunction<Quadruple> log() {
        return QuadrupleMath.LOG;
    }

    @Override
    public UnaryFunction<Quadruple> log10() {
        return QuadrupleMath.LOG10;
    }

    @Override
    public UnaryFunction<Quadruple> log1p() {
        return QuadrupleMath.LOG1P;
    }

    @Override
    public UnaryFunction<Quadruple> logistic() {
        return QuadrupleMath.LOGISTIC;
    }

    @Override
    public UnaryFunction<Quadruple> logit() {
        return QuadrupleMath.LOGIT;
    }

    @Override
    public BinaryFunction<Quadruple> max() {
        return QuadrupleMath.MAX;
    }

    @Override
    public BinaryFunction<Quadruple> min() {
        return QuadrupleMath.MIN;
    }

    @Override
    public BinaryFunction<Quadruple> multiply() {
        return QuadrupleMath.MULTIPLY;
    }

    @Override
    public UnaryFunction<Quadruple> negate() {
        return QuadrupleMath.NEGATE;
    }

    @Override
    public BinaryFunction<Quadruple> pow() {
        return QuadrupleMath.POW;
    }

    @Override
    public ParameterFunction<Quadruple> power() {
        return QuadrupleMath.POWER;
    }

    @Override
    public UnaryFunction<Quadruple> rint() {
        return QuadrupleMath.RINT;
    }

    @Override
    public ParameterFunction<Quadruple> root() {
        return QuadrupleMath.ROOT;
    }

    @Override
    public ParameterFunction<Quadruple> scale() {
        return QuadrupleMath.SCALE;
    }

    @Override
    public UnaryFunction<Quadruple> signum() {
        return QuadrupleMath.SIGNUM;
    }

    @Override
    public UnaryFunction<Quadruple> sin() {
        return QuadrupleMath.SIN;
    }

    @Override
    public UnaryFunction<Quadruple> sinh() {
        return QuadrupleMath.SINH;
    }

    @Override
    public UnaryFunction<Quadruple> sqrt() {
        return QuadrupleMath.SQRT;
    }

    @Override
    public UnaryFunction<Quadruple> sqrt1px2() {
        return QuadrupleMath.SQRT1PX2;
    }

    @Override
    public BinaryFunction<Quadruple> subtract() {
        return QuadrupleMath.SUBTRACT;
    }

    @Override
    public UnaryFunction<Quadruple> tan() {
        return QuadrupleMath.TAN;
    }

    @Override
    public UnaryFunction<Quadruple> tanh() {
        return QuadrupleMath.TANH;
    }

    @Override
    public UnaryFunction<Quadruple> value() {
        return QuadrupleMath.VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Quadruple> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(Quadruple.valueOf(arg)).doubleValue();
        }

        @Override
        default public float invoke(float arg) {
            return this.invoke(Quadruple.valueOf(arg)).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Predicate
    extends PredicateFunction<Quadruple> {
        @Override
        default public boolean invoke(double arg) {
            return this.invoke(Quadruple.valueOf(arg));
        }

        @Override
        default public boolean invoke(float arg) {
            return this.invoke(Quadruple.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Quadruple> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(Quadruple.valueOf(arg), param).doubleValue();
        }

        @Override
        default public float invoke(float arg, int param) {
            return this.invoke(Quadruple.valueOf(arg), param).floatValue();
        }
    }

    @FunctionalInterface
    public static interface Consumer
    extends VoidFunction<Quadruple> {
        @Override
        default public void invoke(double arg) {
            this.invoke(Quadruple.valueOf(arg));
        }

        @Override
        default public void invoke(float arg) {
            this.invoke(Quadruple.valueOf(arg));
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Quadruple> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(Quadruple.valueOf(arg1), Quadruple.valueOf(arg2)).doubleValue();
        }

        @Override
        default public float invoke(float arg1, float arg2) {
            return this.invoke(Quadruple.valueOf(arg1), Quadruple.valueOf(arg2)).floatValue();
        }
    }
}

