/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.ojalgo.machine.JavaType;

public final class MemoryEstimator {
    private static final long FINAL_ALIGNEMENT = 8L;
    private static final long PARENT_ALIGNEMENT = 4L;
    private static final long WORD = 8L;
    private static final long ZERO = 0L;
    private long myShallowSize = 0L;

    public static long estimateArray(Class<?> componentType, int length) {
        MemoryEstimator estimator = MemoryEstimator.makeForClassExtendingObject();
        estimator.add(JavaType.INT.memory());
        JavaType match = JavaType.match(componentType);
        estimator.add((long)length * match.memory());
        return estimator.estimate();
    }

    public static long estimateObject(Class<?> type) {
        return MemoryEstimator.make(type).estimate();
    }

    public static MemoryEstimator makeForClassExtendingObject() {
        return new MemoryEstimator(8L + JavaType.REFERENCE.memory());
    }

    public static MemoryEstimator makeForSubclass(MemoryEstimator parentEstimation) {
        return new MemoryEstimator(parentEstimation.align(4L));
    }

    static MemoryEstimator make(Class<?> type) {
        MemoryEstimator retVal = null;
        Class<?> tmpParent = type.getSuperclass();
        if (Object.class.equals(tmpParent)) {
            retVal = MemoryEstimator.makeForClassExtendingObject();
        } else {
            MemoryEstimator tmpParentEstimation = MemoryEstimator.make(tmpParent);
            retVal = MemoryEstimator.makeForSubclass(tmpParentEstimation);
        }
        for (Field tmpField : type.getDeclaredFields()) {
            int tmpModifier = tmpField.getModifiers();
            if (Modifier.isStatic(tmpModifier)) continue;
            Class<?> tmpType = tmpField.getType();
            retVal.add(JavaType.match(tmpType));
        }
        return retVal;
    }

    private MemoryEstimator() {
        this(0L);
    }

    MemoryEstimator(long aBase) {
        this.myShallowSize = aBase;
    }

    public MemoryEstimator add(Class<?> type) {
        return this.add(JavaType.match(type));
    }

    public MemoryEstimator add(JavaType type) {
        return this.add(type.memory());
    }

    public long estimate() {
        return this.align(8L);
    }

    private MemoryEstimator add(long bytes) {
        this.myShallowSize += bytes;
        return this;
    }

    private long align(long alignement) {
        long remainder = this.myShallowSize % alignement;
        if (remainder != 0L) {
            return this.myShallowSize + (alignement - remainder);
        }
        return this.myShallowSize;
    }
}

