/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.AffineFunction;
import org.ojalgo.function.multiary.ConstantFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.PureQuadraticFunction;
import org.ojalgo.function.multiary.QuadraticFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public final class Expression
extends ModelEntity<Expression> {
    private BigDecimal myConstant = null;
    private transient boolean myInfeasible = false;
    private transient Boolean myInteger = null;
    private final Map<Structure1D.IntIndex, BigDecimal> myLinear;
    private final ExpressionsBasedModel myModel;
    private final Map<Structure2D.IntRowColumn, BigDecimal> myQuadratic;
    private transient boolean myRedundant = false;
    private final boolean myShallowCopy;

    private Expression(Expression entityToCopy) {
        this(entityToCopy, null, false);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected Expression(Expression expressionToCopy, ExpressionsBasedModel destinationModel, boolean deep) {
        super(expressionToCopy);
        this.myModel = destinationModel;
        this.myConstant = expressionToCopy.getConstant();
        if (deep) {
            this.myShallowCopy = false;
            this.myLinear = new HashMap<Structure1D.IntIndex, BigDecimal>();
            this.myLinear.putAll(expressionToCopy.getLinear());
            this.myQuadratic = new HashMap<Structure2D.IntRowColumn, BigDecimal>();
            this.myQuadratic.putAll(expressionToCopy.getQuadratic());
        } else {
            this.myShallowCopy = true;
            this.myLinear = expressionToCopy.getLinear();
            this.myQuadratic = expressionToCopy.getQuadratic();
        }
        this.myInteger = expressionToCopy.isInteger() ? Boolean.TRUE : null;
    }

    Expression(String name, ExpressionsBasedModel model) {
        super(name);
        ProgrammingError.throwIfNull((Object)name, (Object)model);
        this.myModel = model;
        this.myShallowCopy = false;
        this.myLinear = new HashMap<Structure1D.IntIndex, BigDecimal>();
        this.myQuadratic = new HashMap<Structure2D.IntRowColumn, BigDecimal>();
    }

    public Expression add(int index, Comparable<?> value) {
        return this.add(this.myModel.getVariable(index), value);
    }

    public Expression add(int index, double value) {
        return this.add(index, BigDecimal.valueOf(value));
    }

    public Expression add(int row, int column, Comparable<?> value) {
        return this.add(new Structure2D.IntRowColumn(row, column), value);
    }

    public Expression add(int row, int column, double value) {
        return this.add(row, column, BigDecimal.valueOf(value));
    }

    public Expression add(int row, int column, long value) {
        return this.add(row, column, BigDecimal.valueOf(value));
    }

    public Expression add(int index, long value) {
        return this.add(index, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression add(Structure1D.IntIndex key, Comparable<?> value) {
        BigDecimal existing = this.myLinear.get(key);
        if (existing != null) {
            this.set(key, ModelEntity.toBigDecimal(value).add(existing));
        } else {
            this.set(key, value);
        }
        return this;
    }

    @Deprecated
    public Expression add(Structure1D.IntIndex key, double value) {
        return this.add(key, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression add(Structure1D.IntIndex row, Structure1D.IntIndex column, Comparable<?> value) {
        return this.add(new Structure2D.IntRowColumn(row, column), value);
    }

    @Deprecated
    public Expression add(Structure1D.IntIndex row, Structure1D.IntIndex column, double value) {
        return this.add(row, column, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression add(Structure1D.IntIndex row, Structure1D.IntIndex column, long value) {
        return this.add(row, column, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression add(Structure1D.IntIndex key, long value) {
        return this.add(key, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression add(Structure2D.IntRowColumn key, Comparable<?> value) {
        BigDecimal existing = this.myQuadratic.get(key);
        if (existing != null) {
            this.set(key, ModelEntity.toBigDecimal(value).add(existing));
        } else {
            this.set(key, value);
        }
        return this;
    }

    @Deprecated
    public Expression add(Structure2D.IntRowColumn key, double value) {
        return this.add(key, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression add(Structure2D.IntRowColumn key, long value) {
        return this.add(key, BigDecimal.valueOf(value));
    }

    public Expression add(Variable variable, Comparable<?> value) {
        return this.add(variable.getIndex(), value);
    }

    public Expression add(Variable variable, double value) {
        return this.add(variable, BigDecimal.valueOf(value));
    }

    public Expression add(Variable variable, long value) {
        return this.add(variable, BigDecimal.valueOf(value));
    }

    public Expression add(Variable variable1, Variable variable2, Comparable<?> value) {
        return this.add(variable1.getIndex().index, variable2.getIndex().index, value);
    }

    public Expression add(Variable variable1, Variable variable2, double value) {
        return this.add(variable1, variable2, BigDecimal.valueOf(value));
    }

    public Expression add(Variable variable1, Variable variable2, long value) {
        return this.add(variable1, variable2, BigDecimal.valueOf(value));
    }

    @Override
    public void addTo(Expression target, BigDecimal scale) {
        BigDecimal value;
        for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : this.myLinear.entrySet()) {
            value = entry.getValue().multiply(scale);
            target.add(entry.getKey(), value);
        }
        for (Map.Entry<Comparable<Structure1D.IntIndex>, BigDecimal> entry : this.myQuadratic.entrySet()) {
            value = entry.getValue().multiply(scale);
            target.add((Structure2D.IntRowColumn)entry.getKey(), value);
        }
    }

    @Override
    public int compareTo(Expression obj) {
        return this.getName().compareTo(obj.getName());
    }

    public Expression compensate(Set<Structure1D.IntIndex> fixedVariables) {
        BigDecimal tmpFactor;
        Comparable<Structure1D.IntIndex> tmpKey;
        if (fixedVariables.size() == 0 || !this.isAnyQuadraticFactorNonZero() && Collections.disjoint(fixedVariables, this.getLinearKeySet())) {
            return this;
        }
        ExpressionsBasedModel tmpModel = this.getModel();
        Expression retVal = new Expression(this.getName(), tmpModel);
        BigDecimal tmpFixedValue = BigMath.ZERO;
        for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : this.myLinear.entrySet()) {
            tmpKey = entry.getKey();
            tmpFactor = entry.getValue();
            if (fixedVariables.contains(tmpKey)) {
                Variable variable = tmpModel.getVariable(tmpKey.index);
                BigDecimal tmpValue = variable.getValue();
                tmpFixedValue = tmpFixedValue.add(tmpFactor.multiply(tmpValue));
                continue;
            }
            retVal.set((Structure1D.IntIndex)tmpKey, (Comparable<?>)tmpFactor);
        }
        for (Map.Entry<Comparable<Structure1D.IntIndex>, BigDecimal> entry : this.myQuadratic.entrySet()) {
            tmpKey = (Structure2D.IntRowColumn)entry.getKey();
            tmpFactor = entry.getValue();
            Variable tmpRowVariable = tmpModel.getVariable(((Structure2D.IntRowColumn)tmpKey).row);
            Variable tmpColVariable = tmpModel.getVariable(((Structure2D.IntRowColumn)tmpKey).column);
            Structure1D.IntIndex tmpRowKey = tmpRowVariable.getIndex();
            Structure1D.IntIndex tmpColKey = tmpColVariable.getIndex();
            if (fixedVariables.contains(tmpRowKey)) {
                BigDecimal tmpRowValue = tmpRowVariable.getValue();
                if (fixedVariables.contains(tmpColKey)) {
                    BigDecimal tmpColValue = tmpColVariable.getValue();
                    tmpFixedValue = tmpFixedValue.add(tmpFactor.multiply(tmpRowValue).multiply(tmpColValue));
                    continue;
                }
                retVal.add(tmpColKey, tmpFactor.multiply(tmpRowValue));
                continue;
            }
            if (fixedVariables.contains(tmpColKey)) {
                BigDecimal tmpColValue = tmpColVariable.getValue();
                retVal.add(tmpRowKey, tmpFactor.multiply(tmpColValue));
                continue;
            }
            retVal.set((Structure2D.IntRowColumn)tmpKey, tmpFactor);
        }
        if (this.isLowerLimitSet()) {
            retVal.lower(this.getLowerLimit().subtract(tmpFixedValue));
        }
        if (this.isUpperLimitSet()) {
            retVal.upper(this.getUpperLimit().subtract(tmpFixedValue));
        }
        if (this.isInteger()) {
            retVal.setInteger();
        }
        return retVal;
    }

    public double doubleValue(Structure1D.IntIndex key, boolean adjusted) {
        return this.get(key, adjusted).doubleValue();
    }

    public double doubleValue(Structure2D.IntRowColumn key, boolean adjusted) {
        return this.get(key, adjusted).doubleValue();
    }

    public BigDecimal evaluate(Access1D<BigDecimal> point) {
        BigDecimal factor;
        BigDecimal retVal = this.getConstant();
        for (Structure2D.IntRowColumn quadKey : this.getQuadraticKeySet()) {
            factor = this.get(quadKey);
            retVal = retVal.add(factor.multiply(point.get(quadKey.row)).multiply(point.get(quadKey.column)));
        }
        for (Structure1D.IntIndex linKey : this.getLinearKeySet()) {
            factor = this.get(linKey);
            retVal = retVal.add(factor.multiply(point.get(linKey.index)));
        }
        return retVal;
    }

    public BigDecimal get(Structure1D.IntIndex key) {
        return this.get(key, false);
    }

    public BigDecimal get(Structure1D.IntIndex key, boolean adjusted) {
        return this.convert(this.myLinear.get(key), adjusted);
    }

    public BigDecimal get(Structure2D.IntRowColumn key) {
        return this.get(key, false);
    }

    public BigDecimal get(Structure2D.IntRowColumn key, boolean adjusted) {
        return this.convert(this.myQuadratic.get(key), adjusted);
    }

    public BigDecimal get(Variable variable) {
        Structure1D.IntIndex index = variable.getIndex();
        if (index != null) {
            return this.get(index);
        }
        throw new IllegalStateException("Variable not part of (this) model!");
    }

    public MatrixStore<Double> getAdjustedGradient(Access1D<?> point) {
        UnaryFunction<double> tmpModFunc;
        double tmpAdjustedFactor;
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(this.myModel.countVariables(), 1);
        PrimitiveFunction.Binary tmpBaseFunc = PrimitiveMath.ADD;
        for (Structure2D.IntRowColumn intRowColumn : this.getQuadraticKeySet()) {
            tmpAdjustedFactor = this.getAdjustedQuadraticFactor(intRowColumn);
            tmpModFunc = tmpBaseFunc.second(tmpAdjustedFactor * point.doubleValue(intRowColumn.column));
            retVal.modifyOne((long)intRowColumn.row, 0L, (UnaryFunction<Double>)tmpModFunc);
            tmpModFunc = tmpBaseFunc.second(tmpAdjustedFactor * point.doubleValue(intRowColumn.row));
            retVal.modifyOne((long)intRowColumn.column, 0L, (UnaryFunction<Double>)tmpModFunc);
        }
        for (Structure1D.IntIndex intIndex : this.getLinearKeySet()) {
            tmpAdjustedFactor = this.getAdjustedLinearFactor(intIndex);
            tmpModFunc = tmpBaseFunc.second(tmpAdjustedFactor);
            retVal.modifyOne((long)intIndex.index, 0L, (UnaryFunction<Double>)tmpModFunc);
        }
        return retVal;
    }

    public MatrixStore<Double> getAdjustedHessian() {
        int tmpCountVariables = this.myModel.countVariables();
        Primitive64Store retVal = (Primitive64Store)Primitive64Store.FACTORY.make(tmpCountVariables, tmpCountVariables);
        PrimitiveFunction.Binary tmpBaseFunc = PrimitiveMath.ADD;
        for (Structure2D.IntRowColumn tmpKey : this.getQuadraticKeySet()) {
            UnaryFunction<double> tmpModFunc = tmpBaseFunc.second(this.getAdjustedQuadraticFactor(tmpKey));
            retVal.modifyOne((long)tmpKey.row, (long)tmpKey.column, (UnaryFunction<Double>)tmpModFunc);
            retVal.modifyOne((long)tmpKey.column, (long)tmpKey.row, (UnaryFunction<Double>)tmpModFunc);
        }
        return retVal;
    }

    @Deprecated
    public double getAdjustedLinearFactor(int aVar) {
        return this.getAdjustedLinearFactor(new Structure1D.IntIndex(aVar));
    }

    @Deprecated
    public double getAdjustedLinearFactor(Structure1D.IntIndex key) {
        return this.get(key, true).doubleValue();
    }

    @Deprecated
    public double getAdjustedLinearFactor(Variable aVar) {
        return this.getAdjustedLinearFactor(aVar.getIndex());
    }

    @Deprecated
    public double getAdjustedQuadraticFactor(int aVar1, int aVar2) {
        return this.getAdjustedQuadraticFactor(new Structure2D.IntRowColumn(aVar1, aVar2));
    }

    @Deprecated
    public double getAdjustedQuadraticFactor(Structure2D.IntRowColumn key) {
        return this.get(key, true).doubleValue();
    }

    @Deprecated
    public double getAdjustedQuadraticFactor(Variable aVar1, Variable aVar2) {
        return this.getAdjustedQuadraticFactor(this.myModel.indexOf(aVar1), this.myModel.indexOf(aVar2));
    }

    public Set<Map.Entry<Structure1D.IntIndex, BigDecimal>> getLinearEntrySet() {
        return this.myLinear.entrySet();
    }

    public Set<Structure1D.IntIndex> getLinearKeySet() {
        return this.myLinear.keySet();
    }

    public Set<Map.Entry<Structure2D.IntRowColumn, BigDecimal>> getQuadraticEntrySet() {
        return this.myQuadratic.entrySet();
    }

    public Set<Structure2D.IntRowColumn> getQuadraticKeySet() {
        return this.myQuadratic.keySet();
    }

    public boolean isAnyLinearFactorNonZero() {
        return this.myLinear.size() > 0;
    }

    public boolean isAnyQuadraticFactorNonZero() {
        return this.myQuadratic.size() > 0;
    }

    public boolean isFunctionConstant() {
        return !this.isAnyQuadraticFactorNonZero() && !this.isAnyLinearFactorNonZero();
    }

    public boolean isFunctionLinear() {
        return !this.isAnyQuadraticFactorNonZero() && this.isAnyLinearFactorNonZero();
    }

    public boolean isFunctionPureQuadratic() {
        return this.isAnyQuadraticFactorNonZero() && !this.isAnyLinearFactorNonZero();
    }

    public boolean isFunctionQuadratic() {
        return this.isAnyQuadraticFactorNonZero() && this.isAnyLinearFactorNonZero();
    }

    @Override
    public boolean isInteger() {
        if (this.myInteger == null) {
            this.doIntegerRounding();
        }
        return this.myInteger;
    }

    public boolean isLinearAndAllBinary() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().allMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isBinary());
    }

    public boolean isLinearAndAllInteger() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().allMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isInteger());
    }

    public boolean isLinearAndAnyBinary() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().anyMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isBinary());
    }

    public boolean isLinearAndAnyInteger() {
        return this.myQuadratic.size() == 0 && this.myLinear.size() > 0 && this.myLinear.keySet().stream().anyMatch(i -> this.myModel.getVariable((Structure1D.IntIndex)i).isInteger());
    }

    public Expression set(int index, Comparable<?> value) {
        return this.set(this.myModel.getVariable(index), value);
    }

    public Expression set(int index, double value) {
        return this.set(index, BigDecimal.valueOf(value));
    }

    public Expression set(int row, int column, Comparable<?> value) {
        return this.set(new Structure2D.IntRowColumn(row, column), value);
    }

    public Expression set(int row, int column, double value) {
        return this.set(row, column, BigDecimal.valueOf(value));
    }

    public Expression set(int row, int column, long value) {
        return this.set(row, column, BigDecimal.valueOf(value));
    }

    public Expression set(int index, long value) {
        return this.set(index, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression set(Structure1D.IntIndex key, Comparable<?> value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal tmpValue = ModelEntity.toBigDecimal(value);
        if (tmpValue.signum() != 0) {
            this.myLinear.put(key, tmpValue);
            this.myModel.addReference(key);
        } else {
            this.myLinear.remove(key);
        }
        return this;
    }

    @Deprecated
    public Expression set(Structure1D.IntIndex key, double value) {
        return this.set(key, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression set(Structure1D.IntIndex row, Structure1D.IntIndex column, Comparable<?> value) {
        return this.set(new Structure2D.IntRowColumn(row, column), value);
    }

    @Deprecated
    public Expression set(Structure1D.IntIndex row, Structure1D.IntIndex column, double value) {
        return this.set(row, column, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression set(Structure1D.IntIndex row, Structure1D.IntIndex column, long value) {
        return this.set(row, column, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression set(Structure1D.IntIndex key, long value) {
        return this.set(key, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression set(Structure2D.IntRowColumn key, Comparable<?> value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal tmpValue = ModelEntity.toBigDecimal(value);
        if (tmpValue.signum() != 0) {
            this.myQuadratic.put(key, tmpValue);
            this.myModel.addReference(key.row());
            this.myModel.addReference(key.column());
        } else {
            this.myQuadratic.remove(key);
        }
        return this;
    }

    @Deprecated
    public Expression set(Structure2D.IntRowColumn key, double value) {
        return this.set(key, BigDecimal.valueOf(value));
    }

    @Deprecated
    public Expression set(Structure2D.IntRowColumn key, long value) {
        return this.set(key, BigDecimal.valueOf(value));
    }

    public Expression set(Variable variable, Comparable<?> value) {
        return this.set(variable.getIndex(), value);
    }

    public Expression set(Variable variable, double value) {
        return this.set(variable, BigDecimal.valueOf(value));
    }

    public Expression set(Variable variable, long value) {
        return this.set(variable, BigDecimal.valueOf(value));
    }

    public Expression set(Variable variable1, Variable variable2, Comparable<?> value) {
        return this.set(variable1.getIndex().index, variable2.getIndex().index, value);
    }

    public Expression set(Variable variable1, Variable variable2, double value) {
        return this.set(variable1, variable2, BigDecimal.valueOf(value));
    }

    public Expression set(Variable variable1, Variable variable2, long value) {
        return this.set(variable1, variable2, BigDecimal.valueOf(value));
    }

    public void setCompoundFactorsOffset(List<Variable> variables, Access1D<?> point) {
        int tmpLength = variables.size();
        if (point.count() != (long)tmpLength) {
            throw new IllegalArgumentException();
        }
        BigDecimal tmpLinearWeight = BigMath.TWO.negate();
        for (int ij = 0; ij < tmpLength; ++ij) {
            Variable tmpVariable = variables.get(ij);
            BigDecimal tmpVal = ModelEntity.toBigDecimal(point.get(ij));
            this.set(tmpVariable, tmpVariable, BigMath.ONE);
            this.set(tmpVariable, tmpVal.multiply(tmpLinearWeight));
        }
    }

    public void setLinearFactors(List<Variable> variables, Access1D<?> factors) {
        int tmpLimit = variables.size();
        if (factors.count() != (long)tmpLimit) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < tmpLimit; ++i) {
            this.set(variables.get(i), (Comparable<?>)factors.get(i));
        }
    }

    public void setLinearFactorsSimple(List<Variable> variables) {
        for (Variable tmpVariable : variables) {
            this.set(tmpVariable, BigMath.ONE);
        }
    }

    public void setQuadraticFactors(List<Variable> variables, Access2D<?> factors) {
        int tmpLimit = variables.size();
        if (factors.countRows() != (long)tmpLimit || factors.countColumns() != (long)tmpLimit) {
            throw new IllegalArgumentException();
        }
        for (int j = 0; j < tmpLimit; ++j) {
            Variable tmpVar2 = variables.get(j);
            for (int i = 0; i < tmpLimit; ++i) {
                this.set(variables.get(i), tmpVar2, (Comparable<?>)factors.get(i, j));
            }
        }
    }

    public void tighten() {
        if (this.isConstraint()) {
            this.isInteger();
        }
    }

    public MultiaryFunction.TwiceDifferentiable<Double> toFunction() {
        if (this.isFunctionQuadratic()) {
            return this.makeQuadraticFunction();
        }
        if (this.isFunctionPureQuadratic()) {
            return this.makePureQuadraticFunction();
        }
        if (this.isFunctionLinear()) {
            return this.makeAffineFunction();
        }
        return this.makeConstantFunction();
    }

    private BigDecimal convert(BigDecimal value, boolean adjusted) {
        if (value == null) {
            return BigMath.ZERO;
        }
        if (!adjusted) {
            return value;
        }
        int tmpAdjExp = this.getAdjustmentExponent();
        if (tmpAdjExp != 0) {
            return value.movePointRight(tmpAdjExp);
        }
        return value;
    }

    private BigDecimal getConstant() {
        return this.myConstant != null ? this.myConstant : BigMath.ZERO;
    }

    private AffineFunction<Double> makeAffineFunction() {
        AffineFunction<Double> retVal = AffineFunction.makePrimitive(this.myModel.countVariables());
        if (this.isAnyLinearFactorNonZero()) {
            for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : this.myLinear.entrySet()) {
                retVal.linear().set((long)entry.getKey().index, entry.getValue().doubleValue());
            }
        }
        retVal.setConstant(this.getConstant());
        return retVal;
    }

    private ConstantFunction<Double> makeConstantFunction() {
        return ConstantFunction.makePrimitive(this.myModel.countVariables(), this.getConstant());
    }

    private PureQuadraticFunction<Double> makePureQuadraticFunction() {
        PureQuadraticFunction<Double> retVal = PureQuadraticFunction.makePrimitive(this.myModel.countVariables());
        if (this.isAnyQuadraticFactorNonZero()) {
            for (Map.Entry<Structure2D.IntRowColumn, BigDecimal> entry : this.myQuadratic.entrySet()) {
                retVal.quadratic().set((long)entry.getKey().row, (long)entry.getKey().column, entry.getValue().doubleValue());
            }
        }
        retVal.setConstant(this.getConstant());
        return retVal;
    }

    private QuadraticFunction<Double> makeQuadraticFunction() {
        QuadraticFunction<Double> retVal = QuadraticFunction.makePrimitive(this.myModel.countVariables());
        if (this.isAnyQuadraticFactorNonZero()) {
            for (Map.Entry<Comparable<Structure2D.IntRowColumn>, BigDecimal> entry : this.myQuadratic.entrySet()) {
                retVal.quadratic().set((long)((Structure2D.IntRowColumn)entry.getKey()).row, (long)((Structure2D.IntRowColumn)entry.getKey()).column, entry.getValue().doubleValue());
            }
        }
        if (this.isAnyLinearFactorNonZero()) {
            for (Map.Entry<Comparable<Structure2D.IntRowColumn>, BigDecimal> entry : this.myLinear.entrySet()) {
                retVal.linear().set((long)((Structure1D.IntIndex)entry.getKey()).index, entry.getValue().doubleValue());
            }
        }
        retVal.setConstant(this.getConstant());
        return retVal;
    }

    private BigDecimal toPositiveFraction(BigDecimal noninteger) {
        BigDecimal intPart = noninteger.setScale(0, RoundingMode.FLOOR);
        return noninteger.subtract(intPart);
    }

    protected void appendMiddlePart(StringBuilder builder, Access1D<BigDecimal> solution, NumberContext display) {
        builder.append(this.getName());
        builder.append(": ");
        builder.append(display.enforce(this.toFunction().invoke(Access1D.asPrimitive1D(solution))));
        if (this.isObjective()) {
            builder.append(" (");
            builder.append(display.enforce(this.getContributionWeight()));
            builder.append(")");
        }
    }

    @Override
    protected void destroy() {
        super.destroy();
        if (!this.myShallowCopy) {
            this.myLinear.clear();
            this.myQuadratic.clear();
        }
    }

    void addObjectiveConstant(BigDecimal value) {
        BigDecimal weight = this.getContributionWeight();
        if (weight != null && weight.signum() != 0) {
            this.myModel.addObjectiveConstant(value.multiply(weight));
        } else {
            this.myModel.addObjectiveConstant(value);
        }
    }

    void appendToString(StringBuilder builder, Access1D<BigDecimal> solution, NumberContext display) {
        this.appendLeftPart(builder, display);
        if (solution != null) {
            this.appendMiddlePart(builder, solution, display);
        } else {
            this.appendMiddlePart(builder, display);
        }
        this.appendRightPart(builder, display);
    }

    BigDecimal calculateSetValue(Collection<Structure1D.IntIndex> subset) {
        BigDecimal retVal = BigMath.ZERO;
        if (subset.size() > 0) {
            BigDecimal coefficient;
            for (Structure1D.IntIndex linKey : this.myLinear.keySet()) {
                if (!subset.contains(linKey)) continue;
                coefficient = this.get(linKey);
                BigDecimal value = this.myModel.getVariable(linKey.index).getValue();
                retVal = retVal.add(coefficient.multiply(value));
            }
            for (Structure2D.IntRowColumn quadKey : this.myQuadratic.keySet()) {
                if (!subset.contains(quadKey.row()) || !subset.contains(quadKey.column())) continue;
                coefficient = this.get(quadKey);
                BigDecimal rowValue = this.myModel.getVariable(quadKey.row).getValue();
                BigDecimal colValue = this.myModel.getVariable(quadKey.column).getValue();
                retVal = retVal.add(coefficient.multiply(rowValue).multiply(colValue));
            }
        }
        return retVal;
    }

    Expression copy(ExpressionsBasedModel destinationModel, boolean deep) {
        return new Expression(this, destinationModel, deep);
    }

    long countIntegerFactors() {
        return this.myLinear.keySet().stream().map(this::resolve).filter(Variable::isInteger).count();
    }

    int countLinearFactors() {
        return this.myLinear.size();
    }

    int countQuadraticFactors() {
        return this.myQuadratic.size();
    }

    @Override
    int deriveAdjustmentExponent() {
        if (this.isInteger()) {
            return 0;
        }
        BigAggregator aggregators = BigAggregator.getSet();
        AggregatorFunction<BigDecimal> largest = ((AggregatorSet)aggregators).largest();
        AggregatorFunction<BigDecimal> smallest = ((AggregatorSet)aggregators).smallest();
        if (this.isAnyQuadraticFactorNonZero()) {
            for (BigDecimal quadraticFactor : this.myQuadratic.values()) {
                largest.invoke(quadraticFactor);
                smallest.invoke(quadraticFactor);
            }
            return ModelEntity.deriveAdjustmentExponent(largest, smallest, 8);
        }
        if (this.isAnyLinearFactorNonZero()) {
            for (BigDecimal linearFactor : this.myLinear.values()) {
                largest.invoke(linearFactor);
                smallest.invoke(linearFactor);
            }
            return ModelEntity.deriveAdjustmentExponent(largest, smallest, 8);
        }
        return 0;
    }

    @Override
    void doIntegerRounding() {
        this.doIntegerRounding(this.getLinearKeySet(), this.getLowerLimit(), this.getUpperLimit());
    }

    void doIntegerRounding(Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper) {
        BigDecimal tmpVal;
        if (this.myInteger != null) {
            return;
        }
        if (remaining.size() == 0 || !this.myModel.isInteger(remaining) || this.myQuadratic.size() > 0) {
            this.myInteger = Boolean.FALSE;
            return;
        }
        BigInteger gcd = null;
        int maxScale = Integer.MIN_VALUE;
        for (Structure1D.IntIndex index : remaining) {
            BigDecimal coeff = this.myLinear.get(index);
            BigDecimal abs = coeff.stripTrailingZeros().abs();
            maxScale = Math.max(maxScale, abs.scale());
            gcd = gcd != null ? gcd.gcd(abs.unscaledValue()) : abs.unscaledValue();
            if (maxScale <= 8 && (!gcd.equals(BigInteger.ONE) || maxScale <= 0)) continue;
            this.myInteger = Boolean.FALSE;
            return;
        }
        BigDecimal divisor = new BigDecimal(gcd, maxScale);
        boolean full = this.myLinear.size() == remaining.size();
        BigDecimal newLower = null;
        BigDecimal newUpper = null;
        if (lower != null) {
            tmpVal = lower.divide(divisor, 0, RoundingMode.CEILING);
            newLower = tmpVal.multiply(divisor);
            if (full) {
                this.lower(newLower);
            }
        }
        if (upper != null) {
            tmpVal = upper.divide(divisor, 0, RoundingMode.FLOOR);
            newUpper = tmpVal.multiply(divisor);
            if (full) {
                this.upper(newUpper);
            }
        }
        if (ModelEntity.isInfeasible(newLower, newUpper)) {
            this.setInfeasible();
        }
        this.myInteger = Boolean.TRUE;
    }

    Expression doMixedIntegerRounding() {
        if (!this.isEqualityConstraint()) {
            return null;
        }
        BigDecimal posFracLevel = this.toPositiveFraction(this.getLowerLimit());
        if (posFracLevel.signum() <= 0) {
            return null;
        }
        BigDecimal cmpFracLevel = BigMath.ONE.subtract(posFracLevel);
        Expression retVal = this.myModel.newExpression(this.getName() + "(MIR)");
        for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : this.myLinear.entrySet()) {
            Variable variable = this.resolve(entry.getKey());
            if (!variable.isLowerLimitSet() || variable.getLowerLimit().compareTo(BigMath.ZERO) < 0) {
                return null;
            }
            BigDecimal coeff = entry.getValue();
            if (variable.isInteger()) {
                BigDecimal posFracCoeff = this.toPositiveFraction(coeff);
                if (posFracCoeff.compareTo(posFracLevel) <= 0) {
                    retVal.set(variable, BigMath.DIVIDE.invoke(posFracCoeff, posFracLevel));
                    continue;
                }
                BigDecimal cmpFracCoeff = BigMath.ONE.subtract(posFracCoeff);
                retVal.set(variable, BigMath.DIVIDE.invoke(cmpFracCoeff, cmpFracLevel));
                continue;
            }
            if (coeff.signum() == 1) {
                retVal.set(variable, BigMath.DIVIDE.invoke(coeff, posFracLevel));
                continue;
            }
            if (coeff.signum() != -1) continue;
            BigDecimal negCoeff = coeff.negate();
            retVal.set(variable, BigMath.DIVIDE.invoke(negCoeff, cmpFracLevel));
        }
        return (Expression)retVal.lower(BigMath.ONE);
    }

    Set<Variable> getBinaryVariables(Set<Structure1D.IntIndex> subset) {
        HashSet<Variable> retVal = new HashSet<Variable>();
        for (Structure1D.IntIndex varInd : this.myLinear.keySet()) {
            Variable variable;
            if (!subset.contains(varInd) || !(variable = this.myModel.getVariable(varInd.index)).isBinary()) continue;
            retVal.add(variable);
        }
        return retVal;
    }

    Map<Structure1D.IntIndex, BigDecimal> getLinear() {
        return this.myLinear;
    }

    ExpressionsBasedModel getModel() {
        return this.myModel;
    }

    Map<Structure2D.IntRowColumn, BigDecimal> getQuadratic() {
        return this.myQuadratic;
    }

    boolean includes(Variable variable) {
        Structure1D.IntIndex tmpVarInd = variable.getIndex();
        return this.myLinear.containsKey(tmpVarInd) || this.myQuadratic.size() > 0 && this.myQuadratic.keySet().stream().anyMatch(k -> k.row == tmpVarInd.index || k.column == tmpVarInd.index);
    }

    boolean isConstantSet() {
        return this.myConstant != null && this.myConstant.signum() != 0;
    }

    @Override
    boolean isInfeasible() {
        return this.myInfeasible || super.isInfeasible();
    }

    boolean isNegativeOn(Set<Structure1D.IntIndex> subset) {
        if (!this.isAnyQuadraticFactorNonZero()) {
            for (Structure1D.IntIndex index : subset) {
                Variable setVar = this.myModel.getVariable(index);
                int signum = this.myLinear.get(index).signum();
                if (signum < 0 && setVar.isLowerLimitSet() && setVar.getLowerLimit().signum() >= 0 || signum > 0 && setVar.isUpperLimitSet() && setVar.getUpperLimit().signum() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    boolean isPositiveOn(Set<Structure1D.IntIndex> subset) {
        if (!this.isAnyQuadraticFactorNonZero()) {
            for (Structure1D.IntIndex index : subset) {
                Variable setVar = this.myModel.getVariable(index);
                int signum = this.myLinear.get(index).signum();
                if (signum > 0 && setVar.isLowerLimitSet() && setVar.getLowerLimit().signum() >= 0 || signum < 0 && setVar.isUpperLimitSet() && setVar.getUpperLimit().signum() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    boolean isRedundant() {
        return this.myRedundant;
    }

    Variable resolve(Structure1D.IntIndex index) {
        return this.myModel.getVariable(index);
    }

    void setConstant(Comparable<?> value) {
        this.myConstant = ModelEntity.toBigDecimal(value);
    }

    void setConstant(double value) {
        this.myConstant = BigDecimal.valueOf(value);
    }

    void setConstant(long value) {
        this.myConstant = BigDecimal.valueOf(value);
    }

    void setInfeasible() {
        this.myInfeasible = true;
        this.myModel.setInfeasible();
    }

    void setInteger() {
        this.myInteger = Boolean.TRUE;
    }

    void setRedundant() {
        this.myRedundant = true;
    }
}

