/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.type.keyvalue.EntryPair;

final class LinearStructure
implements UpdatableSolver.EntityMap {
    final int nbCnstrEq;
    final int nbCnstrLo;
    final int nbCnstrUp;
    final int nbVarsArt;
    final int nbVarsNeg;
    final int nbVarsPos;
    final int nbVarsSlk;
    final boolean[] negatedDual;
    final int[] negativePartVariables;
    final int[] positivePartVariables;
    final EntryPair<ModelEntity<?>, Optimisation.ConstraintType>[] slack;

    LinearStructure(int constraints, int variables) {
        this(0, 0, constraints, variables, 0, 0, 0);
    }

    LinearStructure(int constrUp, int constrLo, int constrEq, int varsPos, int varsNeg, int varsSlk, int varsArt) {
        this.positivePartVariables = new int[varsPos];
        this.negativePartVariables = new int[varsNeg];
        this.slack = new EntryPair[varsSlk];
        this.negatedDual = new boolean[constrUp + constrLo + constrEq];
        this.nbCnstrUp = constrUp;
        this.nbCnstrLo = constrLo;
        this.nbCnstrEq = constrEq;
        this.nbVarsPos = varsPos;
        this.nbVarsNeg = varsNeg;
        this.nbVarsSlk = varsSlk;
        this.nbVarsArt = varsArt;
    }

    @Override
    public int countModelVariables() {
        return this.nbVarsPos + this.nbVarsNeg;
    }

    @Override
    public int countSlackVariables() {
        return this.nbVarsSlk;
    }

    @Override
    public EntryPair<ModelEntity<?>, Optimisation.ConstraintType> getSlack(int idx) {
        return this.slack[idx];
    }

    @Override
    public int indexOf(int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException();
        }
        if (idx < this.positivePartVariables.length) {
            return this.positivePartVariables[idx];
        }
        int negIdx = idx - this.positivePartVariables.length;
        if (negIdx < this.negativePartVariables.length) {
            return this.negativePartVariables[negIdx];
        }
        return -1;
    }

    @Override
    public boolean isNegated(int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException();
        }
        if (idx < this.positivePartVariables.length) {
            return false;
        }
        return idx - this.positivePartVariables.length < this.negativePartVariables.length;
    }

    int countConstraints() {
        return this.nbCnstrUp + this.nbCnstrLo + this.nbCnstrEq;
    }

    int countVariablesTotally() {
        return this.nbVarsPos + this.nbVarsNeg + this.nbVarsSlk + this.nbVarsArt;
    }

    boolean isFullSetOfArtificials() {
        return this.nbVarsArt == this.countConstraints();
    }
}

