/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;

public interface Mutate2D
extends Structure2D,
Mutate1D {
    @Override
    default public void set(long index, byte value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    @Override
    default public void set(long index, Comparable<?> value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    @Override
    default public void set(long index, double value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    @Override
    default public void set(long index, float value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    @Override
    default public void set(long index, int value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    @Override
    default public void set(long index, long value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    default public void set(long row, long col, byte value) {
        this.set(row, col, (short)value);
    }

    public void set(long var1, long var3, Comparable<?> var5);

    public void set(long var1, long var3, double var5);

    default public void set(long row, long col, float value) {
        this.set(row, col, (double)value);
    }

    default public void set(long row, long col, int value) {
        this.set(row, col, (long)value);
    }

    default public void set(long row, long col, long value) {
        this.set(row, col, (double)value);
    }

    default public void set(long row, long col, short value) {
        this.set(row, col, (int)value);
    }

    @Override
    default public void set(long index, short value) {
        long structure = this.countRows();
        this.set(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
    }

    public static interface Receiver<N extends Comparable<N>>
    extends Mutate2D,
    Fillable<N>,
    Consumer<Access2D<?>> {
        @Override
        default public void accept(Access2D<?> supplied) {
            if (this.isAcceptable(supplied)) {
                long limitRows = Math.min(this.countRows(), supplied.countRows());
                long limitCols = Math.min(this.countColumns(), supplied.countColumns());
                for (long j = 0L; j < limitCols; ++j) {
                    for (long i = 0L; i < limitRows; ++i) {
                        this.set(i, j, (Comparable<?>)supplied.get(i, j));
                    }
                }
            } else {
                throw new ProgrammingError("Not acceptable!");
            }
        }

        default public boolean isAcceptable(Structure2D supplier) {
            return this.countRows() >= supplier.countRows() && this.countColumns() >= supplier.countColumns();
        }
    }

    public static interface ModifiableReceiver<N extends Comparable<N>>
    extends Modifiable<N>,
    Receiver<N>,
    Exchangeable,
    Access2D<N> {
        public void modifyAny(Transformation2D<N> var1);
    }

    public static interface Modifiable<N extends Comparable<N>>
    extends Structure2D,
    Mutate1D.Modifiable<N> {
        @Override
        default public void add(long index, byte addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, Comparable<?> addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, double addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, float addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, int addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        @Override
        default public void add(long index, long addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        default public void add(long row, long col, byte addend) {
            this.add(row, col, (short)addend);
        }

        public void add(long var1, long var3, Comparable<?> var5);

        public void add(long var1, long var3, double var5);

        default public void add(long row, long col, float addend) {
            this.add(row, col, (double)addend);
        }

        default public void add(long row, long col, int addend) {
            this.add(row, col, (long)addend);
        }

        default public void add(long row, long col, long addend) {
            this.add(row, col, (double)addend);
        }

        default public void add(long row, long col, short addend) {
            this.add(row, col, (int)addend);
        }

        @Override
        default public void add(long index, short addend) {
            long structure = this.countRows();
            this.add(Structure2D.row(index, structure), Structure2D.column(index, structure), addend);
        }

        default public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
            long limit = this.countRows();
            for (long i = row; i < limit; ++i) {
                this.modifyOne(i, col, modifier);
            }
        }

        default public void modifyColumn(long col, UnaryFunction<N> modifier) {
            this.modifyColumn(0L, col, modifier);
        }

        default public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
            long limit = Math.min(this.countRows() - row, this.countColumns() - col);
            for (long ij = 0L; ij < limit; ++ij) {
                this.modifyOne(row + ij, col + ij, modifier);
            }
        }

        default public void modifyDiagonal(UnaryFunction<N> modifier) {
            this.modifyDiagonal(0L, 0L, modifier);
        }

        default public void modifyMatchingInColumns(Access1D<N> left, BinaryFunction<N> function) {
            for (long r = 0L; r < left.count(); ++r) {
                this.modifyRow(r, function.first(left.get(r)));
            }
        }

        default public void modifyMatchingInColumns(BinaryFunction<N> function, Access1D<N> right) {
            for (long r = 0L; r < right.count(); ++r) {
                this.modifyRow(r, function.second(right.get(r)));
            }
        }

        default public void modifyMatchingInRows(Access1D<N> left, BinaryFunction<N> function) {
            for (long c = 0L; c < left.count(); ++c) {
                this.modifyColumn(c, function.first(left.get(c)));
            }
        }

        default public void modifyMatchingInRows(BinaryFunction<N> function, Access1D<N> right) {
            for (long c = 0L; c < right.count(); ++c) {
                this.modifyColumn(c, function.second(right.get(c)));
            }
        }

        public void modifyOne(long var1, long var3, UnaryFunction<N> var5);

        @Override
        default public void modifyOne(long index, UnaryFunction<N> modifier) {
            long structure = this.countRows();
            this.modifyOne(Structure2D.row(index, structure), Structure2D.column(index, structure), modifier);
        }

        default public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
            long limit = this.countColumns();
            for (long j = col; j < limit; ++j) {
                this.modifyOne(row, j, modifier);
            }
        }

        default public void modifyRow(long row, UnaryFunction<N> modifier) {
            this.modifyRow(row, 0L, modifier);
        }
    }

    public static interface Mixable<N extends Comparable<N>>
    extends Structure2D,
    Mutate1D.Mixable<N> {
        @Override
        default public double mix(long index, BinaryFunction<N> mixer, double addend) {
            long structure = this.countRows();
            return this.mix(Structure2D.row(index, structure), Structure2D.column(index, structure), mixer, (N)addend);
        }

        @Override
        default public N mix(long index, BinaryFunction<N> mixer, N addend) {
            long structure = this.countRows();
            return this.mix(Structure2D.row(index, structure), Structure2D.column(index, structure), mixer, addend);
        }

        public double mix(long var1, long var3, BinaryFunction<N> var5, double var6);

        public N mix(long var1, long var3, BinaryFunction<N> var5, N var6);
    }

    public static interface Fillable<N extends Comparable<N>>
    extends Mutate2D,
    Mutate1D.Fillable<N> {
        default public void fillColumn(long col, Access1D<N> values) {
            this.fillColumn(0L, col, (N)values);
        }

        default public void fillColumn(long row, long col, Access1D<N> values) {
            long limit = this.countRows();
            for (long i = row; i < limit; ++i) {
                this.fillOne(i, col, values.get(i - row));
            }
        }

        default public void fillColumn(long row, long col, N value) {
            long limit = this.countRows();
            for (long i = row; i < limit; ++i) {
                this.fillOne(i, col, value);
            }
        }

        default public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
            long limit = this.countRows();
            for (long i = row; i < limit; ++i) {
                this.fillOne(i, col, supplier);
            }
        }

        default public void fillColumn(long col, N value) {
            this.fillColumn(0L, col, value);
        }

        default public void fillColumn(long col, NullaryFunction<?> supplier) {
            this.fillColumn(0L, col, supplier);
        }

        default public void fillDiagonal(Access1D<N> values) {
            this.fillDiagonal(0L, 0L, (N)values);
        }

        default public void fillDiagonal(long row, long col, Access1D<N> values) {
            long limit = Math.min(this.countRows() - row, this.countColumns() - col);
            for (long ij = 0L; ij < limit; ++ij) {
                this.fillOne(row + ij, col + ij, values.get(ij));
            }
        }

        default public void fillDiagonal(long row, long col, N value) {
            long limit = Math.min(this.countRows() - row, this.countColumns() - col);
            for (long ij = 0L; ij < limit; ++ij) {
                this.fillOne(row + ij, col + ij, value);
            }
        }

        default public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
            long limit = Math.min(this.countRows() - row, this.countColumns() - col);
            for (long ij = 0L; ij < limit; ++ij) {
                this.fillOne(row + ij, col + ij, supplier);
            }
        }

        default public void fillDiagonal(N value) {
            this.fillDiagonal(0L, 0L, value);
        }

        default public void fillDiagonal(NullaryFunction<?> supplier) {
            this.fillDiagonal(0L, 0L, supplier);
        }

        @Override
        @Deprecated
        default public void fillOne(long index, Access1D<?> values, long valueIndex) {
            long structure = this.countRows();
            this.fillOne(Structure2D.row(index, structure), Structure2D.column(index, structure), values, valueIndex);
        }

        @Deprecated
        default public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
            this.fillOne(row, col, values.get(valueIndex));
        }

        @Deprecated
        default public void fillOne(long row, long col, N value) {
            this.set(row, col, (Comparable<?>)value);
        }

        @Deprecated
        default public void fillOne(long row, long col, NullaryFunction<?> supplier) {
            this.set(row, col, (Comparable<?>)supplier.get());
        }

        @Override
        @Deprecated
        default public void fillOne(long index, N value) {
            long structure = this.countRows();
            this.fillOne(Structure2D.row(index, structure), Structure2D.column(index, structure), value);
        }

        @Override
        @Deprecated
        default public void fillOne(long index, NullaryFunction<?> supplier) {
            long structure = this.countRows();
            this.fillOne(Structure2D.row(index, structure), Structure2D.column(index, structure), supplier);
        }

        default public void fillRow(long row, Access1D<N> values) {
            this.fillRow(row, 0L, (N)values);
        }

        default public void fillRow(long row, long col, Access1D<N> values) {
            long limit = this.countColumns();
            for (long j = col; j < limit; ++j) {
                this.fillOne(row, j, values.get(j - col));
            }
        }

        default public void fillRow(long row, long col, N value) {
            long limit = this.countColumns();
            for (long j = col; j < limit; ++j) {
                this.fillOne(row, j, value);
            }
        }

        default public void fillRow(long row, long col, NullaryFunction<?> supplier) {
            long limit = this.countColumns();
            for (long j = col; j < limit; ++j) {
                this.fillOne(row, j, supplier);
            }
        }

        default public void fillRow(long row, N value) {
            this.fillRow(row, 0L, value);
        }

        default public void fillRow(long row, NullaryFunction<?> supplier) {
            this.fillRow(row, 0L, supplier);
        }
    }

    public static interface Exchangeable
    extends Structure2D {
        public void exchangeColumns(long var1, long var3);

        public void exchangeRows(long var1, long var3);
    }
}

