/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.math;

import org.ojalgo.algebra.NumberSet;
import org.ojalgo.machine.JavaType;

public enum MathType {
    C128(NumberSet.C, 2, JavaType.DOUBLE),
    H256(NumberSet.H, 4, JavaType.DOUBLE),
    Q128(NumberSet.Q, 2, JavaType.LONG),
    R032(NumberSet.R, 1, JavaType.FLOAT),
    R064(NumberSet.R, 1, JavaType.DOUBLE),
    R128(NumberSet.R, 2, JavaType.DOUBLE),
    R256(NumberSet.R, 1, JavaType.REFERENCE),
    Z008(NumberSet.Z, 1, JavaType.BYTE),
    Z016(NumberSet.Z, 1, JavaType.SHORT),
    Z032(NumberSet.Z, 1, JavaType.INT),
    Z064(NumberSet.Z, 1, JavaType.LONG);

    private final int myComponents;
    private final JavaType myJavaType;
    private final NumberSet myNumberSet;

    public static boolean isPrimitive(MathType type1, MathType type2) {
        return type1.isPrimitive() || type2.isPrimitive();
    }

    private MathType(NumberSet numberSet, int components, JavaType javaType) {
        this.myNumberSet = numberSet;
        this.myJavaType = javaType;
        this.myComponents = components;
    }

    public MathType common(MathType other) {
        switch (this) {
            case Z008: {
                return Z008;
            }
            case Z016: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                }
                return Z016;
            }
            case Z032: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                }
                return Z032;
            }
            case Z064: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                }
                return Z064;
            }
            case Q128: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                }
                return Q128;
            }
            case R032: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                    case Q128: {
                        return Q128;
                    }
                }
                return R032;
            }
            case R064: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                    case Q128: {
                        return Q128;
                    }
                    case R032: {
                        return R032;
                    }
                }
                return R064;
            }
            case R128: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                    case Q128: {
                        return Q128;
                    }
                    case R032: {
                        return R032;
                    }
                    case R064: {
                        return R064;
                    }
                }
                return R128;
            }
            case R256: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                    case Q128: {
                        return Q128;
                    }
                    case R032: {
                        return R032;
                    }
                    case R064: {
                        return R064;
                    }
                    case R128: {
                        return R128;
                    }
                }
                return R256;
            }
            case C128: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                    case Q128: {
                        return Q128;
                    }
                    case R032: {
                        return R032;
                    }
                    case R064: {
                        return R064;
                    }
                    case R128: {
                        return R128;
                    }
                    case R256: {
                        return R256;
                    }
                }
                return C128;
            }
            case H256: {
                switch (other) {
                    case Z008: {
                        return Z008;
                    }
                    case Z016: {
                        return Z016;
                    }
                    case Z032: {
                        return Z032;
                    }
                    case Z064: {
                        return Z064;
                    }
                    case Q128: {
                        return Q128;
                    }
                    case R032: {
                        return R032;
                    }
                    case R064: {
                        return R064;
                    }
                    case R128: {
                        return R128;
                    }
                    case R256: {
                        return R256;
                    }
                    case C128: {
                        return C128;
                    }
                }
                return H256;
            }
        }
        return R064;
    }

    public int getComponents() {
        return this.myComponents;
    }

    public Class<?> getJavaClass() {
        return this.myJavaType.getJavaClass();
    }

    public JavaType getJavaType() {
        return this.myJavaType;
    }

    public NumberSet getNumberSet() {
        return this.myNumberSet;
    }

    public long getTotalMemory() {
        return (long)this.myComponents * this.myJavaType.memory();
    }

    public boolean isPrimitive() {
        return this.myComponents == 1 && this.myJavaType != JavaType.REFERENCE;
    }
}

