/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JavaHomeDialog
extends JDialog {
    private JavaHomeOrMemoryDialogParent javaHomeOrMemoryDialogParent;
    private JDialog welcomeDialog;
    private String toolName;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JSeparator jSeparator1;
    private JButton javaHomeHelpJButton;
    private JLabel javaHomeLabel;
    private JTextField javaHomeTxt;
    private JButton okButton;

    public JavaHomeDialog(JFrame parent, JavaHomeOrMemoryDialogParent javaHomeOrMemoryDialogParent, JDialog welcomeDialog, String toolName) {
        super((Frame)parent, true);
        this.javaHomeOrMemoryDialogParent = javaHomeOrMemoryDialogParent;
        this.welcomeDialog = welcomeDialog;
        this.toolName = toolName;
        this.initComponents();
        String javaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator;
        this.javaHomeTxt.setText(javaHome);
        if (parent.isVisible()) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocationRelativeTo(null);
        }
        this.setVisible(true);
    }

    private boolean validateInput() {
        boolean error = false;
        try {
            ArrayList<String> process_name_array = new ArrayList<String>();
            String tempJavaHome = this.javaHomeTxt.getText();
            if (!tempJavaHome.endsWith(File.separator)) {
                tempJavaHome = tempJavaHome + File.separator;
            }
            process_name_array.add(tempJavaHome + "java");
            process_name_array.add("-version");
            ProcessBuilder pb = new ProcessBuilder(process_name_array);
            pb.directory(new File(tempJavaHome));
            Process p = pb.start();
            InputStream stderr = p.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String errorMessage = "";
            if (br.ready()) {
                String line = br.readLine();
                while (line != null) {
                    errorMessage = errorMessage + line + "\n";
                    line = br.readLine();
                    error = true;
                }
            }
            br.close();
            isr.close();
            stderr.close();
            if (error) {
                System.out.println("Java startup error: " + errorMessage);
                JOptionPane.showMessageDialog(null, "Error starting Java. Please check the Java Home folder.", "Java Error", 2);
            } else {
                p.destroy();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error starting Java. Please check the Java Home folder.", "Java Error", 2);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.javaHomeHelpJButton = new JButton();
        this.javaHomeLabel = new JLabel();
        this.javaHomeTxt = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.browseButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Java Memory Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaHomeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaHomeDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.javaHomeHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.javaHomeHelpJButton.setToolTipText("Help");
        this.javaHomeHelpJButton.setBorder(null);
        this.javaHomeHelpJButton.setBorderPainted(false);
        this.javaHomeHelpJButton.setContentAreaFilled(false);
        this.javaHomeHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JavaHomeDialog.this.javaHomeHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JavaHomeDialog.this.javaHomeHelpJButtonMouseExited(evt);
            }
        });
        this.javaHomeHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaHomeDialog.this.javaHomeHelpJButtonActionPerformed(evt);
            }
        });
        this.javaHomeLabel.setText("Java Home");
        this.javaHomeTxt.setEditable(false);
        this.javaHomeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JavaHomeDialog.this.javaHomeTxtKeyReleased(evt);
            }
        });
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaHomeDialog.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.javaHomeHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.javaHomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.javaHomeTxt, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaHomeLabel).addComponent(this.javaHomeTxt, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addComponent(this.javaHomeHelpJButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            int outcome;
            String currentJavaHome;
            String newJavaHome = this.javaHomeTxt.getText().trim();
            if (!newJavaHome.equalsIgnoreCase(currentJavaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator) && (outcome = JOptionPane.showConfirmDialog(this, this.toolName + " needs to restart in order to take the new settings into account. Restart now?", "Restart Requested", 2)) == 0) {
                this.javaHomeOrMemoryDialogParent.getUtilitiesUserPreferences().setJavaHome(newJavaHome);
                try {
                    UtilitiesUserPreferences.saveUserPreferences(this.javaHomeOrMemoryDialogParent.getUtilitiesUserPreferences());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.welcomeDialog != null) {
                    this.welcomeDialog.setVisible(false);
                }
                this.javaHomeOrMemoryDialogParent.restart();
            }
            this.dispose();
        }
    }

    private void javaHomeHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void javaHomeHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void javaHomeHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/JavaHomeDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Java Home - Help");
        this.setCursor(new Cursor(0));
    }

    private void javaHomeTxtKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.javaHomeTxt.getText().length() > 0) {
            this.okButtonActionPerformed(null);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.javaHomeTxt.getText());
        fileChooser.setDialogTitle("Select Java Home");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showDialog(this, "Select");
        if (returnVal == 0) {
            String selectedDir = fileChooser.getSelectedFile().getAbsolutePath();
            if (!selectedDir.endsWith(File.separator)) {
                selectedDir = selectedDir + File.separator;
            }
            this.javaHomeTxt.setText(selectedDir);
            this.validateInput();
        }
    }
}

