/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.exceptions.exception_handlers;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.gui.JOptionEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FrameExceptionHandler
extends ExceptionHandler {
    private JFrame parent = null;
    private String toolIssuesPage;

    public FrameExceptionHandler(JFrame parent, String toolIssuesPage) {
        this.parent = parent;
        this.toolIssuesPage = toolIssuesPage;
    }

    @Override
    public void notifyUser(Exception e) {
        if (this.parent != null) {
            if (FrameExceptionHandler.getExceptionType(e).equals("Protein not found")) {
                JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane(e.getLocalizedMessage() + "<br>Please see the <a href=\"http://compomics.github.io/projects/searchgui/wiki/databasehelp.html\">Database help page</a>.<br>This message will appear only once."), "Error", 0);
            } else if (FrameExceptionHandler.getExceptionType(e).equals("Serialization")) {
                if (this.toolIssuesPage != null) {
                    JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane(e.getLocalizedMessage() + "<br>Please <a href=\"" + this.toolIssuesPage + "\">contact the developers</a>.<br>This message will appear only once."), "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane(e.getLocalizedMessage() + "<br>Please contact the developers.<br>This message will appear only once."), "Error", 0);
                }
            } else {
                String error = "";
                if (e.getLocalizedMessage() != null) {
                    error = e.getLocalizedMessage();
                }
                if (!error.endsWith(".")) {
                    error = error + ".";
                }
                if (this.toolIssuesPage != null) {
                    JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane("An error occured: " + error + "<br>If the problem persists, please <a href=\"" + this.toolIssuesPage + "\">contact the developers</a>."), "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.parent, JOptionEditorPane.getJOptionEditorPane("An error occured: " + error + "<br>If the problem persists, please contact the developers."), "Error", 0);
                }
            }
        }
    }
}

