/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;

public class TagFragmentIon
extends Ion {
    public static final int A_ION = 0;
    public static final int B_ION = 1;
    public static final int C_ION = 2;
    public static final int X_ION = 3;
    public static final int Y_ION = 4;
    public static final int Z_ION = 5;
    private NeutralLoss[] neutralLosses = null;
    private int number = -1;
    private int subNumber = -1;
    private int subType;
    private double massGap = 0.0;
    private CvTerm cvTerm = null;
    private CvTerm psiCvTerm = null;

    public TagFragmentIon(int fragmentType, int number, int subNumber, double mass, NeutralLoss[] neutralLosses, double massGap) {
        this.neutralLosses = neutralLosses;
        this.subType = fragmentType;
        this.type = Ion.IonType.TAG_FRAGMENT_ION;
        this.theoreticMass1 = mass;
        this.number = number;
        this.subNumber = subNumber;
        this.massGap = massGap;
    }

    public TagFragmentIon(int fragmentType, NeutralLoss[] neutralLosses) {
        this.neutralLosses = neutralLosses;
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
    }

    public TagFragmentIon(int fragmentType) {
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
    }

    public int getNumber() {
        return this.number;
    }

    public int getSubNumber() {
        return this.subNumber;
    }

    @Override
    public NeutralLoss[] getNeutralLosses() {
        return this.neutralLosses;
    }

    @Override
    public String getName() {
        return this.getSubTypeAsString() + this.getNeutralLossesAsString();
    }

    public String getNameWithNumber() {
        return this.getSubTypeAsString() + this.getNumber() + this.getNeutralLossesAsString();
    }

    public String getNameWithGapAndNumber() {
        if (this.massGap == 0.0 || this.subNumber > 1) {
            return this.getNameWithNumber();
        }
        return this.massGap + "-" + this.getSubTypeAsString() + this.getNumber() + this.getNeutralLossesAsString();
    }

    @Override
    public CvTerm getPrideCvTerm() {
        if (this.cvTerm != null) {
            return this.cvTerm;
        }
        switch (this.subType) {
            case 0: {
                if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001229", "frag: a ion", null);
                    break;
                }
                if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001234", "frag: a ion - H2O", null);
                    break;
                }
                if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                this.cvTerm = new CvTerm("PSI-MS", "MS:1001235", "frag: a ion - NH3", null);
                break;
            }
            case 1: {
                if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001224", "frag: b ion", null);
                    break;
                }
                if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001222", "frag: b ion - H2O", null);
                    break;
                }
                if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                this.cvTerm = new CvTerm("PSI-MS", "MS:1001232", "frag: b ion - NH3", null);
                break;
            }
            case 2: {
                if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001231", "frag: c ion", null);
                    break;
                }
                if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001515", "frag: c ion - H2O", null);
                    break;
                }
                if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                this.cvTerm = new CvTerm("PSI-MS", "MS:1001516", "frag: c ion - NH3", null);
                break;
            }
            case 3: {
                if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001228", "frag: x ion", null);
                    break;
                }
                if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001519", "frag: x ion - H2O", null);
                    break;
                }
                if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                this.cvTerm = new CvTerm("PSI-MS", "MS:1001520", "frag: x ion - NH3", null);
                break;
            }
            case 4: {
                if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001220", "frag: y ion", null);
                    break;
                }
                if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001223", "frag: y ion - H2O", null);
                    break;
                }
                if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                this.cvTerm = new CvTerm("PSI-MS", "MS:1001233", "frag: y ion - NH3", null);
                break;
            }
            case 5: {
                if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001230", "frag: z ion", null);
                    break;
                }
                if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001517", "frag: z ion - H2O", null);
                    break;
                }
                if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                this.cvTerm = new CvTerm("PSI-MS", "MS:1001518", "frag: z ion - NH3", null);
            }
        }
        return this.cvTerm;
    }

    @Override
    public CvTerm getPsiMsCvTerm() {
        if (this.psiCvTerm != null) {
            return this.psiCvTerm;
        }
        switch (this.subType) {
            case 0: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001229", "frag: a ion", null);
                break;
            }
            case 1: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001224", "frag: b ion", null);
                break;
            }
            case 2: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001231", "frag: c ion", null);
                break;
            }
            case 3: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001228", "frag: x ion", null);
                break;
            }
            case 4: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001220", "frag: y ion", null);
                break;
            }
            case 5: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001230", "frag: z ion", null);
            }
        }
        return this.psiCvTerm;
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeAsString() {
        try {
            return TagFragmentIon.getSubTypeAsString(this.subType);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("No name for subtype: " + this.subType + " of " + this.getTypeAsString() + ".");
        }
    }

    public static String getSubTypeAsString(int subType) {
        switch (subType) {
            case 0: {
                return "a";
            }
            case 1: {
                return "b";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "x";
            }
            case 4: {
                return "y";
            }
            case 5: {
                return "z";
            }
        }
        throw new UnsupportedOperationException("No name for subtype: " + subType + ".");
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>();
        possibleTypes.add(0);
        possibleTypes.add(1);
        possibleTypes.add(2);
        possibleTypes.add(3);
        possibleTypes.add(4);
        possibleTypes.add(5);
        return possibleTypes;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.TAG_FRAGMENT_ION && anotherIon.getSubType() == this.subType && ((PeptideFragmentIon)anotherIon).getNumber() == this.number && anotherIon.getNeutralLossesAsString().equals(this.getNeutralLossesAsString());
    }

    public double getMassGap() {
        return this.massGap;
    }
}

