/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.mutations;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.mutations.Mutation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MutationFactory {
    private static List<AminoAcid> aminoAcids;
    private static List<Mutation> mutations;
    private static Map<String, Mutation> mutationMap;

    private MutationFactory() {
    }

    public static Mutation getMutation(Mutation mutation) {
        if (mutationMap == null) {
            MutationFactory.createMutations();
        }
        return mutationMap.get(mutation.toString());
    }

    public static List<Mutation> createMutations() {
        if (aminoAcids == null) {
            MutationFactory.createAminoAcids();
        }
        if (mutations == null) {
            mutations = new ArrayList<Mutation>();
            mutationMap = new HashMap<String, Mutation>();
            for (AminoAcid aa1 : aminoAcids) {
                for (AminoAcid aa2 : aminoAcids) {
                    Mutation mutation;
                    if (aa1.equals(aa2) || MutationFactory.getMutation(mutation = new Mutation(aa1, aa2)) != null) continue;
                    mutations.add(mutation);
                    mutationMap.put(mutation.toString(), mutation);
                }
            }
        }
        return mutations;
    }

    public static List<String> getMutationsAsString() {
        if (mutationMap == null) {
            MutationFactory.createMutations();
        }
        return new ArrayList<String>(mutationMap.keySet());
    }

    private static void createAminoAcids() {
        aminoAcids = new ArrayList<AminoAcid>();
        aminoAcids.add(AminoAcid.A);
        aminoAcids.add(AminoAcid.C);
        aminoAcids.add(AminoAcid.D);
        aminoAcids.add(AminoAcid.E);
        aminoAcids.add(AminoAcid.F);
        aminoAcids.add(AminoAcid.G);
        aminoAcids.add(AminoAcid.H);
        aminoAcids.add(AminoAcid.I);
        aminoAcids.add(AminoAcid.K);
        aminoAcids.add(AminoAcid.L);
        aminoAcids.add(AminoAcid.M);
        aminoAcids.add(AminoAcid.N);
        aminoAcids.add(AminoAcid.P);
        aminoAcids.add(AminoAcid.Q);
        aminoAcids.add(AminoAcid.R);
        aminoAcids.add(AminoAcid.S);
        aminoAcids.add(AminoAcid.T);
        aminoAcids.add(AminoAcid.V);
        aminoAcids.add(AminoAcid.W);
        aminoAcids.add(AminoAcid.Y);
    }
}

