/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SpecificAnnotationSettings {
    private String spectrumKey;
    private SpectrumIdentificationAssumption spectrumIdentificationAssumption;
    private HashMap<Ion.IonType, HashSet<Integer>> selectedIonsMap = new HashMap();
    private boolean neutralLossesAuto = true;
    private NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
    private ArrayList<Integer> selectedCharges = new ArrayList();
    private double fragmentIonAccuracy;
    private boolean fragmentIonPpm = false;

    public SpecificAnnotationSettings(String spectrumKey, SpectrumIdentificationAssumption spectrumIdentificationAssumption) {
        this.spectrumKey = spectrumKey;
        this.spectrumIdentificationAssumption = spectrumIdentificationAssumption;
    }

    public String getSpectrumKey() {
        return this.spectrumKey;
    }

    public SpectrumIdentificationAssumption getSpectrumIdentificationAssumption() {
        return this.spectrumIdentificationAssumption;
    }

    public int getPrecursorCharge() {
        return this.spectrumIdentificationAssumption.getIdentificationCharge().value;
    }

    public HashMap<Ion.IonType, HashSet<Integer>> getIonTypes() {
        return this.selectedIonsMap;
    }

    public HashSet<Integer> getFragmentIonTypes() {
        if (this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) == null) {
            return new HashSet<Integer>(0);
        }
        return this.selectedIonsMap.get((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION);
    }

    public void setSelectedIonsMap(HashMap<Ion.IonType, HashSet<Integer>> selectedIonsMap) {
        this.selectedIonsMap = selectedIonsMap;
    }

    public void clearIonTypes() {
        this.selectedIonsMap.clear();
    }

    public void addIonType(Ion.IonType ionType, int subType) {
        if (!this.selectedIonsMap.containsKey((Object)ionType)) {
            this.selectedIonsMap.put(ionType, new HashSet());
        }
        this.selectedIonsMap.get((Object)ionType).add(subType);
    }

    public void addIonType(Ion.IonType ionType) {
        if (!this.selectedIonsMap.containsKey((Object)ionType)) {
            this.selectedIonsMap.put(ionType, new HashSet());
        }
        for (int subType : Ion.getPossibleSubtypes(ionType)) {
            this.selectedIonsMap.get((Object)ionType).add(subType);
        }
    }

    public NeutralLossesMap getNeutralLossesMap() {
        return this.neutralLossesMap;
    }

    public void setNeutralLossesMap(NeutralLossesMap neutralLossesMap) {
        this.neutralLossesMap = neutralLossesMap;
    }

    public void clearNeutralLosses() {
        this.neutralLossesMap.clearNeutralLosses();
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLossesMap.addNeutralLoss(neutralLoss, (Integer)1, (Integer)1);
    }

    public ArrayList<Integer> getSelectedCharges() {
        return this.selectedCharges;
    }

    public void setSelectedCharges(ArrayList<Integer> selectedCharges) {
        this.selectedCharges = selectedCharges;
    }

    public void clearCharges() {
        this.selectedCharges.clear();
    }

    public void addSelectedCharge(int selectedCharge) {
        if (!this.selectedCharges.contains(selectedCharge)) {
            this.selectedCharges = new ArrayList<Integer>(this.selectedCharges);
            this.selectedCharges.add(selectedCharge);
        }
    }

    public double getFragmentIonAccuracy() {
        return this.fragmentIonAccuracy;
    }

    public double getFragmentIonAccuracyInDa(Double refMass) {
        if (this.fragmentIonPpm) {
            return this.fragmentIonAccuracy * refMass / 1000000.0;
        }
        return this.fragmentIonAccuracy;
    }

    public void setFragmentIonAccuracy(double fragmentIonAccuracy) {
        this.fragmentIonAccuracy = fragmentIonAccuracy;
    }

    public boolean isFragmentIonPpm() {
        return this.fragmentIonPpm;
    }

    public void setFragmentIonPpm(boolean fragmentIonPpm) {
        this.fragmentIonPpm = fragmentIonPpm;
    }

    public boolean isNeutralLossesAuto() {
        return this.neutralLossesAuto;
    }

    public void setNeutralLossesAuto(boolean neutralLossesAuto) {
        this.neutralLossesAuto = neutralLossesAuto;
    }

    public SpecificAnnotationSettings clone() {
        SpecificAnnotationSettings clone = new SpecificAnnotationSettings(this.spectrumKey, this.spectrumIdentificationAssumption);
        clone.setFragmentIonAccuracy(this.getFragmentIonAccuracy());
        clone.setFragmentIonPpm(this.isFragmentIonPpm());
        clone.setNeutralLossesAuto(this.isNeutralLossesAuto());
        clone.setNeutralLossesMap(this.getNeutralLossesMap().clone());
        clone.setSelectedCharges(new ArrayList<Integer>(this.getSelectedCharges()));
        HashMap<Ion.IonType, HashSet<Integer>> currentIonsMap = this.getIonTypes();
        HashMap<Ion.IonType, HashSet<Integer>> newMap = new HashMap<Ion.IonType, HashSet<Integer>>(currentIonsMap.size());
        for (Ion.IonType ionType : currentIonsMap.keySet()) {
            newMap.put(ionType, new HashSet(currentIonsMap.get((Object)ionType)));
        }
        clone.setSelectedIonsMap(newMap);
        return clone;
    }
}

