/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.SimplePeptideAnnotator;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import com.compomics.util.experiment.massspectrometry.utils.StandardMasses;
import java.util.ArrayList;
import java.util.HashMap;

public class FragmentAnnotatorNL {
    private final PTMFactory ptmFactory = PTMFactory.getInstance();
    private final double[] forwardIonMz1;
    private final double[] complementaryIonMz1;
    private final int peptideLength;
    private final int forwardIonType;
    private final int complementaryIonType;
    private final ArrayList<double[]> forwardNeutralLossesMasses;
    private final ArrayList<ArrayList<NeutralLoss>> forwardNeutralLosses;
    private final ArrayList<double[]> complementaryNeutralLossesMasses;
    private final ArrayList<ArrayList<NeutralLoss>> complementaryNeutralLosses;

    public FragmentAnnotatorNL(Peptide peptide, SimplePeptideAnnotator.IonSeries ionSeries, boolean sequenceDependent) throws InterruptedException {
        double complementaryMass;
        double forwardMass;
        int[] nArray;
        char[] aas = peptide.getSequence().toCharArray();
        this.peptideLength = aas.length;
        this.forwardIonMz1 = new double[this.peptideLength];
        this.complementaryIonMz1 = new double[this.peptideLength];
        NeutralLoss[] losses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
        int[][] lossesIndexes = new int[2][2];
        if (sequenceDependent) {
            nArray = this.getLossesIndexes(aas);
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = this.peptideLength;
            nArray = nArray2;
            nArray2[3] = this.peptideLength;
        }
        int[] sequenceLossesIndexes = nArray;
        lossesIndexes[0][0] = sequenceLossesIndexes[0];
        lossesIndexes[0][1] = sequenceLossesIndexes[2];
        lossesIndexes[1][0] = sequenceLossesIndexes[1];
        lossesIndexes[1][1] = sequenceLossesIndexes[3];
        double[] modificationsMasses = new double[this.peptideLength];
        ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
        if (modificationMatches != null) {
            HashMap<String, int[]> modificationLossesSites = new HashMap<String, int[]>(1);
            for (ModificationMatch modificationMatch : modificationMatches) {
                int siteIndex;
                String modificationName = modificationMatch.getTheoreticPtm();
                PTM modification = this.ptmFactory.getPTM(modificationName);
                double modificationMass = modification.getMass();
                int site = modificationMatch.getModificationSite();
                int n = siteIndex = site - 1;
                modificationsMasses[n] = modificationsMasses[n] + modificationMass;
                for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                    int[] sites = (int[])modificationLossesSites.get(neutralLoss.name);
                    if (sites == null) {
                        sites = new int[]{siteIndex, siteIndex};
                        modificationLossesSites.put(neutralLoss.name, sites);
                        continue;
                    }
                    if (siteIndex < sites[0]) {
                        sites[0] = siteIndex;
                        continue;
                    }
                    if (siteIndex <= sites[1]) continue;
                    sites[1] = siteIndex;
                }
            }
            if (!modificationLossesSites.isEmpty()) {
                int[][] newIndexes = new int[lossesIndexes.length + modificationLossesSites.size()][2];
                System.arraycopy(lossesIndexes, 0, newIndexes, 0, lossesIndexes.length);
                NeutralLoss[] newLosses = new NeutralLoss[losses.length + modificationLossesSites.size()];
                System.arraycopy(losses, 0, newLosses, 0, losses.length);
                int index = lossesIndexes.length;
                for (String lossName : modificationLossesSites.keySet()) {
                    int[] sites = (int[])modificationLossesSites.get(lossName);
                    newIndexes[index][1] = sites[0];
                    newIndexes[index][1] = sites[1];
                    newLosses[index] = NeutralLoss.getNeutralLoss(lossName);
                    ++index;
                }
                lossesIndexes = newIndexes;
                losses = newLosses;
            }
        }
        if (ionSeries == SimplePeptideAnnotator.IonSeries.by) {
            forwardMass = ElementaryIon.proton.getTheoreticMass();
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2];
            this.forwardIonType = 1;
            this.complementaryIonType = 4;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.cz) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() + StandardMasses.nh3.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] - StandardMasses.nh3.mass;
            this.forwardIonType = 2;
            this.complementaryIonType = 5;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.ax) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() - StandardMasses.co.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] + StandardMasses.co.mass;
            this.forwardIonType = 0;
            this.complementaryIonType = 3;
        } else {
            throw new UnsupportedOperationException("Ion series " + (Object)((Object)ionSeries) + " not supported.");
        }
        this.forwardNeutralLossesMasses = new ArrayList(this.peptideLength);
        this.forwardNeutralLosses = new ArrayList(this.peptideLength);
        this.complementaryNeutralLossesMasses = new ArrayList(this.peptideLength);
        this.complementaryNeutralLosses = new ArrayList(this.peptideLength);
        for (int i = 0; i < this.peptideLength; ++i) {
            char aa = aas[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            forwardMass += aminoAcid.getMonoisotopicMass();
            this.forwardIonMz1[i] = forwardMass += modificationsMasses[i];
            this.complementaryIonMz1[i] = complementaryMass - forwardMass;
            ArrayList<NeutralLoss> forwardIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
            ArrayList<NeutralLoss> complementaryIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
            double[] forwardMasses = new double[lossesIndexes.length];
            double[] complementaryMasses = new double[lossesIndexes.length];
            int indexForward = 0;
            int indexComplementary = 0;
            for (int j = 0; j < lossesIndexes.length; ++j) {
                int[] indexes = lossesIndexes[j];
                NeutralLoss neutralLoss = losses[j];
                if (i >= indexes[0]) {
                    forwardIonlosses.add(neutralLoss);
                    forwardMasses[indexForward++] = neutralLoss.getMass();
                }
                if (i > indexes[j]) continue;
                complementaryIonlosses.add(neutralLoss);
                complementaryMasses[indexComplementary++] = neutralLoss.getMass();
            }
            this.forwardNeutralLossesMasses.add(forwardMasses);
            this.forwardNeutralLosses.add(forwardIonlosses);
            this.complementaryNeutralLossesMasses.add(complementaryMasses);
            this.complementaryNeutralLosses.add(complementaryIonlosses);
        }
    }

    public FragmentAnnotatorNL(Peptide peptide, SimplePeptideAnnotator.IonSeries ionSeries, boolean sequenceDependent, boolean forward, boolean complementary) throws InterruptedException {
        double complementaryMass;
        double forwardMass;
        int[] nArray;
        char[] aas = peptide.getSequence().toCharArray();
        this.peptideLength = aas.length;
        this.forwardIonMz1 = new double[this.peptideLength];
        this.complementaryIonMz1 = new double[this.peptideLength];
        NeutralLoss[] losses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
        int[][] lossesIndexes = new int[2][2];
        if (sequenceDependent) {
            nArray = this.getLossesIndexes(aas);
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = this.peptideLength;
            nArray = nArray2;
            nArray2[3] = this.peptideLength;
        }
        int[] sequenceLossesIndexes = nArray;
        lossesIndexes[0][0] = sequenceLossesIndexes[0];
        lossesIndexes[0][1] = sequenceLossesIndexes[2];
        lossesIndexes[1][0] = sequenceLossesIndexes[1];
        lossesIndexes[1][1] = sequenceLossesIndexes[3];
        double[] modificationsMasses = new double[this.peptideLength];
        ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
        if (modificationMatches != null) {
            HashMap<String, int[]> modificationLossesSites = new HashMap<String, int[]>(1);
            for (ModificationMatch modificationMatch : modificationMatches) {
                int siteIndex;
                String modificationName = modificationMatch.getTheoreticPtm();
                PTM modification = this.ptmFactory.getPTM(modificationName);
                double modificationMass = modification.getMass();
                int site = modificationMatch.getModificationSite();
                int n = siteIndex = site - 1;
                modificationsMasses[n] = modificationsMasses[n] + modificationMass;
                for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                    int[] sites = (int[])modificationLossesSites.get(neutralLoss.name);
                    if (sites == null) {
                        sites = new int[]{siteIndex, siteIndex};
                        modificationLossesSites.put(neutralLoss.name, sites);
                        continue;
                    }
                    if (siteIndex < sites[0]) {
                        sites[0] = siteIndex;
                        continue;
                    }
                    if (siteIndex <= sites[1]) continue;
                    sites[1] = siteIndex;
                }
            }
            if (!modificationLossesSites.isEmpty()) {
                int[][] newIndexes = new int[lossesIndexes.length + modificationLossesSites.size()][2];
                System.arraycopy(lossesIndexes, 0, newIndexes, 0, lossesIndexes.length);
                NeutralLoss[] newLosses = new NeutralLoss[losses.length + modificationLossesSites.size()];
                System.arraycopy(losses, 0, newLosses, 0, losses.length);
                int index = lossesIndexes.length;
                for (String lossName : modificationLossesSites.keySet()) {
                    int[] sites = (int[])modificationLossesSites.get(lossName);
                    newIndexes[index][1] = sites[0];
                    newIndexes[index][1] = sites[1];
                    newLosses[index] = NeutralLoss.getNeutralLoss(lossName);
                    ++index;
                }
                lossesIndexes = newIndexes;
                losses = newLosses;
            }
        }
        if (ionSeries == SimplePeptideAnnotator.IonSeries.by) {
            forwardMass = ElementaryIon.proton.getTheoreticMass();
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2];
            this.forwardIonType = 1;
            this.complementaryIonType = 4;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.cz) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() + StandardMasses.nh3.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] - StandardMasses.nh3.mass;
            this.forwardIonType = 2;
            this.complementaryIonType = 5;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.ax) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() - StandardMasses.co.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] + StandardMasses.co.mass;
            this.forwardIonType = 0;
            this.complementaryIonType = 3;
        } else {
            throw new UnsupportedOperationException("Ion series " + (Object)((Object)ionSeries) + " not supported.");
        }
        if (forward) {
            this.forwardNeutralLossesMasses = new ArrayList(this.peptideLength);
            this.forwardNeutralLosses = new ArrayList(this.peptideLength);
        } else {
            this.forwardNeutralLossesMasses = null;
            this.forwardNeutralLosses = null;
        }
        if (complementary) {
            this.complementaryNeutralLossesMasses = new ArrayList(this.peptideLength);
            this.complementaryNeutralLosses = new ArrayList(this.peptideLength);
        } else {
            this.complementaryNeutralLossesMasses = null;
            this.complementaryNeutralLosses = null;
        }
        for (int i = 0; i < this.peptideLength; ++i) {
            NeutralLoss neutralLoss;
            int[] indexes;
            int j;
            char aa = aas[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            forwardMass += aminoAcid.getMonoisotopicMass();
            forwardMass += modificationsMasses[i];
            if (forward) {
                this.forwardIonMz1[i] = forwardMass;
                ArrayList<NeutralLoss> forwardIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
                double[] forwardMasses = new double[lossesIndexes.length];
                int indexForward = 0;
                for (j = 0; j < lossesIndexes.length; ++j) {
                    indexes = lossesIndexes[j];
                    neutralLoss = losses[j];
                    if (i < indexes[0]) continue;
                    forwardIonlosses.add(neutralLoss);
                    forwardMasses[indexForward++] = neutralLoss.getMass();
                }
                this.forwardNeutralLossesMasses.add(forwardMasses);
                this.forwardNeutralLosses.add(forwardIonlosses);
            }
            if (!complementary) continue;
            this.complementaryIonMz1[i] = complementaryMass - forwardMass;
            ArrayList<NeutralLoss> complementaryIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
            double[] complementaryMasses = new double[lossesIndexes.length];
            int indexComplementary = 0;
            for (j = 0; j < lossesIndexes.length; ++j) {
                indexes = lossesIndexes[j];
                neutralLoss = losses[j];
                if (i > indexes[j]) continue;
                complementaryIonlosses.add(neutralLoss);
                complementaryMasses[indexComplementary++] = neutralLoss.getMass();
            }
            this.complementaryNeutralLossesMasses.add(complementaryMasses);
            this.complementaryNeutralLosses.add(complementaryIonlosses);
        }
    }

    private int[] getLossesIndexes(char[] aas) {
        int[] lossesIndexes = new int[]{aas.length, aas.length, 0, 0};
        boolean waterForward = false;
        boolean ammoniaForward = false;
        boolean waterComplementary = false;
        boolean ammoniaComplementary = false;
        for (int i = 0; i < aas.length; ++i) {
            char aa = aas[i];
            if (!waterForward) {
                for (char lossAa : NeutralLoss.H2O.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[0] = i;
                    waterForward = true;
                    break;
                }
            }
            if (!ammoniaForward) {
                for (char lossAa : NeutralLoss.NH3.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[1] = i;
                    ammoniaForward = true;
                    break;
                }
            }
            int rewindI = aas.length - i - 1;
            aa = aas[rewindI];
            if (!waterComplementary) {
                for (char lossAa : NeutralLoss.H2O.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[2] = rewindI;
                    waterComplementary = true;
                    break;
                }
            }
            if (!ammoniaComplementary) {
                for (char lossAa : NeutralLoss.NH3.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[3] = rewindI;
                    ammoniaComplementary = true;
                    break;
                }
            }
            if (waterForward && ammoniaForward && waterComplementary && ammoniaComplementary) break;
        }
        return lossesIndexes;
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        for (int i = 0; i < this.peptideLength; ++i) {
            PeptideFragmentIon ion;
            double lossMass2;
            int k;
            double ionMass;
            ArrayList<Peak> peaks;
            double mz1WithLoss;
            double lossMass1;
            int j;
            double ionMz1 = this.forwardIonMz1[i];
            int ionNumber = i + 1;
            ArrayList<NeutralLoss> neutralLosses = this.forwardNeutralLosses.get(i);
            double[] neutralLossesMasses = this.forwardNeutralLossesMasses.get(i);
            for (j = 0; j < neutralLosses.size(); ++j) {
                lossMass1 = neutralLossesMasses[j];
                mz1WithLoss = ionMz1 - lossMass1;
                peaks = spectrumIndex.getMatchingPeaks(mz1WithLoss);
                if (!peaks.isEmpty()) {
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                    ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                    for (Peak peak : peaks) {
                        PeptideFragmentIon ion2 = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, ionLosses);
                        results.add(new IonMatch(peak, ion2, 1));
                    }
                }
                for (k = j + 1; k < neutralLosses.size(); ++k) {
                    lossMass2 = neutralLossesMasses[k];
                    double mz1WithLoss2 = mz1WithLoss - lossMass2;
                    peaks = spectrumIndex.getMatchingPeaks(mz1WithLoss2);
                    if (peaks.isEmpty()) continue;
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                    double ionMass2 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                    for (Peak peak : peaks) {
                        ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass2, ionLosses);
                        results.add(new IonMatch(peak, ion, 1));
                    }
                }
            }
            ionMz1 = this.complementaryIonMz1[i];
            ionNumber = this.peptideLength - ionNumber;
            neutralLosses = this.complementaryNeutralLosses.get(i);
            neutralLossesMasses = this.complementaryNeutralLossesMasses.get(i);
            for (j = 0; j < neutralLosses.size(); ++j) {
                lossMass1 = neutralLossesMasses[j];
                mz1WithLoss = ionMz1 - lossMass1;
                peaks = spectrumIndex.getMatchingPeaks(mz1WithLoss);
                if (!peaks.isEmpty()) {
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                    ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                    for (Peak peak : peaks) {
                        PeptideFragmentIon ion3 = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, ionLosses);
                        results.add(new IonMatch(peak, ion3, 1));
                    }
                }
                for (k = j + 1; k < neutralLosses.size(); ++k) {
                    lossMass2 = neutralLossesMasses[k];
                    double mz1WithLoss2 = mz1WithLoss - lossMass2;
                    peaks = spectrumIndex.getMatchingPeaks(mz1WithLoss2);
                    double ionMass3 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                    if (peaks.isEmpty()) continue;
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                    for (Peak peak : peaks) {
                        ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass3, ionLosses);
                        results.add(new IonMatch(peak, ion, 1));
                    }
                }
            }
        }
        for (int ionCharge = 2; ionCharge < peptideCharge; ++ionCharge) {
            int extraProtons = ionCharge - 1;
            double protonContribution = ElementaryIon.getProtonMassMultiple(extraProtons);
            for (int i = 0; i < this.peptideLength; ++i) {
                PeptideFragmentIon ion;
                double lossMass2;
                double ionMass;
                ArrayList<Peak> peaks;
                double mzWithLoss;
                double mz1WithLoss;
                double lossMass1;
                int j;
                double ionMz1 = this.forwardIonMz1[i];
                int ionNumber = i + 1;
                ArrayList<NeutralLoss> neutralLosses = this.forwardNeutralLosses.get(i);
                double[] neutralLossesMasses = this.forwardNeutralLossesMasses.get(i);
                for (j = 0; j < neutralLosses.size(); ++j) {
                    lossMass1 = neutralLossesMasses[j];
                    mz1WithLoss = ionMz1 - lossMass1;
                    mzWithLoss = (mz1WithLoss + protonContribution) / (double)ionCharge;
                    peaks = spectrumIndex.getMatchingPeaks(mzWithLoss);
                    if (!peaks.isEmpty()) {
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                        ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                        for (Peak peak : peaks) {
                            PeptideFragmentIon ion4 = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, ionLosses);
                            results.add(new IonMatch(peak, ion4, ionCharge));
                        }
                    }
                    for (int k = j + 1; k < neutralLosses.size(); ++k) {
                        lossMass2 = neutralLossesMasses[k];
                        double mz1WithLoss2 = mz1WithLoss - lossMass2;
                        double mzWithLoss2 = (mz1WithLoss2 + protonContribution) / (double)ionCharge;
                        peaks = spectrumIndex.getMatchingPeaks(mzWithLoss2);
                        if (peaks.isEmpty()) continue;
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                        double ionMass4 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                        for (Peak peak : peaks) {
                            ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass4, ionLosses);
                            results.add(new IonMatch(peak, ion, ionCharge));
                        }
                    }
                }
                ionMz1 = this.complementaryIonMz1[i];
                ionNumber = this.peptideLength - ionNumber;
                neutralLosses = this.complementaryNeutralLosses.get(i);
                neutralLossesMasses = this.complementaryNeutralLossesMasses.get(i);
                for (j = 0; j < neutralLosses.size(); ++j) {
                    lossMass1 = neutralLossesMasses[j];
                    mz1WithLoss = ionMz1 - lossMass1;
                    mzWithLoss = (mz1WithLoss + protonContribution) / (double)ionCharge;
                    peaks = spectrumIndex.getMatchingPeaks(mzWithLoss);
                    if (!peaks.isEmpty()) {
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                        ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                        for (Peak peak : peaks) {
                            PeptideFragmentIon ion5 = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, ionLosses);
                            results.add(new IonMatch(peak, ion5, ionCharge));
                        }
                    }
                    for (int k = j + 1; k < neutralLosses.size(); ++k) {
                        lossMass2 = neutralLossesMasses[k];
                        double mz1WithLoss2 = mz1WithLoss - lossMass2;
                        double mzWithLoss2 = (mz1WithLoss2 + protonContribution) / (double)ionCharge;
                        peaks = spectrumIndex.getMatchingPeaks(mzWithLoss2);
                        double ionMass5 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                        if (peaks.isEmpty()) continue;
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                        for (Peak peak : peaks) {
                            ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass5, ionLosses);
                            results.add(new IonMatch(peak, ion, ionCharge));
                        }
                    }
                }
            }
        }
        return results;
    }
}

