/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXBException;

public class OnyaseIdfileReader
implements IdfileReader {
    public static final char separator = ' ';
    public static final char comment = '#';
    public static final String versionTag = "Version:";
    public static final String spectraTag = "Spectrum File:";
    public static final String fastaTag = "Fasta File:";
    public static final String paramsTag = "Parameters File:";
    private File resultsFile;
    private String mgfFile;
    private String fastaFile;
    private String parametersFile;
    private String fileName;
    private HashMap<String, ArrayList<String>> version;
    public static final String encoding = "UTF-8";

    public OnyaseIdfileReader() {
    }

    public OnyaseIdfileReader(File resultsFile) throws IOException {
        this.resultsFile = resultsFile;
        this.fileName = Util.getFileName(resultsFile);
        FileInputStream fileStream = new FileInputStream(resultsFile);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, encoding);
        BufferedReader br = new BufferedReader(decoder);
        String fileVersion = "test";
        this.version = new HashMap(1);
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add(fileVersion);
        this.version.put(Advocate.onyaseEngine.getName(), versions);
        this.mgfFile = "bla\\qExactive01819.mgf";
    }

    @Override
    public String getExtension() {
        return ".psm";
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, false);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String line;
        HashMap<String, SpectrumMatch> spectrumMatchesMap = new HashMap<String, SpectrumMatch>();
        String spectrumFileName = Util.getFileName(this.mgfFile);
        String resultFileName = Util.getFileName(this.resultsFile);
        FileInputStream fileStream = new FileInputStream(this.resultsFile);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, encoding);
        BufferedReader br = new BufferedReader(decoder);
        br.readLine();
        String separatorString = " ";
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] lineSplit = line.split(separatorString);
            String spectrumTitle = lineSplit[0];
            String spectrumKey = Spectrum.getSpectrumKey(spectrumFileName, spectrumTitle = URLDecoder.decode(spectrumTitle, encoding));
            SpectrumMatch spectrumMatch = (SpectrumMatch)spectrumMatchesMap.get(spectrumKey);
            if (spectrumMatch == null) {
                spectrumMatch = new SpectrumMatch(spectrumKey);
                spectrumMatchesMap.put(spectrumKey, spectrumMatch);
            }
            String sequence = lineSplit[3];
            ArrayList<ModificationMatch> modificationMatches = this.getModificationMatches(lineSplit[4]);
            Peptide peptide = new Peptide(sequence, modificationMatches);
            Integer charge = new Integer(lineSplit[5]);
            Double score = new Double(lineSplit[6]);
            Double eValue = new Double(lineSplit[7]);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, -1, Advocate.onyaseEngine.getIndex(), new Charge(1, charge), eValue, resultFileName);
            peptideAssumption.setRawScore(score);
            spectrumMatch.addHit(Advocate.onyaseEngine.getIndex(), peptideAssumption, true);
        }
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        for (SpectrumMatch spectrumMatch : spectrumMatchesMap.values()) {
            HashMap<Double, ArrayList<SpectrumIdentificationAssumption>> assumptionsMap = spectrumMatch.getAllAssumptions(Advocate.onyaseEngine.getIndex());
            ArrayList<Double> eValues = new ArrayList<Double>(assumptionsMap.keySet());
            Collections.sort(eValues);
            int rank = 1;
            int cpt = 1;
            for (Double eValue : eValues) {
                ArrayList<SpectrumIdentificationAssumption> spectrumIdentificationAssumptions = assumptionsMap.get(eValue);
                for (SpectrumIdentificationAssumption spectrumIdentificationAssumption : spectrumIdentificationAssumptions) {
                    spectrumIdentificationAssumption.setRank(rank);
                    ++cpt;
                }
                rank = cpt;
            }
            result.add(spectrumMatch);
        }
        return result;
    }

    private ArrayList<ModificationMatch> getModificationMatches(String modificationsString) throws UnsupportedEncodingException {
        if (modificationsString.length() == 0) {
            return new ArrayList<ModificationMatch>(0);
        }
        String decodedString = URLDecoder.decode(modificationsString, "utf-8");
        String[] modifications = decodedString.split("_");
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>(modifications.length);
        for (String modification : modifications) {
            String[] modificationSplit = modification.split("-ATAA-");
            String modificationName = modificationSplit[0];
            Integer site = new Integer(modificationSplit[1]);
            ModificationMatch modificationMatch = new ModificationMatch(modificationName, true, site);
            modificationMatches.add(modificationMatch);
        }
        return modificationMatches;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        return this.version;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

