/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class MgfReader {
    public static MSnSpectrum getSpectrum(BufferedReader br, String fileName) throws IOException {
        String line;
        HashMap<Double, Peak> spectrum = new HashMap<Double, Peak>();
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList();
        String scanNumber = "";
        String spectrumTitle = "";
        boolean insideSpectrum = false;
        while ((line = br.readLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("BEGIN IONS")) {
                insideSpectrum = true;
                continue;
            }
            if (line.startsWith("TITLE")) {
                spectrumTitle = line.substring(line.indexOf(61) + 1);
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode the mgf title '" + spectrumTitle + "'.");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                String rtInput = line.substring(line.indexOf(61) + 1);
                try {
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = new Double(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = new Double(rtWindow[0]);
                    rt2 = new Double(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time " + rtInput + " in spectrum " + spectrumTitle + ".");
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG")) continue;
            if (line.startsWith("SCANS")) {
                try {
                    scanNumber = line.substring(line.indexOf(61) + 1);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse scan number.");
                }
            }
            if (line.startsWith("TAG") || line.startsWith("RAWSCANS")) continue;
            if (line.startsWith("END IONS")) {
                insideSpectrum = false;
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                MSnSpectrum msnSpectrum = new MSnSpectrum(2, precursor, spectrumTitle, spectrum, fileName);
                if (scanNumber.length() > 0) {
                    msnSpectrum.setScanNumber(scanNumber);
                }
                return msnSpectrum;
            }
            if (!insideSpectrum || line.equals("")) continue;
            try {
                String[] values = line.split("\\s+");
                Double mz = new Double(values[0]);
                Double intensity = new Double(values[1]);
                spectrum.put(mz, new Peak(mz, intensity));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MSnSpectrum> getSpectra(File aFile) throws FileNotFoundException, IOException, IllegalArgumentException {
        ArrayList<MSnSpectrum> spectra = new ArrayList<MSnSpectrum>();
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        try {
            MSnSpectrum spectrum;
            while ((spectrum = MgfReader.getSpectrum(br, aFile.getName())) != null) {
                spectra.add(spectrum);
            }
        }
        finally {
            br.close();
        }
        return spectra;
    }

    public static MgfIndex getIndexMap(File mgfFile) throws FileNotFoundException, IOException {
        return MgfReader.getIndexMap(mgfFile, null);
    }

    public static MgfIndex getIndexMap(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        HashMap<String, Integer> spectrumIndexes = new HashMap<String, Integer>();
        HashMap<Integer, Double> precursorMzMap = new HashMap<Integer, Double>();
        LinkedHashSet<String> spectrumTitles = new LinkedHashSet<String>();
        HashMap<String, Integer> duplicateTitles = new HashMap<String, Integer>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        long currentIndex = 0L;
        String title = null;
        int spectrumCounter = 0;
        double maxRT = -1.0;
        double minRT = Double.MAX_VALUE;
        double maxMz = -1.0;
        double maxIntensity = 0.0;
        int maxCharge = 0;
        int maxPeakCount = 0;
        int peakCount = 0;
        boolean peakPicked = true;
        boolean precursorChargesMissing = false;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        boolean insideSpectrum = false;
        boolean chargeTagFound = false;
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.equals("BEGIN IONS")) {
                insideSpectrum = true;
                chargeTagFound = false;
                currentIndex = bufferedRandomAccessFile.getFilePointer();
                ++spectrumCounter;
                peakCount = 0;
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) break;
                waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
                continue;
            }
            if (line.startsWith("TITLE")) {
                title = line.substring(line.indexOf(61) + 1);
                try {
                    title = URLDecoder.decode(title, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (waitingHandler != null) {
                        waitingHandler.appendReport("An exception was thrown when trying to decode an mgf title: " + title, true, true);
                    }
                    System.out.println("An exception was thrown when trying to decode an mgf title: " + title);
                    e.printStackTrace();
                }
                Integer nDuplicates = (Integer)duplicateTitles.get(title);
                if (nDuplicates != null || spectrumTitles.contains(title)) {
                    if (nDuplicates == null) {
                        nDuplicates = 0;
                        System.err.println("Warning: Spectrum title " + title + " is not unique in " + mgfFile.getName() + "!");
                    }
                    nDuplicates = nDuplicates + 1;
                    duplicateTitles.put(title, nDuplicates);
                    title = title + "_" + nDuplicates;
                }
                spectrumTitles.add(title);
                indexes.put(title, currentIndex);
                spectrumIndexes.put(title, spectrumCounter - 1);
                continue;
            }
            if (line.startsWith("CHARGE")) {
                ArrayList<Charge> precursorCharges = MgfReader.parseCharges(line);
                for (Charge charge : precursorCharges) {
                    if (charge.value <= maxCharge) continue;
                    maxCharge = charge.value;
                }
                chargeTagFound = true;
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                double precursorIntensity;
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                double precursorMz = Double.parseDouble(values[0]);
                if (precursorMz > maxMz) {
                    maxMz = precursorMz;
                }
                if (values.length > 1 && (precursorIntensity = Double.parseDouble(values[1])) > maxIntensity) {
                    maxIntensity = precursorIntensity;
                }
                precursorMzMap.put(spectrumCounter - 1, precursorMz);
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                String rtInput = "";
                try {
                    double rt2;
                    rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        double rt;
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        if ((rt = new Double(tempRt).doubleValue()) > maxRT) {
                            maxRT = rt;
                        }
                        if (!(rt < minRT)) continue;
                        minRT = rt;
                        continue;
                    }
                    if (rtWindow.length != 2 || rtWindow[0].equals("")) continue;
                    double rt1 = new Double(rtWindow[0]);
                    if (rt1 > maxRT) {
                        maxRT = rt1;
                    }
                    if (rt1 < minRT) {
                        minRT = rt1;
                    }
                    if ((rt2 = new Double(rtWindow[1]).doubleValue()) > maxRT) {
                        maxRT = rt2;
                    }
                    if (!(rt2 < minRT)) continue;
                    minRT = rt2;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse retention time: " + rtInput);
                }
            }
            if (line.startsWith("END IONS")) {
                insideSpectrum = false;
                if (title != null && peakCount > maxPeakCount) {
                    maxPeakCount = peakCount;
                }
                title = null;
                if (chargeTagFound) continue;
                precursorChargesMissing = true;
                continue;
            }
            if (!insideSpectrum || line.equals("")) continue;
            try {
                String[] values = line.split("\\s+");
                Double intensity = new Double(values[1]);
                if (peakPicked && intensity == 0.0) {
                    peakPicked = false;
                }
                ++peakCount;
            }
            catch (Exception values) {}
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        ArrayList<String> spectrumTitlesAsArrayList = new ArrayList<String>();
        for (String temp : spectrumTitles) {
            spectrumTitlesAsArrayList.add(temp);
        }
        return new MgfIndex(spectrumTitlesAsArrayList, duplicateTitles, indexes, spectrumIndexes, precursorMzMap, mgfFile.getName(), minRT, maxRT, maxMz, maxIntensity, maxCharge, maxPeakCount, peakPicked, precursorChargesMissing, mgfFile.lastModified(), spectrumCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDuplicateSpectrumTitles(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        String lineBreak = System.getProperty("line.separator");
        try {
            long progressUnit = br.length() / 100L;
            FileWriter fw = new FileWriter(tempSpectrumFile);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    String line;
                    String currentSpectrum = "";
                    boolean includeSpectrum = true;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("BEGIN IONS")) {
                            currentSpectrum = line + lineBreak;
                            if (waitingHandler == null) continue;
                            if (waitingHandler.isRunCanceled()) {
                                break;
                            }
                            waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                            continue;
                        }
                        if (line.startsWith("TITLE")) {
                            currentSpectrum = currentSpectrum + line + lineBreak;
                            String title = line.substring(line.indexOf(61) + 1);
                            try {
                                title = URLDecoder.decode(title, "utf-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                throw new UnsupportedEncodingException("An exception was thrown when trying to decode an mgf title: " + title);
                            }
                            if (!spectrumTitles.contains(title)) {
                                spectrumTitles.add(title);
                                includeSpectrum = true;
                                continue;
                            }
                            includeSpectrum = false;
                            continue;
                        }
                        if (line.startsWith("END IONS")) {
                            currentSpectrum = currentSpectrum + line + lineBreak;
                            if (!includeSpectrum) continue;
                            bw.write(currentSpectrum);
                            bw.newLine();
                            continue;
                        }
                        currentSpectrum = currentSpectrum + line + lineBreak;
                    }
                }
                finally {
                    bw.close();
                }
            }
            finally {
                fw.close();
            }
        }
        finally {
            br.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMissingSpectrumTitles(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        String lineBreak = System.getProperty("line.separator");
        try {
            long progressUnit = br.length() / 100L;
            FileWriter fw = new FileWriter(tempSpectrumFile);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    String line;
                    String currentSpectrum = "";
                    String title = null;
                    int spectrumCounter = 0;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("BEGIN IONS")) {
                            ++spectrumCounter;
                            if (waitingHandler == null) continue;
                            if (waitingHandler.isRunCanceled()) {
                                break;
                            }
                            waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                            continue;
                        }
                        if (line.startsWith("TITLE")) {
                            currentSpectrum = currentSpectrum + line + lineBreak;
                            title = line.substring(line.indexOf(61) + 1);
                            try {
                                title = URLDecoder.decode(title, "utf-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                throw new UnsupportedEncodingException("An exception was thrown when trying to decode an mgf title: " + title);
                            }
                            spectrumTitles.add(title);
                            continue;
                        }
                        if (line.startsWith("END IONS")) {
                            bw.write("BEGIN IONS" + lineBreak);
                            if (title == null) {
                                title = "Spectrum " + spectrumCounter;
                                while (spectrumTitles.contains(title)) {
                                    title = "Spectrum " + ++spectrumCounter;
                                }
                                spectrumTitles.add(title);
                                bw.write("TITLE=" + title + lineBreak);
                            }
                            bw.write(currentSpectrum);
                            bw.write("END IONS" + lineBreak);
                            currentSpectrum = "";
                            title = null;
                            continue;
                        }
                        currentSpectrum = currentSpectrum + line + lineBreak;
                    }
                }
                finally {
                    bw.close();
                }
            }
            finally {
                fw.close();
            }
        }
        finally {
            br.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMissingPrecursorCharges(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
        BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        String lineBreak = System.getProperty("line.separator");
        try {
            long progressUnit = br.length() / 100L;
            FileWriter fw = new FileWriter(tempSpectrumFile);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    String line;
                    boolean chargeFound = false;
                    boolean insideSpectrum = false;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("BEGIN IONS")) {
                            insideSpectrum = true;
                            chargeFound = false;
                            if (waitingHandler != null) {
                                if (waitingHandler.isRunCanceled()) {
                                    break;
                                }
                                waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                            }
                        } else if (line.startsWith("END IONS")) {
                            insideSpectrum = false;
                        } else if (line.startsWith("CHARGE")) {
                            chargeFound = true;
                        } else if (!line.equals("") && insideSpectrum && !chargeFound) {
                            try {
                                String[] values = line.split("\\s+");
                                new Double(values[0]);
                                new Double(values[1]);
                                bw.write("CHARGE=");
                                for (int i = userPreferences.getMinSpectrumChargeRange().intValue(); i <= userPreferences.getMaxSpectrumChargeRange(); ++i) {
                                    if (i > userPreferences.getMinSpectrumChargeRange()) {
                                        bw.write(" and ");
                                    }
                                    bw.write(i + "+");
                                }
                                bw.write(lineBreak);
                                chargeFound = true;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        bw.write(line);
                        bw.write(lineBreak);
                    }
                }
                finally {
                    bw.close();
                }
            }
            finally {
                fw.close();
            }
        }
        finally {
            br.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeZeroes(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        try {
            long progressUnit = br.length() / 100L;
            FileWriter fw = new FileWriter(tempSpectrumFile);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                try {
                    String line;
                    boolean spectrum = false;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("BEGIN IONS")) {
                            spectrum = true;
                            if (waitingHandler != null) {
                                if (waitingHandler.isRunCanceled()) {
                                    break;
                                }
                                waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                            }
                        } else if (line.startsWith("END IONS")) {
                            spectrum = false;
                        }
                        boolean peak = true;
                        boolean zero = false;
                        String[] split = line.split(" ");
                        if (split.length != 2 && split.length != 3 && (split = line.split("\t")).length != 2 && split.length != 3) {
                            peak = false;
                        }
                        if (peak) {
                            try {
                                new Double(split[0]);
                            }
                            catch (Exception e) {
                                peak = false;
                            }
                            if (peak) {
                                try {
                                    Double intensity = new Double(split[1]);
                                    if (intensity == 0.0) {
                                        zero = true;
                                    }
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("Line not recognized:\n" + line);
                                }
                            }
                        }
                        if (spectrum && peak && zero) continue;
                        bw.write(line);
                        bw.newLine();
                    }
                }
                finally {
                    bw.close();
                }
            }
            finally {
                fw.close();
            }
        }
        finally {
            br.close();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static void renameDuplicateSpectrumTitles(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        FileWriter fw = new FileWriter(tempSpectrumFile);
        BufferedWriter bw = new BufferedWriter(fw);
        FileReader fr = new FileReader(mgfFile);
        BufferedReader br = new BufferedReader(fr);
        String lineBreak = System.getProperty("line.separator");
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith("TITLE")) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                String originalTitle = line.substring(line.indexOf(61) + 1);
                try {
                    originalTitle = URLDecoder.decode(originalTitle, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    throw new UnsupportedEncodingException("An exception was thrown when trying to decode an mgf title: " + originalTitle);
                }
                String tempTitle = originalTitle;
                int counter = 2;
                while (spectrumTitles.contains(tempTitle)) {
                    tempTitle = originalTitle + " (" + counter++ + ")";
                }
                spectrumTitles.add(tempTitle);
                bw.write("TITLE=" + tempTitle + lineBreak);
            } else {
                bw.write(line + lineBreak);
            }
            line = br.readLine();
        }
        br.close();
        fr.close();
        bw.close();
        fw.close();
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public ArrayList<MgfIndex> splitFile(File mgfFile, int nSpectra, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String fileName = mgfFile.getName();
        if (fileName.toLowerCase().endsWith(".mgf")) {
            String line;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(100);
                waitingHandler.setSecondaryProgressCounter(0);
            }
            String splittedName = fileName.substring(0, fileName.lastIndexOf("."));
            ArrayList<File> splittedFiles = new ArrayList<File>();
            int fileCounter = 1;
            int spectrumCounter = 0;
            String currentName = splittedName + "_" + fileCounter + ".mgf";
            File testFile = new File(mgfFile.getParent(), currentName);
            splittedFiles.add(testFile);
            BufferedRandomAccessFile writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
            BufferedRandomAccessFile readBufferedRandomAccessFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
            String lineBreak = System.getProperty("line.separator");
            long sizeOfReadAccessFile = readBufferedRandomAccessFile.length();
            long lastIndex = 0L;
            long progressUnit = sizeOfReadAccessFile / 100L;
            while ((line = readBufferedRandomAccessFile.getNextLine()) != null) {
                if (line.endsWith("\r")) {
                    line = line.replace("\r", "");
                }
                if (line.startsWith("BEGIN IONS")) {
                    long readIndex = readBufferedRandomAccessFile.getFilePointer();
                    if (++spectrumCounter > nSpectra && sizeOfReadAccessFile - readIndex > (readIndex - lastIndex) / 2L) {
                        writeBufferedRandomAccessFile.close();
                        currentName = splittedName + "_" + ++fileCounter + ".mgf";
                        testFile = new File(mgfFile.getParent(), currentName);
                        splittedFiles.add(testFile);
                        lastIndex = readIndex;
                        spectrumCounter = 0;
                        writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
                    }
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) break;
                        waitingHandler.setSecondaryProgressCounter((int)(readIndex / progressUnit));
                    }
                }
                writeBufferedRandomAccessFile.writeBytes(line + lineBreak);
            }
            writeBufferedRandomAccessFile.close();
            readBufferedRandomAccessFile.close();
            ArrayList<MgfIndex> mgfIndexes = new ArrayList<MgfIndex>();
            for (int i = 0; i < splittedFiles.size(); ++i) {
                File newFile = (File)splittedFiles.get(i);
                if (waitingHandler != null) {
                    waitingHandler.setWaitingText("Indexing New Files " + (i + 1) + "/" + splittedFiles.size() + ". Please Wait...");
                }
                mgfIndexes.add(MgfReader.getIndexMap(newFile, waitingHandler));
                if (waitingHandler.isRunCanceled()) break;
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            return mgfIndexes;
        }
        throw new IllegalArgumentException("Spectrum file format not supported.");
    }

    public static MSnSpectrum getSpectrum(BufferedRandomAccessFile bufferedRandomAccessFile, long index, String fileName) throws IOException, IllegalArgumentException {
        String line;
        bufferedRandomAccessFile.seek(index);
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList();
        String scanNumber = "";
        String spectrumTitle = "";
        HashMap<Double, Peak> spectrum = new HashMap<Double, Peak>();
        boolean insideSpectrum = false;
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("BEGIN IONS")) {
                insideSpectrum = true;
                spectrum = new HashMap();
                continue;
            }
            if (line.startsWith("TITLE")) {
                insideSpectrum = true;
                spectrumTitle = line.substring(line.indexOf(61) + 1);
                try {
                    spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode an mgf title: " + spectrumTitle);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = new Double(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = new Double(rtWindow[0]);
                    rt2 = new Double(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time: " + spectrumTitle);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG")) continue;
            if (line.startsWith("SCANS")) {
                try {
                    scanNumber = line.substring(line.indexOf(61) + 1);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse scan number.");
                }
            }
            if (line.startsWith("INSTRUMENT")) continue;
            if (line.startsWith("END IONS")) {
                insideSpectrum = false;
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
                MSnSpectrum msnSpectrum = new MSnSpectrum(2, precursor, spectrumTitle, spectrum, fileName);
                msnSpectrum.setScanNumber(scanNumber);
                return msnSpectrum;
            }
            if (!insideSpectrum || line.equals("")) continue;
            try {
                String[] values = line.split("\\s+");
                Double mz = new Double(values[0]);
                Double intensity = new Double(values[1]);
                spectrum.put(mz, new Peak(mz, intensity));
            }
            catch (Exception exception) {}
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\".");
    }

    private static ArrayList<Charge> parseCharges(String chargeLine) throws IllegalArgumentException {
        ArrayList<Charge> result = new ArrayList<Charge>(1);
        String tempLine = chargeLine.substring(chargeLine.indexOf("=") + 1);
        String[] chargesAnd = tempLine.split(" and ");
        ArrayList<String> chargesAsString = new ArrayList<String>();
        for (String charge : chargesAnd) {
            for (String charge2 : charge.split(",")) {
                chargesAsString.add(charge2.trim());
            }
        }
        for (String chargeAsString : chargesAsString) {
            if ((chargeAsString = chargeAsString.trim()).isEmpty()) continue;
            try {
                if (chargeAsString.endsWith("+")) {
                    Integer value = new Integer(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(new Charge(1, value));
                    continue;
                }
                if (chargeAsString.endsWith("-")) {
                    Integer value = new Integer(chargeAsString.substring(0, chargeAsString.length() - 1));
                    result.add(new Charge(-1, value));
                    continue;
                }
                if (chargeAsString.equalsIgnoreCase("Mr")) continue;
                result.add(new Charge(1, new Integer(chargeAsString)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("'" + chargeAsString + "' could not be processed as a valid precursor charge!");
            }
        }
        if (result.isEmpty()) {
            result.add(new Charge(1, 1));
        }
        return result;
    }

    public static Precursor getPrecursor(BufferedRandomAccessFile bufferedRandomAccessFile, Long index, String fileName) throws IOException, IllegalArgumentException {
        String line;
        bufferedRandomAccessFile.seek(index.longValue());
        String title = null;
        double precursorMz = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList(1);
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if (line.endsWith("\r")) {
                line = line.replace("\r", "");
            }
            if (line.startsWith("TITLE")) {
                title = line.substring(line.indexOf("=") + 1);
                try {
                    title = URLDecoder.decode(title, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("An exception was thrown when trying to decode an mgf title: " + title);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMz = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        String tempRt = rtWindow[0];
                        if (tempRt.startsWith("PT") && tempRt.endsWith("S")) {
                            tempRt = tempRt.substring(2, tempRt.length() - 1);
                        }
                        rt = new Double(tempRt);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = new Double(rtWindow[0]);
                    rt2 = new Double(rtWindow[1]);
                }
                catch (Exception e) {
                    System.out.println("An exception was thrown when trying to decode the retention time: " + title);
                    e.printStackTrace();
                }
                continue;
            }
            if (line.isEmpty() || !line.startsWith("END IONS") && (line.contains("#") || line.contains("="))) continue;
            if (rt1 != -1.0 && rt2 != -1.0) {
                return new Precursor(precursorMz, precursorIntensity, precursorCharges, rt1, rt2);
            }
            return new Precursor(rt, precursorMz, precursorIntensity, precursorCharges);
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\". File: " + fileName + ", title: " + title);
    }

    public static void writeAplFile(File mgfFile, File aplFile, String fragmentation) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (fragmentation == null) {
            fragmentation = "Unknown";
        }
        BufferedWriter aplWriter = new BufferedWriter(new FileWriter(aplFile));
        MgfIndex mgfIndex = MgfReader.getIndexMap(mgfFile);
        HashMap spectrumTitleMap = new HashMap();
        BufferedRandomAccessFile mgfRFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        for (String title : mgfIndex.getSpectrumTitles()) {
            Precursor precursor = MgfReader.getPrecursor(mgfRFile, mgfIndex.getIndex(title), mgfFile.getName());
            if (!spectrumTitleMap.containsKey(precursor.getMz())) {
                spectrumTitleMap.put(precursor.getMz(), new ArrayList());
            }
            ((ArrayList)spectrumTitleMap.get(precursor.getMz())).add(title);
        }
        ArrayList masses = new ArrayList(spectrumTitleMap.keySet());
        Collections.sort(masses);
        Iterator iterator = masses.iterator();
        while (iterator.hasNext()) {
            double mz = (Double)iterator.next();
            for (String title : (ArrayList)spectrumTitleMap.get(mz)) {
                MSnSpectrum spectrum = MgfReader.getSpectrum(mgfRFile, mgfIndex.getIndex(title), mgfFile.getName());
                aplWriter.write("peaklist start\n");
                aplWriter.write("mz=" + mz + "\n");
                aplWriter.write("fragmentation=" + fragmentation + "\n");
                aplWriter.write("charge=" + spectrum.getPrecursor().getPossibleCharges().get((int)0).value + "\n");
                aplWriter.write("header=" + spectrum.getSpectrumTitle() + "\n");
                HashMap<Double, Peak> peakMap = spectrum.getPeakMap();
                ArrayList<Double> fragmentMasses = new ArrayList<Double>(peakMap.keySet());
                Collections.sort(fragmentMasses);
                for (double fragmentMass : fragmentMasses) {
                    aplWriter.write(fragmentMass + "\t" + peakMap.get((Object)Double.valueOf((double)fragmentMass)).intensity + "\n");
                }
                aplWriter.write("peaklist end\n\n");
            }
        }
        mgfRFile.close();
        ((Writer)aplWriter).close();
    }
}

