/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.writers;

import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.WorkbookStyle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

public class TextWriter
extends ExportWriter {
    private final BufferedWriter writer;
    private final String separator;
    private final int nSeparationLines;
    private int nSections = 0;

    public TextWriter(File destinationFile, String separator, int nSeparationLines) throws IOException {
        this.separator = separator;
        this.writer = new BufferedWriter(new FileWriter(destinationFile));
        this.exportFormat = ExportFormat.text;
        this.nSeparationLines = nSeparationLines;
    }

    @Override
    public void write(String text, WorkbookStyle textStyle) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void writeMainTitle(String text, WorkbookStyle textStyle) throws IOException {
        if (text != null) {
            this.writer.write(text);
            for (int i = 1; i <= this.nSeparationLines; ++i) {
                this.writer.newLine();
            }
        }
    }

    @Override
    public void startNewSection(String sectionTitle, WorkbookStyle textStyle) throws IOException {
        if (sectionTitle != null) {
            this.writer.newLine();
            this.writer.write(sectionTitle);
        }
        for (int i = 1; i <= this.nSeparationLines; ++i) {
            this.writer.newLine();
        }
        ++this.nSections;
    }

    @Override
    public void writeHeaderText(String text, WorkbookStyle textStyle) throws IOException {
        this.writer.write(text);
    }

    @Override
    public void addSeparator(WorkbookStyle textStyle) throws IOException {
        this.writer.write(this.separator);
    }

    @Override
    public void newLine() throws IOException {
        this.writer.newLine();
    }

    @Override
    public void close() throws IOException, FileNotFoundException {
        this.writer.close();
    }

    @Override
    public void increaseDepth() {
    }

    @Override
    public void decreseDepth() {
    }
}

