/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import java.util.ArrayList;
import java.util.Arrays;
import umontreal.iro.lecuyer.gof.KernelDensity;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.KernelDensityGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.MRG31k3p;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalKernelDensityEstimator {
    private final int n = 4096;
    private EmpiricalDist empiricalDist;
    private KernelDensityGen kernelDensityGen;
    private double datasetSize;

    private void init(double[] data) {
        this.datasetSize = data.length;
        Arrays.sort(data);
        this.empiricalDist = new EmpiricalDist(data);
        MRG31k3p stream = new MRG31k3p();
        NormalGen normalKernelDensityGen = new NormalGen((RandomStream)stream);
        this.kernelDensityGen = new KernelDensityGen((RandomStream)stream, this.empiricalDist, normalKernelDensityGen);
    }

    public ArrayList estimateDensityFunction(Double[] data) {
        this.init(this.excludeNullValues(data));
        return this.estimateDensityFunction();
    }

    public ArrayList estimateDensityFunction(double[] data) {
        this.init(data);
        return this.estimateDensityFunction();
    }

    private ArrayList estimateDensityFunction() {
        ArrayList<double[]> densityFunction = new ArrayList<double[]>();
        double[] randomSamples = new double[4096];
        for (int i = 0; i < 4096; ++i) {
            double nextDouble;
            randomSamples[i] = nextDouble = this.kernelDensityGen.nextDouble();
        }
        Arrays.sort(randomSamples);
        densityFunction.add(randomSamples);
        NormalDist kern = new NormalDist();
        double bandWidth = 0.99 * Math.min(this.empiricalDist.getSampleStandardDeviation(), this.empiricalDist.getInterQuartileRange() / 1.34) / Math.pow(this.datasetSize, 0.2);
        double[] estimatedDensityValues = KernelDensity.computeDensity((EmpiricalDist)this.empiricalDist, (ContinuousDistribution)kern, (double)bandWidth, (double[])randomSamples);
        densityFunction.add(estimatedDensityValues);
        return densityFunction;
    }

    public double[] excludeNullValues(Double[] data) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Double value : data) {
            if (value == null) continue;
            list.add(value);
        }
        double[] newArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newArray[i] = (Double)list.get(i);
        }
        return newArray;
    }
}

