/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.writer.JsonReader;

public class JSONRPC2Parser {
    private final JSONParser parser = new JSONParser(4032);
    private boolean preserveOrder;
    private boolean ignoreVersion;
    private boolean parseNonStdAttributes;

    public JSONRPC2Parser() {
        this(false, false, false);
    }

    public JSONRPC2Parser(boolean preserveOrder) {
        this(preserveOrder, false, false);
    }

    public JSONRPC2Parser(boolean preserveOrder, boolean ignoreVersion) {
        this(preserveOrder, ignoreVersion, false);
    }

    public JSONRPC2Parser(boolean preserveOrder, boolean ignoreVersion, boolean parseNonStdAttributes) {
        this.preserveOrder = preserveOrder;
        this.ignoreVersion = ignoreVersion;
        this.parseNonStdAttributes = parseNonStdAttributes;
    }

    private Map<String, Object> parseJSONObject(String jsonString) throws JSONRPC2ParseException {
        Object json;
        if (jsonString.trim().length() == 0) {
            throw new JSONRPC2ParseException("Invalid JSON: Empty string", 1, jsonString);
        }
        try {
            json = this.preserveOrder ? this.parser.parse(jsonString, new JsonReader().DEFAULT_ORDERED) : this.parser.parse(jsonString);
        }
        catch (Exception e) {
            throw new JSONRPC2ParseException("Invalid JSON", 1, jsonString);
        }
        if (json instanceof List) {
            throw new JSONRPC2ParseException("JSON-RPC 2.0 batch requests/notifications not supported", jsonString);
        }
        if (!(json instanceof Map)) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 message: Message must be a JSON object", jsonString);
        }
        return (Map)json;
    }

    private static void ensureVersion2(Object version, String jsonString) throws JSONRPC2ParseException {
        if (version == null) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0: Version string missing", jsonString);
        }
        if (!(version instanceof String)) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0: Version not a JSON string", jsonString);
        }
        if (!version.equals("2.0")) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0: Version must be \"2.0\"", jsonString);
        }
    }

    public JSONRPC2Message parseJSONRPC2Message(String jsonString) throws JSONRPC2ParseException {
        try {
            return this.parseJSONRPC2Request(jsonString);
        }
        catch (JSONRPC2ParseException e) {
            if (e.getCauseType() == 1) {
                throw e;
            }
            try {
                return this.parseJSONRPC2Notification(jsonString);
            }
            catch (JSONRPC2ParseException e2) {
                if (e2.getCauseType() == 1) {
                    throw e2;
                }
                try {
                    return this.parseJSONRPC2Response(jsonString);
                }
                catch (JSONRPC2ParseException e3) {
                    if (e3.getCauseType() == 1) {
                        throw e3;
                    }
                    throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 message", 0, jsonString);
                }
            }
        }
    }

    public JSONRPC2Request parseJSONRPC2Request(String jsonString) throws JSONRPC2ParseException {
        JSONRPC2Request request;
        Object method;
        Map<String, Object> jsonObject = this.parseJSONObject(jsonString);
        Object version = jsonObject.remove("jsonrpc");
        if (!this.ignoreVersion) {
            JSONRPC2Parser.ensureVersion2(version, jsonString);
        }
        if ((method = jsonObject.remove("method")) == null) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 request: Method name missing", jsonString);
        }
        if (!(method instanceof String)) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 request: Method name not a JSON string", jsonString);
        }
        if (((String)method).length() == 0) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 request: Method name is an empty string", jsonString);
        }
        if (!jsonObject.containsKey("id")) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 request: Missing identifier", jsonString);
        }
        Object id = jsonObject.remove("id");
        if (!(id == null || id instanceof Number || id instanceof Boolean || id instanceof String)) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 request: Identifier not a JSON scalar", jsonString);
        }
        Object params = jsonObject.remove("params");
        if (params == null) {
            request = new JSONRPC2Request((String)method, id);
        } else if (params instanceof List) {
            request = new JSONRPC2Request((String)method, (List)params, id);
        } else if (params instanceof Map) {
            request = new JSONRPC2Request((String)method, (Map)params, id);
        } else {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 request: Method parameters have unexpected JSON type", jsonString);
        }
        if (this.parseNonStdAttributes) {
            for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                request.appendNonStdAttribute(entry.getKey(), entry.getValue());
            }
        }
        return request;
    }

    public JSONRPC2Notification parseJSONRPC2Notification(String jsonString) throws JSONRPC2ParseException {
        JSONRPC2Notification notification;
        Object method;
        Map<String, Object> jsonObject = this.parseJSONObject(jsonString);
        Object version = jsonObject.remove("jsonrpc");
        if (!this.ignoreVersion) {
            JSONRPC2Parser.ensureVersion2(version, jsonString);
        }
        if ((method = jsonObject.remove("method")) == null) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 notification: Method name missing", jsonString);
        }
        if (!(method instanceof String)) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 notification: Method name not a JSON string", jsonString);
        }
        if (((String)method).length() == 0) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 notification: Method name is an empty string", jsonString);
        }
        Object params = jsonObject.get("params");
        if (params == null) {
            notification = new JSONRPC2Notification((String)method);
        } else if (params instanceof List) {
            notification = new JSONRPC2Notification((String)method, (List)params);
        } else if (params instanceof Map) {
            notification = new JSONRPC2Notification((String)method, (Map)params);
        } else {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 notification: Method parameters have unexpected JSON type", jsonString);
        }
        if (this.parseNonStdAttributes) {
            for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                notification.appendNonStdAttribute(entry.getKey(), entry.getValue());
            }
        }
        return notification;
    }

    public JSONRPC2Response parseJSONRPC2Response(String jsonString) throws JSONRPC2ParseException {
        JSONRPC2Response response;
        Object id;
        Map<String, Object> jsonObject = this.parseJSONObject(jsonString);
        Object version = jsonObject.remove("jsonrpc");
        if (!this.ignoreVersion) {
            JSONRPC2Parser.ensureVersion2(version, jsonString);
        }
        if (!((id = jsonObject.remove("id")) == null || id instanceof Boolean || id instanceof Number || id instanceof String)) {
            throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: Identifier not a JSON scalar", jsonString);
        }
        if (jsonObject.containsKey("result") && !jsonObject.containsKey("error")) {
            Object res = jsonObject.remove("result");
            response = new JSONRPC2Response(res, id);
        } else if (!jsonObject.containsKey("result") && jsonObject.containsKey("error")) {
            String errorMessage;
            int errorCode;
            Object errorJSON = jsonObject.remove("error");
            if (errorJSON == null) {
                throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: Missing error object", jsonString);
            }
            if (!(errorJSON instanceof Map)) {
                throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: Error object not a JSON object");
            }
            Map error = (Map)errorJSON;
            try {
                errorCode = ((Number)error.get("code")).intValue();
            }
            catch (Exception e) {
                throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: Error code missing or not an integer", jsonString);
            }
            try {
                errorMessage = (String)error.get("message");
            }
            catch (Exception e) {
                throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: Error message missing or not a string", jsonString);
            }
            Object errorData = error.get("data");
            response = new JSONRPC2Response(new JSONRPC2Error(errorCode, errorMessage, errorData), id);
        } else {
            if (jsonObject.containsKey("result") && jsonObject.containsKey("error")) {
                throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: You cannot have result and error at the same time", jsonString);
            }
            if (!jsonObject.containsKey("result") && !jsonObject.containsKey("error")) {
                throw new JSONRPC2ParseException("Invalid JSON-RPC 2.0 response: Neither result nor error specified", jsonString);
            }
            throw new AssertionError();
        }
        if (this.parseNonStdAttributes) {
            for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                response.appendNonStdAttribute(entry.getKey(), entry.getValue());
            }
        }
        return response;
    }

    public void preserveOrder(boolean preserveOrder) {
        this.preserveOrder = preserveOrder;
    }

    public boolean preservesOrder() {
        return this.preserveOrder;
    }

    public void ignoreVersion(boolean ignore) {
        this.ignoreVersion = ignore;
    }

    public boolean ignoresVersion() {
        return this.ignoreVersion;
    }

    public void parseNonStdAttributes(boolean enable) {
        this.parseNonStdAttributes = enable;
    }

    public boolean parsesNonStdAttributes() {
        return this.parseNonStdAttributes;
    }
}

