/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java._SQLiteSwigged;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class SQLite {
    public static final String LIBRARY_PATH_PROPERTY = "sqlite4java.library.path";
    private static boolean debugBinaryPreferred = "true".equalsIgnoreCase(System.getProperty("sqlite4java.debug.binary.preferred"));
    private static boolean libraryLoaded = false;
    private static String jarVersion = null;
    private static Boolean threadSafe = null;

    public static synchronized void setDebugBinaryPreferred(boolean debug) {
        if (libraryLoaded) {
            Internal.logWarn(SQLite.class, "cannot set library preference, library already loaded");
            return;
        }
        debugBinaryPreferred = debug;
    }

    public static synchronized boolean isDebugBinaryPreferred() {
        return debugBinaryPreferred;
    }

    public static synchronized void loadLibrary() throws SQLiteException {
        if (!libraryLoaded) {
            Throwable t = Internal.loadLibraryX();
            if (t != null) {
                throw new SQLiteException(-91, "cannot load library: " + t, t);
            }
            libraryLoaded = true;
            int threadSafe = _SQLiteSwigged.sqlite3_threadsafe();
            if (threadSafe == 0) {
                Internal.logWarn(SQLite.class, "library is not thread-safe");
            }
        }
    }

    public static String getSQLiteVersion() throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_libversion();
    }

    public static String getSQLiteCompileOptions() throws SQLiteException {
        String option;
        SQLite.loadLibrary();
        StringBuilder b = new StringBuilder();
        int i = 0;
        while ((option = _SQLiteSwigged.sqlite3_compileoption_get(i++)) != null && option.length() != 0) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(option);
        }
        return b.toString();
    }

    public static int getSQLiteVersionNumber() throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_libversion_number();
    }

    public static boolean isThreadSafe() throws SQLiteException {
        Boolean cachedResult = threadSafe;
        if (cachedResult != null) {
            return cachedResult;
        }
        SQLite.loadLibrary();
        boolean r = _SQLiteSwigged.sqlite3_threadsafe() != 0;
        threadSafe = r;
        return r;
    }

    public static boolean isComplete(String sql) throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_complete(sql) != 0;
    }

    public static long getMemoryUsed() throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_memory_used();
    }

    public static long getMemoryHighwater(boolean reset) throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_memory_highwater(reset ? 1 : 0);
    }

    public static int releaseMemory(int bytes) throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_release_memory(bytes);
    }

    public static void setSoftHeapLimit(int limit) throws SQLiteException {
        SQLite.loadLibrary();
        _SQLiteSwigged.sqlite3_soft_heap_limit64(limit);
    }

    public static long softHeapLimit(long limit) throws SQLiteException {
        SQLite.loadLibrary();
        return _SQLiteSwigged.sqlite3_soft_heap_limit64(limit);
    }

    public static void setSharedCache(boolean enabled) throws SQLiteException {
        SQLite.loadLibrary();
        int rc = _SQLiteSwigged.sqlite3_enable_shared_cache(enabled ? 1 : 0);
        if (rc != 0) {
            throw new SQLiteException(rc, "SQLite: cannot set shared_cache to " + enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getLibraryVersion() {
        if (jarVersion == null) {
            String name = SQLite.class.getName().replace('.', '/') + ".class";
            URL url = SQLite.class.getClassLoader().getResource(name);
            if (url == null) {
                return null;
            }
            String s = url.toString();
            if (!s.startsWith("jar:")) {
                return null;
            }
            int k = s.lastIndexOf(33);
            if (k < 0) {
                return null;
            }
            s = s.substring(0, k + 1) + "/META-INF/MANIFEST.MF";
            InputStream input = null;
            Manifest manifest = null;
            try {
                input = new URL(s).openStream();
                manifest = new Manifest(input);
            }
            catch (IOException e) {
                Internal.logWarn(SQLite.class, "error reading jar manifest" + e);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {}
            }
            if (manifest != null) {
                Attributes attr = manifest.getMainAttributes();
                jarVersion = attr.getValue("Implementation-Version");
            }
        }
        if (jarVersion == null) {
            Internal.logWarn(SQLite.class, "unknown jar version");
        }
        return jarVersion;
    }

    public static synchronized void setLibraryPath(String path) {
        if (libraryLoaded) {
            Internal.logWarn(SQLite.class, "cannot set library path, library already loaded");
            return;
        }
        System.setProperty(LIBRARY_PATH_PROPERTY, path);
    }

    private SQLite() {
    }

    public static void main(String[] args) {
        Throwable t;
        if (args.length > 0 && "-d".equals(args[0])) {
            Handler[] handlers;
            Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.FINE);
            for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                handler.setLevel(Level.FINE);
                handler.setFormatter(new NiceFormatter());
            }
        } else {
            Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.SEVERE);
        }
        String v = SQLite.getLibraryVersion();
        if (v == null) {
            v = "(UNKNOWN VERSION)";
        }
        System.out.println("sqlite4java " + v);
        Throwable throwable = t = libraryLoaded ? null : Internal.loadLibraryX();
        if (t != null) {
            System.out.println("Error: cannot load SQLite");
            t.printStackTrace();
        } else {
            try {
                System.out.println("SQLite " + SQLite.getSQLiteVersion());
                System.out.println("Compile-time options: " + SQLite.getSQLiteCompileOptions());
            }
            catch (SQLiteException e) {
                e.printStackTrace();
            }
        }
    }

    private static class NiceFormatter
    extends Formatter {
        private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyMMdd:HHmmss.SSS", Locale.US);
        private static final String LINE_SEPARATOR;

        private NiceFormatter() {
        }

        public String format(LogRecord record) {
            if (record == null) {
                return "";
            }
            StringBuilder r = new StringBuilder();
            r.append(DATE_FORMAT.format(record.getMillis())).append(' ');
            Level level = record.getLevel();
            if (level == null) {
                level = Level.ALL;
            }
            r.append(level.getName()).append(' ');
            r.append(record.getMessage());
            r.append(LINE_SEPARATOR);
            return r.toString();
        }

        static {
            String s = System.getProperty("line.separator");
            if (s == null) {
                s = "\n";
            }
            LINE_SEPARATOR = s;
        }
    }
}

