/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope;

import fr.profi.mzscope.ConverterListener;
import fr.profi.mzscope.threading.queue.TaskManagerThread;
import fr.profi.mzscope.threading.task.ConvertRawFile2MzdbCallback;
import fr.profi.mzscope.threading.task.ConvertRawFile2MzdbTask;
import fr.profi.mzscope.ui.RawMinerPanel;
import fr.proline.mzscope.model.EmptyRawFile;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.RawFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterManager
extends Thread
implements ConverterListener {
    private static List<File> m_rawFiles;
    private static ConverterManager m_instance;
    private static File m_converterFile;
    private static String m_converterOption;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());
    private RawMinerPanel rawpanel;
    private Map<String, IRawFile> m_emptyRawFileByName;

    public static ConverterManager getInstance() {
        if (m_instance == null) {
            m_instance = new ConverterManager();
        }
        return m_instance;
    }

    private ConverterManager() {
        m_rawFiles = new ArrayList<File>();
        this.m_emptyRawFileByName = new HashMap<String, IRawFile>();
    }

    public static void setConverterExeFile(File exeFile) {
        m_converterFile = exeFile;
    }

    public static void setConverterOption(String option) {
        m_converterOption = option;
    }

    public void setRawMinerPanel(RawMinerPanel panel) {
        this.rawpanel = panel;
    }

    public static File getConverterExeFile() {
        return m_converterFile;
    }

    public static String getConverterOption() {
        return m_converterOption;
    }

    public void addFiles(List<File> newFiles) {
        m_rawFiles.addAll(newFiles);
        if (this.rawpanel != null) {
            for (File file2Convert : newFiles) {
                EmptyRawFile eRf = new EmptyRawFile(file2Convert.getName());
                this.m_emptyRawFileByName.put(file2Convert.getName(), (IRawFile)eRf);
                this.rawpanel.addRawFile((IRawFile)eRf);
            }
        }
    }

    public File getAndRemoveNextFile() {
        if (!m_rawFiles.isEmpty()) {
            return m_rawFiles.remove(0);
        }
        return null;
    }

    public boolean fileToConvertExist() {
        return !m_rawFiles.isEmpty();
    }

    public void runConvert() {
        if (this.fileToConvertExist()) {
            ConvertRawFile2MzdbCallback callback = new ConvertRawFile2MzdbCallback();
            callback.setListener(this);
            ConvertRawFile2MzdbTask task = new ConvertRawFile2MzdbTask(callback, this.getAndRemoveNextFile());
            task.setListener(this);
            TaskManagerThread.getTaskManagerThread().addTask(task);
        }
    }

    @Override
    public void convertStart(File file2Convert) {
    }

    @Override
    public void convertEnd(File file2Convert, File convertedFile, boolean success) {
        IRawFile eRf;
        if (file2Convert != null && (eRf = this.m_emptyRawFileByName.get(file2Convert.getName())) != null) {
            this.rawpanel.closeRawFile(eRf);
        }
        if (success) {
            IRawFile rawfile = RawFileManager.getInstance().addRawFile(convertedFile);
            this.rawpanel.addRawFile(rawfile);
        }
        ConverterManager.getInstance().runConvert();
    }
}

