/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ionlibraries;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.profi.mzscope.ionlibraries.IonEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IonLibrary {
    private static final Logger logger = LoggerFactory.getLogger(IonLibrary.class);
    private final List<IonEntry> entries;
    private final List<IonEntry> nonRedondantEntries;
    private final Map<String, List<IonEntry>> entriesBySequence = new HashMap<String, List<IonEntry>>();

    public static IonLibrary fromFile(File file, IonEntry prototypeEntry) {
        ArrayList<IonEntry> entries = new ArrayList<IonEntry>();
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader fReader = new BufferedReader(new InputStreamReader(fis));
            CsvMapper mapper = new CsvMapper();
            mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator('\t');
            MappingIterator it = mapper.readerFor(prototypeEntry.getClass()).with((FormatSchema)schema).readValues((Reader)fReader);
            while (it.hasNext()) {
                IonEntry row = (IonEntry)it.next();
                entries.add(row);
            }
        }
        catch (Exception ex) {
            logger.error("Error while parsing CSV file", (Throwable)ex);
        }
        return new IonLibrary(entries);
    }

    private IonLibrary(List<IonEntry> entries) {
        this.entries = entries;
        this.nonRedondantEntries = new ArrayList<IonEntry>();
        for (IonEntry e : entries) {
            if (!this.entriesBySequence.containsKey(e.getModification_sequence())) {
                this.entriesBySequence.put(e.getModification_sequence(), new ArrayList(10));
                this.nonRedondantEntries.add(e);
            }
            this.entriesBySequence.get(e.getModification_sequence()).add(e);
        }
    }

    public List<IonEntry> getEntries() {
        return this.entries;
    }

    public List<IonEntry> getNonRedondantEntries() {
        return this.nonRedondantEntries;
    }

    public List<IonEntry> getIonEntryBySequence(String sequence) {
        return this.entriesBySequence.get(sequence);
    }

    public void saveToFile(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        logger.info("Start writing ion library to " + file.getAbsolutePath());
        CsvMapper mapper = new CsvMapper();
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
        mapper.writer((FormatSchema)this.entries.get(0).getSchema()).writeValues(file).writeAll((Object[])this.entries.toArray(new IonEntry[0]));
        writer.flush();
        writer.close();
        logger.info("Library written");
    }

    public static class Peptide {
        private IonEntry prototype;

        public Peptide(IonEntry ionPrototype) {
            this.prototype = ionPrototype;
        }

        public Double getQ1() {
            return this.prototype.getQ1();
        }

        public String getSequence() {
            return this.prototype.getModification_sequence();
        }

        public Double getIntensity() {
            return this.prototype.getPrec_y();
        }

        public Integer getCharge() {
            return this.prototype.getPrec_z();
        }

        public Boolean getShared() {
            return this.prototype.getShared();
        }

        public String getProtein_name() {
            return this.prototype.getProtein_name();
        }

        public Double getRT_detected() {
            return this.prototype.getRT_detected();
        }
    }
}

