/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.InternalStructure;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.SelectorRStar;
import com.github.davidmoten.rtree.Serializer;
import com.github.davidmoten.rtree.SerializerHelper;
import com.github.davidmoten.rtree.SplitterRStar;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.FactoryDefault;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import rx.functions.Func0;
import rx.functions.Func1;

public class SerializerKryo<T, S extends Geometry>
implements Serializer<T, S> {
    private final Func1<? super T, byte[]> serializer;
    private final Func1<byte[], ? extends T> deserializer;
    private final Func0<Kryo> kryoFactory;

    public SerializerKryo(Func1<? super T, byte[]> serializer, Func1<byte[], ? extends T> deserializer, Func0<Kryo> kryoFactory) {
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.kryoFactory = kryoFactory;
    }

    @Override
    public void write(RTree<T, S> tree, OutputStream os) throws IOException {
        Output output = new Output(os);
        Kryo kryo = (Kryo)this.kryoFactory.call();
        this.write(kryo, output, tree);
    }

    private void write(Kryo kryo, Output output, RTree<T, S> tree) {
        this.writeContext(tree.context(), output);
        output.writeBoolean(tree.root().isPresent());
        output.writeInt(tree.size());
        if (tree.root().isPresent()) {
            this.writeNode(tree.root().get(), output);
        }
    }

    private void writeNode(Node<T, S> node, Output output) {
        boolean isLeaf = node instanceof Leaf;
        output.writeBoolean(isLeaf);
        if (isLeaf) {
            Leaf leaf = (Leaf)node;
            this.writeBounds(output, leaf.geometry().mbr());
            output.writeInt(leaf.count());
            for (Entry entry : leaf.entries()) {
                Object g = entry.geometry();
                this.writeValue(output, entry.value());
                this.writeGeometry(output, g);
            }
        } else {
            NonLeaf nonLeaf = (NonLeaf)node;
            this.writeBounds(output, nonLeaf.geometry().mbr());
            output.writeInt(nonLeaf.count());
            for (Node nd : nonLeaf.children()) {
                this.writeNode(nd, output);
            }
        }
    }

    private void writeValue(Output output, T t) {
        byte[] bytes = (byte[])this.serializer.call(t);
        output.write(bytes.length);
        output.write(bytes);
    }

    private void writeRectangle(Output output, S g) {
        Rectangle r = (Rectangle)g;
        output.write(0);
        this.writeBounds(output, r);
    }

    private void writeGeometry(Output output, S g) {
        if (!(g instanceof Rectangle)) {
            throw new RuntimeException("unexpected");
        }
        this.writeRectangle(output, g);
    }

    private void writeBounds(Output output, Rectangle mbr) {
        output.writeBoolean(mbr.isDoublePrecision());
        if (mbr.isDoublePrecision()) {
            output.writeDouble(mbr.x1());
            output.writeDouble(mbr.y1());
            output.writeDouble(mbr.y1());
            output.writeDouble(mbr.y2());
        } else {
            output.writeFloat((float)mbr.x1());
            output.writeFloat((float)mbr.y1());
            output.writeFloat((float)mbr.y1());
            output.writeFloat((float)mbr.y2());
        }
    }

    private void writeContext(Context<T, S> context, Output output) {
        output.writeInt(context.minChildren());
        output.writeInt(context.maxChildren());
    }

    @Override
    public RTree<T, S> read(InputStream is, long sizeBytes, InternalStructure structure) throws IOException {
        Input input = new Input(is);
        return SerializerKryo.read(input);
    }

    private static <T, S extends Geometry> RTree<T, S> read(Input input) {
        Context<T, S> context = SerializerKryo.readContext(input);
        boolean hasRoot = input.readBoolean();
        int size = input.readInt();
        Optional root = hasRoot ? Optional.of(SerializerKryo.readNode(input)) : Optional.empty();
        return SerializerHelper.create(root, size, context);
    }

    private static <T, S extends Geometry> Node<T, S> readNode(Input input) {
        return null;
    }

    private static <T, S extends Geometry> Context<T, S> readContext(Input input) {
        return new Context(2, 4, new SelectorRStar(), new SplitterRStar(), FactoryDefault.instance());
    }

    public static <T, S extends Geometry> Serializer<T, S> create(Func1<? super T, byte[]> serializer, Func1<byte[], ? extends T> deserializer, Func0<Kryo> kryoFactory) {
        return new SerializerKryo<T, S>(serializer, deserializer, kryoFactory);
    }
}

