/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.Util;
import com.compomics.util.db.DerbyUtil;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Semaphore;
import javax.sql.rowset.serial.SerialBlob;

public class ObjectsDB
implements Serializable {
    static final long serialVersionUID = -8595805180622832745L;
    private String dbName;
    private String path;
    private Connection dbConnection;
    public static final int TABLE_NAME_MAX_LENGTH = 128;
    public static final int VARCHAR_MAX_LENGTH = 32672;
    public static final int MAX_KEY_LENGTH = 1000;
    private ArrayList<String> longTableNames = new ArrayList();
    private HashMap<String, ArrayList<String>> longKeysMap = new HashMap();
    private HashSet<String> usedTables = new HashSet();
    private int tablesContentCacheSize = 4;
    private HashMap<String, HashSet<String>> tablesContentCache = new HashMap(this.tablesContentCacheSize);
    public static final String DB_ATTRIBUTES = "long_key_table";
    public static final String LONG_KEY_PREFIX = "long_key_";
    public static final String LONG_TABLE_NAMES = "long_tables";
    public static final String USED_TABLES_TABLE = "used_tables_table";
    public static final String CONNECTION_LOG_TABLE = "connection_log_table";
    private ObjectsCache objectsCache;
    private BufferedWriter debugSpeedWriter;
    private BufferedWriter debugContentWriter;
    private File debugFolder;
    private boolean loading = false;
    private Semaphore dbMutex = new Semaphore(1);
    private ArrayList<String> tableQueue = new ArrayList();
    private HashMap<String, HashSet<String>> contentQueue = new HashMap();
    private ArrayList<String> contentTableQueue = new ArrayList();
    private Semaphore queueMutex = new Semaphore(1);
    private boolean debugSpeed = false;
    private boolean debugContent = false;
    private static boolean debugInteractions = false;
    private boolean useSQLite = false;
    public static final String derbyConnectionID = "objectsDB";

    public ObjectsDB(String folder, String dbName, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.dbName = dbName;
        objectsCache.addDb(this);
        this.establishConnection(folder, deleteOldDatabase, objectsCache);
    }

    public String getName() {
        return this.dbName;
    }

    public ObjectsCache getObjectsCache() {
        return this.objectsCache;
    }

    public void setObjectCache(ObjectsCache objectCache) {
        this.objectsCache = objectCache;
        objectCache.addDb(this);
    }

    public void addTable(String tableName) throws SQLException, InterruptedException {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Inserting table, table: " + tableName);
        }
        Statement stmt = this.dbConnection.createStatement();
        this.dbMutex.acquire();
        try {
            stmt.execute("CREATE table " + tableName + " (NAME VARCHAR(" + 32672 + ") PRIMARY KEY,MATCH_BLOB blob)");
        }
        catch (SQLException e) {
            System.out.println("An error occurred while creating table " + tableName);
            throw e;
        }
        finally {
            stmt.close();
        }
        this.dbMutex.release();
    }

    public boolean hasTable(String tableName) throws SQLException, InterruptedException {
        if (tableName.startsWith("\"") && tableName.endsWith("\"")) {
            tableName = tableName.substring(1, tableName.length() - 1);
        }
        ArrayList<String> tables = this.getTables();
        for (String tempTable : tables) {
            if (!tempTable.equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getTables() throws SQLException, InterruptedException {
        this.dbMutex.acquire();
        DatabaseMetaData dmd = this.dbConnection.getMetaData();
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = dmd.getTables(null, null, null, null);
        try {
            while (rs.next()) {
                String tempDbName = (String)rs.getObject("TABLE_NAME");
                result.add(tempDbName);
            }
        }
        finally {
            rs.close();
        }
        this.dbMutex.release();
        return result;
    }

    public void insertObject(String tableName, String objectKey, Object object, boolean inCache) throws SQLException, IOException, InterruptedException {
        String correctedKey = this.correctKey(tableName, objectKey);
        if (inCache) {
            this.objectsCache.addObject(this.dbName, tableName, correctedKey, object, true, true);
        } else {
            this.insertObject(tableName, objectKey, correctedKey, object, inCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(String tableName, String objectKey, String correctedKey, Object object, boolean inCache) throws SQLException, IOException, InterruptedException {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Inserting single object, table: " + tableName + ", key: " + objectKey);
        }
        if (this.usedTables != null) {
            this.usedTables.add(tableName);
        }
        this.dbMutex.acquire();
        PreparedStatement ps = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
        try {
            ps.setString(1, correctedKey);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    oos.writeObject(object);
                }
                finally {
                    oos.close();
                }
            }
            finally {
                bos.close();
            }
            ps.setBytes(2, bos.toByteArray());
            ps.executeUpdate();
        }
        finally {
            ps.close();
        }
        this.tablesContentCache.remove(tableName);
        this.dbMutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObjects(String tableName, HashMap<String, Object> objects, WaitingHandler waitingHandler) throws SQLException, IOException, InterruptedException {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Preparing table insertion: " + tableName);
        }
        if (this.usedTables != null) {
            this.usedTables.add(tableName);
        }
        this.dbMutex.acquire();
        this.dbConnection.setAutoCommit(false);
        HashSet<String> tableContent = this.getTableContentFromDBNoMutex(tableName);
        HashSet<String> addedKeys = new HashSet<String>(objects.size());
        HashMap<String, String> updateKeys = new HashMap<String, String>(objects.size());
        PreparedStatement insertStatement = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
        try {
            int rowCounter = 0;
            for (String objectKey : objects.keySet()) {
                String correctedKey = this.correctKey(tableName, objectKey);
                if (this.debugContent) {
                    if (debugInteractions) {
                        System.out.println(System.currentTimeMillis() + " Inserting batch of objects, table: " + tableName + ", key: " + objectKey);
                    }
                    File debugObjectFile = new File(this.debugFolder, "debugMatch");
                    FileOutputStream fos = new FileOutputStream(debugObjectFile);
                    BufferedOutputStream debugBos = new BufferedOutputStream(fos);
                    ObjectOutputStream debugOos = new ObjectOutputStream(debugBos);
                    debugOos.writeObject(objects.get(objectKey));
                    debugOos.close();
                    debugBos.close();
                    fos.close();
                    long size = debugObjectFile.length();
                    this.debugContentWriter.write(tableName + "\t" + objectKey + "\t" + size + "\n");
                    this.debugContentWriter.flush();
                }
                if (tableContent.contains(correctedKey)) {
                    updateKeys.put(objectKey, correctedKey);
                    continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    try {
                        oos.writeObject(objects.get(objectKey));
                        insertStatement.setString(1, correctedKey);
                        insertStatement.setBytes(2, bos.toByteArray());
                        insertStatement.addBatch();
                        if (++rowCounter % this.objectsCache.getBatchSize() == 0) {
                            insertStatement.executeBatch();
                            insertStatement.clearParameters();
                            this.dbConnection.commit();
                            insertStatement.close();
                            insertStatement = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
                            rowCounter = 0;
                        }
                    }
                    finally {
                        oos.close();
                    }
                }
                finally {
                    bos.close();
                }
                addedKeys.add(correctedKey);
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                break;
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                insertStatement.executeBatch();
                insertStatement.clearParameters();
                this.dbConnection.commit();
            }
            tableContent.addAll(addedKeys);
        }
        finally {
            insertStatement.close();
        }
        PreparedStatement updateStatement = this.dbConnection.prepareStatement("UPDATE " + tableName + " SET MATCH_BLOB=? WHERE NAME=?");
        try {
            int rowCounter = 0;
            for (String objectKey : updateKeys.keySet()) {
                String correctedKey = (String)updateKeys.get(objectKey);
                if (this.debugContent) {
                    if (debugInteractions) {
                        System.out.println(System.currentTimeMillis() + " Updating batch of objects, table: " + tableName + ", key: " + objectKey);
                    }
                    File debugObjectFile = new File(this.debugFolder, "debugMatch");
                    FileOutputStream fos = new FileOutputStream(debugObjectFile);
                    BufferedOutputStream debugBos = new BufferedOutputStream(fos);
                    ObjectOutputStream debugOos = new ObjectOutputStream(debugBos);
                    debugOos.writeObject(objects.get(objectKey));
                    debugOos.close();
                    debugBos.close();
                    fos.close();
                    long size = debugObjectFile.length();
                    this.debugContentWriter.write(tableName + "\t" + objectKey + "\t" + size + "\n");
                    this.debugContentWriter.flush();
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    try {
                        oos.writeObject(objects.get(objectKey));
                        updateStatement.setString(2, correctedKey);
                        updateStatement.setBytes(1, bos.toByteArray());
                        updateStatement.addBatch();
                        if (++rowCounter % this.objectsCache.getBatchSize() == 0) {
                            updateStatement.executeBatch();
                            updateStatement.clearParameters();
                            this.dbConnection.commit();
                            updateStatement.close();
                            updateStatement = this.dbConnection.prepareStatement("UPDATE " + tableName + " SET MATCH_BLOB=? WHERE NAME=?");
                            rowCounter = 0;
                        }
                    }
                    finally {
                        oos.close();
                    }
                }
                finally {
                    bos.close();
                }
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                break;
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                updateStatement.executeBatch();
                updateStatement.clearParameters();
                this.dbConnection.commit();
            }
        }
        finally {
            updateStatement.close();
        }
        this.dbConnection.setAutoCommit(true);
        this.dbMutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObjects(String tableName, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.usedTables == null || this.usedTables.contains(tableName)) {
            if (!this.loading && (this.tableQueue.isEmpty() || this.tableQueue.indexOf(tableName) == 0)) {
                ResultSet results;
                if (debugInteractions) {
                    System.out.println(System.currentTimeMillis() + " getting table objects, table: " + tableName);
                }
                if (waitingHandler != null && displayProgress) {
                    waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                    this.dbMutex.acquire();
                    Statement rowCountStatement = this.dbConnection.createStatement();
                    Integer numberOfRows = null;
                    try {
                        results = rowCountStatement.executeQuery("select count(*) from " + tableName);
                        results.next();
                        numberOfRows = results.getInt(1);
                    }
                    finally {
                        rowCountStatement.close();
                    }
                    this.dbMutex.release();
                    if (numberOfRows != null) {
                        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                        waitingHandler.setSecondaryProgressCounter(0);
                        waitingHandler.setMaxSecondaryProgressCounter(numberOfRows);
                    }
                }
                HashMap<String, Object> objectsFromDb = new HashMap<String, Object>();
                this.dbMutex.acquire();
                this.loading = true;
                try {
                    Statement stmt = this.dbConnection.createStatement();
                    try {
                        results = stmt.executeQuery("select * from " + tableName);
                        try {
                            while (results.next()) {
                                Blob tempBlob;
                                String key;
                                if (waitingHandler != null) {
                                    if (waitingHandler.isRunCanceled()) break;
                                    if (displayProgress) {
                                        waitingHandler.increaseSecondaryProgressCounter();
                                    }
                                }
                                if (this.objectsCache.inCache(this.dbName, tableName, key = results.getString(1))) continue;
                                if (this.useSQLite) {
                                    byte[] bytes = results.getBytes(2);
                                    tempBlob = new SerialBlob(bytes);
                                } else {
                                    tempBlob = results.getBlob(2);
                                }
                                BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                                try {
                                    ObjectInputStream in = new ObjectInputStream(bis);
                                    try {
                                        Object object = in.readObject();
                                        objectsFromDb.put(key, object);
                                    }
                                    finally {
                                        in.close();
                                    }
                                }
                                finally {
                                    bis.close();
                                }
                            }
                            this.tableQueue.remove(tableName);
                        }
                        finally {
                            results.close();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
                finally {
                    this.loading = false;
                }
                this.dbMutex.release();
                for (String key : objectsFromDb.keySet()) {
                    if (this.objectsCache.inCache(this.dbName, tableName, key)) continue;
                    Object object = objectsFromDb.get(key);
                    this.objectsCache.addObject(this.dbName, tableName, key, object, false, false);
                }
                this.objectsCache.updateCache();
            } else {
                if (!this.tableQueue.contains(tableName)) {
                    this.tableQueue.add(tableName);
                }
                while (this.loading) {
                    this.wait(11L);
                }
                this.loadObjects(tableName, waitingHandler, displayProgress);
            }
        }
    }

    public void loadObjects(String tableName, ArrayList<String> keys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        HashSet<String> keysToQuery = new HashSet<String>(keys);
        HashSet<String> queue = this.contentQueue.get(tableName);
        if (queue != null) {
            this.queueMutex.acquire();
            queue = this.contentQueue.get(tableName);
            if (queue != null) {
                keysToQuery.addAll(queue);
                this.contentTableQueue.remove(tableName);
                this.contentQueue.remove(tableName);
            }
            this.queueMutex.release();
        }
        this.loadObjects(tableName, keysToQuery, waitingHandler, displayProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadObjects(String tableName, HashSet<String> keys, WaitingHandler waitingHandler, boolean displayProgress) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.usedTables == null || this.usedTables.contains(tableName)) {
            if (!this.loading && (this.contentTableQueue.isEmpty() || this.contentTableQueue.indexOf(tableName) == 0)) {
                if (debugInteractions) {
                    System.out.println(System.currentTimeMillis() + " getting " + keys.size() + " objects, table: " + tableName);
                }
                ArrayList<String> toLoad = new ArrayList<String>(keys.size());
                for (String key : keys) {
                    String correctedKey = this.correctKey(tableName, key);
                    if (this.objectsCache == null || this.objectsCache.inCache(this.dbName, tableName, correctedKey)) continue;
                    toLoad.add(correctedKey);
                }
                if (!toLoad.isEmpty()) {
                    HashMap<String, Object> objectsFromDb = new HashMap<String, Object>(toLoad.size());
                    this.dbMutex.acquire();
                    this.loading = true;
                    try {
                        Statement stmt = this.dbConnection.createStatement();
                        try {
                            ResultSet results = stmt.executeQuery("select * from " + tableName);
                            try {
                                int found = 0;
                                while (results.next() && found < toLoad.size()) {
                                    String key = results.getString(1);
                                    if (toLoad.contains(key)) {
                                        Blob tempBlob;
                                        ++found;
                                        if (this.useSQLite) {
                                            byte[] bytes = results.getBytes(2);
                                            tempBlob = new SerialBlob(bytes);
                                        } else {
                                            tempBlob = results.getBlob(2);
                                        }
                                        BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                                        try {
                                            ObjectInputStream in = new ObjectInputStream(bis);
                                            try {
                                                Object object = in.readObject();
                                                objectsFromDb.put(key, object);
                                            }
                                            finally {
                                                in.close();
                                            }
                                        }
                                        finally {
                                            bis.close();
                                        }
                                        if (waitingHandler != null && displayProgress) {
                                            waitingHandler.increaseSecondaryProgressCounter();
                                        }
                                    }
                                    if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                                    break;
                                }
                            }
                            finally {
                                results.close();
                            }
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    finally {
                        this.loading = false;
                    }
                    this.dbMutex.release();
                    for (String key : objectsFromDb.keySet()) {
                        if (this.objectsCache.inCache(this.dbName, tableName, key)) continue;
                        Object object = objectsFromDb.get(key);
                        this.objectsCache.addObject(this.dbName, tableName, key, object, false, false);
                    }
                    this.objectsCache.updateCache();
                }
            } else {
                this.queueMutex.acquire();
                HashSet<String> queue = this.contentQueue.get(tableName);
                if (queue == null) {
                    this.contentTableQueue.add(tableName);
                    this.contentQueue.put(tableName, keys);
                } else if (keys == queue) {
                    while (this.loading) {
                        this.wait(7L);
                    }
                    this.loadObjects(tableName, keys, waitingHandler, displayProgress);
                } else {
                    queue.addAll(keys);
                }
                this.queueMutex.release();
            }
        }
    }

    public Object retrieveObject(String tableName, String objectKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.retrieveObject(tableName, objectKey, useDB, true);
    }

    public Object retrieveObject(String tableName, String objectKey, boolean useDB, boolean useCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String correctedKey = this.correctKey(tableName, objectKey);
        Object object = null;
        if (this.objectsCache != null) {
            object = this.objectsCache.getObject(this.dbName, tableName, correctedKey);
        }
        if (!useDB || object != null) {
            return object;
        }
        if (this.usedTables == null || this.usedTables.contains(tableName)) {
            return this.retrieveObject(tableName, objectKey, correctedKey, useDB, useCache);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object retrieveObject(String tableName, String objectKey, String correctedKey, boolean useDB, boolean useCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Object object;
        block19: {
            object = null;
            if (this.objectsCache != null) {
                object = this.objectsCache.getObject(this.dbName, tableName, correctedKey);
            }
            if (debugInteractions) {
                System.out.println(System.currentTimeMillis() + " Retrieving object, table: " + tableName + ", key: " + objectKey);
            }
            if (this.dbConnection == null || this.usedTables != null && !this.usedTables.contains(tableName)) {
                return object;
            }
            this.dbMutex.acquire();
            long start = System.currentTimeMillis();
            Statement stmt = this.dbConnection.createStatement();
            try {
                ResultSet results = stmt.executeQuery("select MATCH_BLOB from " + tableName + " where NAME='" + correctedKey + "'");
                try {
                    Blob tempBlob;
                    if (!results.next()) break block19;
                    if (this.useSQLite) {
                        byte[] bytes = results.getBytes(1);
                        tempBlob = new SerialBlob(bytes);
                    } else {
                        tempBlob = results.getBlob(1);
                    }
                    BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
                    try {
                        ObjectInputStream in = new ObjectInputStream(bis);
                        try {
                            object = in.readObject();
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        bis.close();
                    }
                    if (this.debugSpeed) {
                        long loaded = System.currentTimeMillis();
                        File debugObjectFile = new File(this.debugFolder, "debugMatch");
                        FileOutputStream fos = new FileOutputStream(debugObjectFile);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        oos.writeObject(object);
                        oos.close();
                        bos.close();
                        fos.close();
                        long written = System.currentTimeMillis();
                        FileInputStream fis = new FileInputStream(debugObjectFile);
                        bis = new BufferedInputStream(fis);
                        ObjectInputStream in = new ObjectInputStream(bis);
                        Object match = in.readObject();
                        fis.close();
                        bis.close();
                        in.close();
                        long read = System.currentTimeMillis();
                        long size = debugObjectFile.length();
                        long queryTime = loaded - start;
                        long serializationTime = written - loaded;
                        long deserializationTime = read - written;
                        this.debugSpeedWriter.write(tableName + "\t" + objectKey + "\t" + queryTime + "\t" + serializationTime + "\t" + deserializationTime + "\t" + size + "\n");
                    }
                }
                finally {
                    results.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        this.dbMutex.release();
        if (useCache && !this.objectsCache.inCache(this.dbName, tableName, objectKey)) {
            this.objectsCache.addObject(this.dbName, tableName, objectKey, object, false, true);
        }
        return object;
    }

    public boolean inDB(String tableName, String objectKey, boolean cache) throws SQLException, InterruptedException {
        String correctedKey = this.correctKey(tableName, objectKey);
        if (cache && this.objectsCache.inCache(this.dbName, tableName, correctedKey)) {
            return true;
        }
        if (this.usedTables != null && !this.usedTables.contains(tableName)) {
            return false;
        }
        return this.savedInDB(tableName, objectKey, correctedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean savedInDB(String tableName, String objectKey, String correctedKey) throws SQLException, InterruptedException {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Checking db content, table: " + tableName + ", key: " + objectKey);
        }
        this.dbMutex.acquire();
        Statement stmt = this.dbConnection.createStatement();
        boolean result = false;
        try {
            ResultSet results = stmt.executeQuery("select * from " + tableName + " where NAME='" + correctedKey + "'");
            try {
                result = results.next();
            }
            finally {
                results.close();
            }
        }
        finally {
            stmt.close();
        }
        this.dbMutex.release();
        return result;
    }

    public HashSet<String> getTableContent(String tableName) throws SQLException, InterruptedException {
        HashSet<String> tableContent;
        if (this.tablesContentCache != null && (tableContent = this.tablesContentCache.get(tableName)) != null) {
            return tableContent;
        }
        return this.getTableContentFromDB(tableName);
    }

    private HashSet<String> getTableContentFromDB(String tableName) throws SQLException, InterruptedException {
        this.dbMutex.acquire();
        HashSet<String> result = this.getTableContentFromDBNoMutex(tableName);
        this.dbMutex.release();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> getTableContentFromDBNoMutex(String tableName) throws SQLException, InterruptedException {
        HashSet<String> tableContent;
        if (this.tablesContentCache != null && (tableContent = this.tablesContentCache.get(tableName)) != null) {
            return tableContent;
        }
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Checking db content, table: " + tableName);
        }
        tableContent = new HashSet();
        Statement stmt = this.dbConnection.createStatement();
        try {
            ResultSet results = stmt.executeQuery("select * from " + tableName);
            try {
                while (results.next()) {
                    String key = results.getString(1);
                    if (key.startsWith(LONG_KEY_PREFIX)) {
                        key = this.getOriginalKey(tableName, key);
                    }
                    tableContent.add(key);
                }
            }
            finally {
                results.close();
            }
        }
        finally {
            stmt.close();
        }
        if (this.tablesContentCache != null) {
            if (this.tablesContentCache.size() == this.tablesContentCacheSize) {
                String keyToRemove = null;
                for (String key : this.tablesContentCache.keySet()) {
                    if (key.equals(tableName)) continue;
                    keyToRemove = key;
                    break;
                }
                if (keyToRemove != null) {
                    this.tablesContentCache.remove(keyToRemove);
                }
            }
            this.tablesContentCache.put(tableName, tableContent);
        }
        return tableContent;
    }

    public void deleteObject(String tableName, String objectKey) throws SQLException, IOException, InterruptedException {
        String correctedKey = this.correctKey(tableName, objectKey);
        this.objectsCache.removeObject(this.dbName, tableName, correctedKey);
        this.dbMutex.acquire();
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Removing object, table: " + tableName + ", key: " + objectKey);
        }
        if (this.usedTables == null || this.usedTables.contains(tableName)) {
            Statement stmt = this.dbConnection.createStatement();
            try {
                stmt.executeUpdate("delete from " + tableName + " where NAME='" + correctedKey + "'");
            }
            catch (SQLSyntaxErrorException e) {
                System.out.println("SQL Exception. SQL call: delete from " + tableName + " where NAME='" + correctedKey + "'");
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        this.dbMutex.release();
    }

    public void updateObject(String tableName, String objectKey, Object object) throws SQLException, IOException, InterruptedException {
        this.updateObject(tableName, objectKey, object, true);
    }

    public void updateObject(String tableName, String objectKey, Object object, boolean cache) throws SQLException, IOException, InterruptedException {
        String correctedKey = this.correctKey(tableName, objectKey);
        boolean cacheUpdated = false;
        if (cache) {
            cacheUpdated = this.objectsCache.updateObject(this.dbName, tableName, correctedKey, object);
        }
        if (!cacheUpdated && (this.usedTables == null || this.usedTables.contains(tableName))) {
            this.updateObjectInDb(tableName, objectKey, correctedKey, object, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObjectInDb(String tableName, String objectKey, String correctedKey, Object object, boolean cache) throws SQLException, IOException, InterruptedException {
        boolean cacheUpdated = false;
        if (cache) {
            cacheUpdated = this.objectsCache.updateObject(this.dbName, tableName, correctedKey, object);
        }
        if (!cacheUpdated && (this.usedTables == null || this.usedTables.contains(tableName))) {
            this.dbMutex.acquire();
            if (debugInteractions) {
                System.out.println(System.currentTimeMillis() + " Updating object, table: " + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("update " + tableName + " set MATCH_BLOB=? where NAME='" + objectKey + "'");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    try {
                        oos.writeObject(object);
                    }
                    finally {
                        oos.close();
                    }
                }
                finally {
                    bos.close();
                }
                ps.setBytes(1, bos.toByteArray());
                ps.executeUpdate();
            }
            finally {
                ps.close();
            }
            this.dbMutex.release();
        }
    }

    private synchronized void logConnection() throws SQLException, IOException, InterruptedException {
        if (!this.hasTable(CONNECTION_LOG_TABLE)) {
            this.addTable(CONNECTION_LOG_TABLE);
        }
        Date date = new Date();
        String key = date + "_" + System.currentTimeMillis();
        this.insertObject(CONNECTION_LOG_TABLE, key, date, false);
        this.wait(1L);
    }

    private void loadAttributes() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (this.hasTable(DB_ATTRIBUTES)) {
            this.longTableNames = (ArrayList)this.retrieveObject(DB_ATTRIBUTES, LONG_TABLE_NAMES, true, false);
            this.longKeysMap = (HashMap)this.retrieveObject(DB_ATTRIBUTES, LONG_KEY_PREFIX, true, false);
            this.usedTables = (HashSet)this.retrieveObject(DB_ATTRIBUTES, USED_TABLES_TABLE, true, false);
        }
    }

    private void saveAttributes() throws SQLException, IOException, InterruptedException {
        if (!this.hasTable(DB_ATTRIBUTES)) {
            this.addTable(DB_ATTRIBUTES);
        }
        if (this.inDB(DB_ATTRIBUTES, LONG_TABLE_NAMES, false)) {
            this.updateObject(DB_ATTRIBUTES, LONG_TABLE_NAMES, this.longTableNames, false);
        } else {
            this.insertObject(DB_ATTRIBUTES, LONG_TABLE_NAMES, this.longTableNames, false);
        }
        if (this.inDB(DB_ATTRIBUTES, LONG_KEY_PREFIX, false)) {
            this.updateObject(DB_ATTRIBUTES, LONG_KEY_PREFIX, this.longKeysMap, false);
        } else {
            this.insertObject(DB_ATTRIBUTES, LONG_KEY_PREFIX, this.longKeysMap, false);
        }
        if (this.usedTables != null) {
            if (this.inDB(DB_ATTRIBUTES, USED_TABLES_TABLE, false)) {
                this.updateObject(DB_ATTRIBUTES, USED_TABLES_TABLE, this.usedTables, false);
            } else {
                this.insertObject(DB_ATTRIBUTES, USED_TABLES_TABLE, this.usedTables, false);
            }
        }
    }

    public boolean isConnectionActive() {
        return this.path != null && DerbyUtil.isActiveConnection(derbyConnectionID, this.path);
    }

    public void close() throws SQLException, InterruptedException {
        block13: {
            this.dbMutex.acquire();
            while (this.dbMutex.getQueueLength() > 0) {
                this.dbMutex.release();
                this.wait(5L);
                this.dbMutex.acquire();
            }
            this.dbMutex.release();
            if (this.dbConnection != null) {
                try {
                    this.saveAttributes();
                }
                catch (Exception e) {
                    if (this.dbConnection == null) break block13;
                    e.printStackTrace();
                }
            }
        }
        this.dbMutex.acquire();
        this.objectsCache = null;
        try {
            if (this.dbConnection != null && this.isConnectionActive()) {
                this.dbConnection.close();
                DerbyUtil.removeActiveConnection(derbyConnectionID, this.path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.debugSpeed && this.debugSpeedWriter != null) {
            try {
                this.debugSpeedWriter.close();
                this.debugSpeedWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent && this.debugContentWriter != null) {
            try {
                this.debugContentWriter.close();
                this.debugContentWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbConnection = null;
        this.dbMutex.release();
    }

    public void establishConnection(String aDbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        File parentFolder = new File(aDbFolder);
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        File dbFolder = new File(aDbFolder, this.dbName);
        this.path = dbFolder.getAbsolutePath();
        if (dbFolder.exists() && deleteOldDatabase) {
            this.close();
            DerbyUtil.closeConnection();
            boolean deleted = Util.deleteDir(dbFolder);
            if (!deleted) {
                System.out.println("Failed to delete db folder: " + dbFolder.getPath());
            }
        }
        if (this.dbMutex == null) {
            this.dbMutex = new Semaphore(1);
            this.queueMutex = new Semaphore(1);
            this.tablesContentCacheSize = 4;
            this.tablesContentCache = new HashMap(this.tablesContentCacheSize);
        }
        this.dbMutex.acquire();
        if (this.useSQLite) {
            try {
                Class.forName("org.sqlite.JDBC");
                this.dbConnection = DriverManager.getConnection("jdbc:sqlite:" + this.path);
            }
            catch (SQLException e) {
                this.useSQLite = false;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        if (!this.useSQLite) {
            if (this.isConnectionActive()) {
                throw new IllegalArgumentException("Impossible to establish a Derby connection in " + this.path + ", connection to the folder already active.");
            }
            String url = "jdbc:derby:" + this.path + ";create=true";
            this.dbConnection = DriverManager.getConnection(url);
            DerbyUtil.addActiveConnection(derbyConnectionID, this.path);
        }
        if (this.dbConnection != null) {
            this.dbConnection.setReadOnly(false);
        }
        this.objectsCache = objectsCache;
        if (this.debugSpeed) {
            try {
                this.debugFolder = new File(aDbFolder);
                this.debugSpeedWriter = new BufferedWriter(new FileWriter(new File(parentFolder, "dbSpeed.txt")));
                this.debugSpeedWriter.write("Table\tkey\tQuery time\tSerialization time\tDeserialization time\tsize\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent) {
            try {
                this.debugFolder = new File(aDbFolder);
                String tempFileName = "dbContent.txt";
                int counter = 1;
                while (new File(parentFolder, tempFileName).exists()) {
                    tempFileName = "dbContent" + counter++ + ".txt";
                }
                this.debugContentWriter = new BufferedWriter(new FileWriter(new File(parentFolder, tempFileName)));
                this.debugContentWriter.write("Table\tkey\tsize\n");
                this.debugContentWriter.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbMutex.release();
        this.logConnection();
        this.loadAttributes();
    }

    public String correctTableName(String tableName) {
        tableName = "\"" + tableName + "\"";
        if (this.longTableNames.contains(tableName)) {
            tableName = "\"" + this.longTableNames.indexOf(tableName) + "\"";
        } else if (tableName.length() >= 128) {
            int index = this.longTableNames.size();
            this.longTableNames.add(tableName);
            tableName = "\"" + index + "\"";
        }
        if (tableName.length() >= 128 && !tableName.startsWith(LONG_KEY_PREFIX)) {
            throw new IllegalArgumentException("Table name " + tableName + " is too long to be stored in the database.");
        }
        return tableName;
    }

    public String correctKey(String tableName, String key) {
        String correctedKey = key;
        if (this.longKeysMap != null && !correctedKey.startsWith(LONG_KEY_PREFIX)) {
            if (this.longKeysMap.containsKey(tableName) && this.longKeysMap.get(tableName).contains(key)) {
                correctedKey = LONG_KEY_PREFIX + this.longKeysMap.get(tableName).indexOf(key);
            } else if (key.length() >= 1000) {
                if (!this.longKeysMap.containsKey(tableName)) {
                    this.longKeysMap.put(tableName, new ArrayList());
                }
                int index = this.longKeysMap.get(tableName).size();
                this.longKeysMap.get(tableName).add(key);
                correctedKey = LONG_KEY_PREFIX + index;
            }
        }
        if (correctedKey.length() >= 1000 && !correctedKey.startsWith(LONG_KEY_PREFIX)) {
            throw new IllegalArgumentException("Object key " + correctedKey + " is too long to be stored in the database.");
        }
        return correctedKey;
    }

    public String getOriginalKey(String tableName, String correctedKey) {
        String subKey = correctedKey.substring(LONG_KEY_PREFIX.length());
        try {
            Integer index = new Integer(subKey);
            return this.longKeysMap.get(tableName).get(index);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occurred when getting the original key of " + correctedKey + ".");
        }
    }

    public String getPath() {
        return this.path;
    }

    public static void setDebugInteractions(boolean debug) {
        debugInteractions = debug;
    }
}

