/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.protein.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Protein
extends ExperimentObject {
    static final long serialVersionUID = 1987224639519365761L;
    private String accession;
    private boolean decoy;
    private String sequence;
    private Header.DatabaseType databaseType;

    public Protein() {
    }

    public Protein(String accession, boolean isDecoy) {
        this.accession = accession;
        this.decoy = isDecoy;
    }

    public Protein(String accession, String sequence, boolean isDecoy) {
        this.accession = accession;
        this.sequence = sequence;
        this.decoy = isDecoy;
    }

    public Protein(String accession, Header.DatabaseType databaseType, String sequence, boolean isDecoy) {
        this.accession = accession;
        this.databaseType = databaseType;
        this.sequence = sequence;
        this.decoy = isDecoy;
    }

    public boolean isDecoy() {
        return this.decoy;
    }

    public String getAccession() {
        return this.accession;
    }

    public Header.DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getSequence() {
        return this.sequence;
    }

    public boolean isSameAs(Protein anotherProtein) {
        return this.accession.equals(anotherProtein.getAccession());
    }

    public String getProteinKey() {
        return this.accession;
    }

    public int getLength() {
        return this.sequence.length();
    }

    public int[] getObservableAminoAcids(ArrayList<Enzyme> enzymes, double pepMaxLength) {
        int k;
        int lastCleavage = 0;
        int tempLength = 1;
        int[] observableAas = new int[this.sequence.length()];
        for (int i = 0; i < this.sequence.length() - 1; ++i) {
            boolean cleavage = false;
            char charati = this.sequence.charAt(i);
            char charatiPlusOne = this.sequence.charAt(i + 1);
            for (Enzyme enzyme : enzymes) {
                if (!enzyme.isCleavageSite(Character.valueOf(charati), Character.valueOf(charatiPlusOne))) continue;
                cleavage = true;
                break;
            }
            if (cleavage) {
                int k2;
                if ((double)tempLength <= pepMaxLength) {
                    for (k2 = lastCleavage; k2 < i; ++k2) {
                        observableAas[k2] = 1;
                    }
                } else {
                    for (k2 = lastCleavage; k2 < i; ++k2) {
                        observableAas[k2] = 0;
                    }
                }
                lastCleavage = i;
                tempLength = 0;
            }
            ++tempLength;
        }
        if ((double)tempLength <= pepMaxLength) {
            for (k = lastCleavage; k < this.sequence.length(); ++k) {
                observableAas[k] = 1;
            }
        } else {
            for (k = lastCleavage; k < this.sequence.length(); ++k) {
                observableAas[k] = 0;
            }
        }
        return observableAas;
    }

    public int getObservableLength(ArrayList<Enzyme> enzymes, double pepMaxLength) {
        int[] observalbeAas = this.getObservableAminoAcids(enzymes, pepMaxLength);
        int observableLength = 0;
        for (int observable : observalbeAas) {
            observableLength += observable;
        }
        return observableLength;
    }

    public int getNCleavageSites(ArrayList<Enzyme> enzymes) {
        int nCleavageSites = 0;
        block0: for (int i = 0; i < this.sequence.length() - 1; ++i) {
            char charati = this.sequence.charAt(i);
            char charatiPlusOne = this.sequence.charAt(i + 1);
            for (Enzyme enzyme : enzymes) {
                if (!enzyme.isCleavageSite(Character.valueOf(charati), Character.valueOf(charatiPlusOne))) continue;
                ++nCleavageSites;
                continue block0;
            }
        }
        return nCleavageSites;
    }

    public double computeMolecularWeight() {
        double mass = Atom.H.getMonoisotopicMass();
        for (int iaa = 0; iaa < this.sequence.length(); ++iaa) {
            char aa = this.sequence.charAt(iaa);
            try {
                if (aa == '*') continue;
                AminoAcid currentAA = AminoAcid.getAminoAcid(aa);
                mass += currentAA.getMonoisotopicMass();
                continue;
            }
            catch (NullPointerException e) {
                if (aa == '>') {
                    throw new IllegalArgumentException("Error parsing the sequence of " + this.accession);
                }
                throw new IllegalArgumentException("Unknown amino acid: " + aa);
            }
            catch (IllegalArgumentException e) {
                if (aa == '>') {
                    throw new IllegalArgumentException("Error parsing the sequence of " + this.accession + ". Protein sequence: " + this.sequence + ".");
                }
                throw new IllegalArgumentException("Unknown amino acid: " + aa);
            }
        }
        return mass += Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    }

    public ArrayList<Integer> getPeptideStart(String peptideSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        AminoAcidPattern aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString(peptideSequence);
        return aminoAcidPattern.getIndexes(this.sequence, sequenceMatchingPreferences);
    }

    public boolean isNTerm(String peptideSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        AminoAcidSequence aminoAcidPattern = new AminoAcidSequence(peptideSequence);
        String subSequence = this.sequence.substring(0, peptideSequence.length());
        if (aminoAcidPattern.matchesIn(subSequence, sequenceMatchingPreferences)) {
            return true;
        }
        return this.sequence.charAt(0) == 'M' && this.sequence.length() > peptideSequence.length() && aminoAcidPattern.matchesIn(subSequence = this.sequence.substring(1, peptideSequence.length() + 1), sequenceMatchingPreferences);
    }

    public boolean isCTerm(String peptideSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        String subSequence = this.sequence.length() <= peptideSequence.length() ? this.sequence : this.sequence.substring(this.sequence.length() - peptideSequence.length() - 1);
        AminoAcidSequence aminoAcidPattern = new AminoAcidSequence(peptideSequence);
        return aminoAcidPattern.matchesIn(subSequence, sequenceMatchingPreferences);
    }

    public boolean isEnzymaticPeptide(String peptideSequence, Enzyme enzyme, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException {
        HashMap<Integer, String[]> surroundingAminoAcids = this.getSurroundingAA(peptideSequence, 1, sequenceMatchingPreferences);
        String firstAA = peptideSequence.charAt(0) + "";
        String lastAA = peptideSequence.charAt(peptideSequence.length() - 1) + "";
        for (int index : surroundingAminoAcids.keySet()) {
            String before = surroundingAminoAcids.get(index)[0];
            String after = surroundingAminoAcids.get(index)[1];
            if (!(enzyme.isCleavageSite(before, firstAA) && enzyme.isCleavageSite(lastAA, after) || before.length() == 0 && enzyme.isCleavageSite(lastAA, after)) && (!enzyme.isCleavageSite(before, firstAA) || after.length() != 0)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnzymaticPeptide(String peptideSequence, ArrayList<Enzyme> enzymes, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException {
        for (Enzyme enzyme : enzymes) {
            if (!this.isEnzymaticPeptide(peptideSequence, enzyme, sequenceMatchingPreferences)) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, String[]> getSurroundingAA(String peptide, int nAA, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException {
        ArrayList<Integer> startIndexes = this.getPeptideStart(peptide, sequenceMatchingPreferences);
        HashMap<Integer, String[]> result = new HashMap<Integer, String[]>();
        for (int startIndex : startIndexes) {
            int aa;
            result.put(startIndex, new String[2]);
            String subsequence = "";
            int stringIndex = startIndex - 1;
            for (aa = stringIndex - nAA; aa < stringIndex; ++aa) {
                if (aa < 0 || aa >= this.sequence.length()) continue;
                subsequence = subsequence + this.sequence.charAt(aa);
            }
            result.get((Object)Integer.valueOf((int)startIndex))[0] = subsequence;
            subsequence = "";
            for (aa = stringIndex + peptide.length(); aa < stringIndex + peptide.length() + nAA; ++aa) {
                if (aa < 0 || aa >= this.sequence.length()) continue;
                subsequence = subsequence + this.sequence.charAt(aa);
            }
            result.get((Object)Integer.valueOf((int)startIndex))[1] = subsequence;
        }
        return result;
    }
}

