/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;

public class TideParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 1049197890002802776L;
    private String fastIndexFolderName = "fasta-index";
    private Integer maxVariablePtmsPerPeptide = null;
    private Integer maxVariablePtmsPerTypePerPeptide = 2;
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Double minPrecursorMass = 200.0;
    private Double maxPrecursorMass = 7200.0;
    private String decoyFormat = "none";
    private String keepTerminalAminoAcids = "NC";
    private Integer decoySeed = 1;
    private String outputFolderName = "crux-output";
    private Boolean printPeptides = false;
    private Integer verbosity = 30;
    private Boolean monoisotopicPrecursor = true;
    private Boolean clipNtermMethionine = false;
    private String digestionType = "full-digest";
    private Boolean computeSpScore = false;
    private Integer numberOfSpectrumMatches = 10;
    private Boolean computeExactPValues = false;
    private Double minSpectrumMz = 0.0;
    private Double maxSpectrumMz = null;
    private Integer minSpectrumPeaks = 20;
    private String spectrumCharges = "all";
    private Boolean removePrecursor = false;
    private Double removePrecursorTolerance = 1.5;
    private Integer printProgressIndicatorSize = 1000;
    private Boolean useFlankingPeaks = false;
    private Boolean useNeutralLossPeaks = false;
    private Double mzBinWidth = 0.02;
    private Double mzBinOffset = 0.0;
    private Boolean concatenateTargetDecoy = false;
    private String storeSpectraFileName = null;
    private Boolean textOutput = true;
    private Boolean sqtOutput = false;
    private Boolean pepXmlOutput = false;
    private Boolean mzidOutput = false;
    private Boolean pinOutput = false;
    private Boolean removeTempFolders = true;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.tide;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof TideParameters) {
            TideParameters tideParameters = (TideParameters)identificationAlgorithmParameter;
            if (!this.minPeptideLength.equals(tideParameters.getMinPeptideLength())) {
                return false;
            }
            if (!this.maxPeptideLength.equals(tideParameters.getMaxPeptideLength())) {
                return false;
            }
            double diff = Math.abs(this.minPrecursorMass - tideParameters.getMinPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPrecursorMass - tideParameters.getMaxPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.maxVariablePtmsPerPeptide != null && tideParameters.getMaxVariablePtmsPerPeptide() == null) {
                return false;
            }
            if (this.maxVariablePtmsPerPeptide == null && tideParameters.getMaxVariablePtmsPerPeptide() != null) {
                return false;
            }
            if (this.maxVariablePtmsPerPeptide != null && tideParameters.getMaxVariablePtmsPerPeptide() != null && this.maxVariablePtmsPerPeptide.intValue() != tideParameters.getMaxVariablePtmsPerPeptide().intValue()) {
                return false;
            }
            if (this.maxVariablePtmsPerTypePerPeptide != null && tideParameters.getMaxVariablePtmsPerTypePerPeptide() == null) {
                return false;
            }
            if (this.maxVariablePtmsPerTypePerPeptide == null && tideParameters.getMaxVariablePtmsPerTypePerPeptide() != null) {
                return false;
            }
            if (this.maxVariablePtmsPerTypePerPeptide != null && tideParameters.getMaxVariablePtmsPerTypePerPeptide() != null && !this.maxVariablePtmsPerTypePerPeptide.equals(tideParameters.getMaxVariablePtmsPerTypePerPeptide())) {
                return false;
            }
            if (!this.decoyFormat.equalsIgnoreCase(tideParameters.getDecoyFormat())) {
                return false;
            }
            if (!this.keepTerminalAminoAcids.equalsIgnoreCase(tideParameters.getKeepTerminalAminoAcids())) {
                return false;
            }
            if (!this.decoySeed.equals(tideParameters.getDecoySeed())) {
                return false;
            }
            if (!this.outputFolderName.equalsIgnoreCase(tideParameters.getOutputFolderName())) {
                return false;
            }
            if (!this.printPeptides.equals(tideParameters.getPrintPeptides())) {
                return false;
            }
            if (!this.verbosity.equals(tideParameters.getVerbosity())) {
                return false;
            }
            if (!this.monoisotopicPrecursor.equals(tideParameters.getMonoisotopicPrecursor())) {
                return false;
            }
            if (!this.clipNtermMethionine.equals(tideParameters.getClipNtermMethionine())) {
                return false;
            }
            if (!this.digestionType.equalsIgnoreCase(tideParameters.getDigestionType())) {
                return false;
            }
            if (!this.computeSpScore.equals(tideParameters.getComputeSpScore())) {
                return false;
            }
            if (!this.numberOfSpectrumMatches.equals(tideParameters.getNumberOfSpectrumMatches())) {
                return false;
            }
            if (!this.computeExactPValues.equals(tideParameters.getComputeExactPValues())) {
                return false;
            }
            if (!this.minSpectrumMz.equals(tideParameters.getMinSpectrumMz())) {
                return false;
            }
            if (this.maxSpectrumMz == null && tideParameters.getMaxSpectrumMz() != null || this.maxSpectrumMz != null && tideParameters.getMaxSpectrumMz() == null) {
                return false;
            }
            if (this.maxSpectrumMz != null && tideParameters.getMaxSpectrumMz() != null && !this.maxSpectrumMz.equals(tideParameters.getMaxSpectrumMz())) {
                return false;
            }
            if (!this.minSpectrumPeaks.equals(tideParameters.getMinSpectrumPeaks())) {
                return false;
            }
            if (!this.spectrumCharges.equalsIgnoreCase(tideParameters.getSpectrumCharges())) {
                return false;
            }
            if (!this.removePrecursor.equals(tideParameters.getRemovePrecursor())) {
                return false;
            }
            if (!this.removePrecursorTolerance.equals(tideParameters.getRemovePrecursorTolerance())) {
                return false;
            }
            if (!this.printProgressIndicatorSize.equals(tideParameters.getPrintProgressIndicatorSize())) {
                return false;
            }
            if (!this.useFlankingPeaks.equals(tideParameters.getUseFlankingPeaks())) {
                return false;
            }
            if (!this.useNeutralLossPeaks.equals(tideParameters.getUseNeutralLossPeaks())) {
                return false;
            }
            if (!this.mzBinWidth.equals(tideParameters.getMzBinWidth())) {
                return false;
            }
            if (!this.mzBinOffset.equals(tideParameters.getMzBinOffset())) {
                return false;
            }
            if (!this.concatenateTargetDecoy.equals(tideParameters.getConcatenatTargetDecoy())) {
                return false;
            }
            if (this.storeSpectraFileName == null && tideParameters.getStoreSpectraFileName() != null || this.storeSpectraFileName != null && tideParameters.getStoreSpectraFileName() == null) {
                return false;
            }
            if (this.storeSpectraFileName != null && tideParameters.getStoreSpectraFileName() != null && !this.storeSpectraFileName.equalsIgnoreCase(tideParameters.getStoreSpectraFileName())) {
                return false;
            }
            if (!this.textOutput.equals(tideParameters.getTextOutput())) {
                return false;
            }
            if (!this.sqtOutput.equals(tideParameters.getSqtOutput())) {
                return false;
            }
            if (!this.pepXmlOutput.equals(tideParameters.getPepXmlOutput())) {
                return false;
            }
            if (!this.mzidOutput.equals(tideParameters.getMzidOutput())) {
                return false;
            }
            if (!this.pinOutput.equals(tideParameters.getPinOutput())) {
                return false;
            }
            return this.getRemoveTempFolders().equals(tideParameters.getRemoveTempFolders());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("MIN_PRECURSOR_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("MAX_PRECURSOR_MASS=");
        output.append(this.maxPrecursorMass);
        output.append(newLine);
        output.append("MAX_VARIABLE_PTMS_PER_TYPE_PER_PEPTIDE=");
        output.append(this.maxVariablePtmsPerTypePerPeptide);
        output.append(newLine);
        output.append("MAX_VARIABLE_PTMS_PER_PEPTID=");
        output.append(this.maxVariablePtmsPerPeptide);
        output.append(newLine);
        output.append("DECOY_FORMAT=");
        output.append(this.decoyFormat);
        output.append(newLine);
        output.append("KEEP_TERMINAL_AMINO_ACIDS=");
        output.append(this.keepTerminalAminoAcids);
        output.append(newLine);
        output.append("DECOY_SEED=");
        output.append(this.decoySeed);
        output.append(newLine);
        output.append("OUTPUT_FOLDER_NAME=");
        output.append(this.outputFolderName);
        output.append(newLine);
        output.append("PRINT_PEPTIDES=");
        output.append(this.printPeptides);
        output.append(newLine);
        output.append("VERBOSITY=");
        output.append(this.verbosity);
        output.append(newLine);
        output.append("MONOISOTOPIC_PRECURSOR=");
        output.append(this.monoisotopicPrecursor);
        output.append(newLine);
        output.append("CLIP_NTERM_METHIONINE=");
        output.append(this.clipNtermMethionine);
        output.append(newLine);
        output.append("DIGESTION_TYPE=");
        output.append(this.digestionType);
        output.append(newLine);
        output.append("COMPUTE_SP_SCORE=");
        output.append(this.computeSpScore);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMatches);
        output.append(newLine);
        output.append("COMPUTE_EXACT_P_VALUES=");
        output.append(this.computeExactPValues);
        output.append(newLine);
        output.append("MIN_SPECTRUM_MZ=");
        output.append(this.minSpectrumMz);
        output.append(newLine);
        output.append("MAX_SPECTRUM_MZ=");
        output.append(this.maxSpectrumMz);
        output.append(newLine);
        output.append("MIN_SPECTRUM_PEAKS=");
        output.append(this.minSpectrumPeaks);
        output.append(newLine);
        output.append("SPECTRUM_CHARGES=");
        output.append(this.spectrumCharges);
        output.append(newLine);
        output.append("REMOVE_PRECURSOR=");
        output.append(this.removePrecursor);
        output.append(newLine);
        output.append("REMOVE_PRECURSOR_TOLERANCE=");
        output.append(this.removePrecursorTolerance);
        output.append(newLine);
        output.append("PRINT_PROGRESS_INDICATOR_SIZE=");
        output.append(this.printProgressIndicatorSize);
        output.append(newLine);
        output.append("USE_FLANKING_PEAKS=");
        output.append(this.useFlankingPeaks);
        output.append(newLine);
        output.append("USE_NEUTRAL_LOSS_PEAKS=");
        output.append(this.useNeutralLossPeaks);
        output.append(newLine);
        output.append("MZ_BIN_WIDTH=");
        output.append(this.mzBinWidth);
        output.append(newLine);
        output.append("MZ_BIN_OFFSET=");
        output.append(this.mzBinOffset);
        output.append(newLine);
        output.append("CONCATENATE_TARGET_DECOY=");
        output.append(this.concatenateTargetDecoy);
        output.append(newLine);
        output.append("STORE_SPECTRA_FILE_NAME=");
        output.append(this.storeSpectraFileName);
        output.append(newLine);
        output.append("TEXT_OUTPUT=");
        output.append(this.textOutput);
        output.append(newLine);
        output.append("SQT_OUTPUT=");
        output.append(this.sqtOutput);
        output.append(newLine);
        output.append("PEPXML_OUTPUT=");
        output.append(this.pepXmlOutput);
        output.append(newLine);
        output.append("MZID_OUTPUT=");
        output.append(this.mzidOutput);
        output.append(newLine);
        output.append("PERCOLATOR_OUTPUT=");
        output.append(this.pinOutput);
        output.append(newLine);
        return output.toString();
    }

    public Integer getMaxVariablePtmsPerPeptide() {
        return this.maxVariablePtmsPerPeptide;
    }

    public void setMaxVariablePtmsPerPeptide(Integer maxVariablePtmsPerPeptide) {
        this.maxVariablePtmsPerPeptide = maxVariablePtmsPerPeptide;
    }

    public Integer getMaxVariablePtmsPerTypePerPeptide() {
        return this.maxVariablePtmsPerTypePerPeptide;
    }

    public void setMaxVariablePtmsPerTypePerPeptide(Integer maxVariablePtmsPerTypePerPeptide) {
        this.maxVariablePtmsPerTypePerPeptide = maxVariablePtmsPerTypePerPeptide;
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(Double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public Double getMaxPrecursorMass() {
        return this.maxPrecursorMass;
    }

    public void setMaxPrecursorMass(Double maxPrecursorMass) {
        this.maxPrecursorMass = maxPrecursorMass;
    }

    public String getDecoyFormat() {
        return this.decoyFormat;
    }

    public void setDecoyFormat(String decoyFormat) {
        this.decoyFormat = decoyFormat;
    }

    public String getKeepTerminalAminoAcids() {
        return this.keepTerminalAminoAcids;
    }

    public void setKeepTerminalAminoAcids(String keepTerminalAminoAcids) {
        this.keepTerminalAminoAcids = keepTerminalAminoAcids;
    }

    public Integer getDecoySeed() {
        return this.decoySeed;
    }

    public void setDecoySeed(Integer decoySeed) {
        this.decoySeed = decoySeed;
    }

    public String getOutputFolderName() {
        return this.outputFolderName;
    }

    public void setOutputFolderName(String outputFolderName) {
        this.outputFolderName = outputFolderName;
    }

    public Boolean getPrintPeptides() {
        return this.printPeptides;
    }

    public void setPrintPeptides(Boolean printPeptides) {
        this.printPeptides = printPeptides;
    }

    public Integer getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Integer verbosity) {
        this.verbosity = verbosity;
    }

    public Boolean getMonoisotopicPrecursor() {
        return this.monoisotopicPrecursor;
    }

    public void setMonoisotopicPrecursor(Boolean monoisotopicPrecursor) {
        this.monoisotopicPrecursor = monoisotopicPrecursor;
    }

    public Boolean getClipNtermMethionine() {
        return this.clipNtermMethionine;
    }

    public void setClipNtermMethionine(Boolean clipNtermMethionine) {
        this.clipNtermMethionine = clipNtermMethionine;
    }

    public String getDigestionType() {
        return this.digestionType;
    }

    public void setDigestionType(String digestionType) {
        this.digestionType = digestionType;
    }

    public Boolean getComputeSpScore() {
        if (this.computeSpScore == null) {
            this.computeSpScore = false;
        }
        return this.computeSpScore;
    }

    public void setComputeSpScore(Boolean computeSpScore) {
        this.computeSpScore = computeSpScore;
    }

    public Integer getNumberOfSpectrumMatches() {
        return this.numberOfSpectrumMatches;
    }

    public void setNumberOfSpectrumMatches(Integer numberOfSpectrumMatches) {
        this.numberOfSpectrumMatches = numberOfSpectrumMatches;
    }

    public Boolean getComputeExactPValues() {
        return this.computeExactPValues;
    }

    public void setComputeExactPValues(Boolean computeExactPValues) {
        this.computeExactPValues = computeExactPValues;
    }

    public Double getMinSpectrumMz() {
        return this.minSpectrumMz;
    }

    public void setMinSpectrumMz(Double minSpectrumMz) {
        this.minSpectrumMz = minSpectrumMz;
    }

    public Double getMaxSpectrumMz() {
        return this.maxSpectrumMz;
    }

    public void setMaxSpectrumMz(Double maxSpectrumMz) {
        this.maxSpectrumMz = maxSpectrumMz;
    }

    public Integer getMinSpectrumPeaks() {
        return this.minSpectrumPeaks;
    }

    public void setMinSpectrumPeaks(Integer minSpectrumPeaks) {
        this.minSpectrumPeaks = minSpectrumPeaks;
    }

    public String getSpectrumCharges() {
        return this.spectrumCharges;
    }

    public void setSpectrumCharges(String spectrumCharges) {
        this.spectrumCharges = spectrumCharges;
    }

    public Boolean getRemovePrecursor() {
        return this.removePrecursor;
    }

    public void setRemovePrecursor(Boolean removePrecursor) {
        this.removePrecursor = removePrecursor;
    }

    public Double getRemovePrecursorTolerance() {
        return this.removePrecursorTolerance;
    }

    public void setRemovePrecursorTolerance(Double removePrecursorTolerance) {
        this.removePrecursorTolerance = removePrecursorTolerance;
    }

    public Integer getPrintProgressIndicatorSize() {
        return this.printProgressIndicatorSize;
    }

    public void setPrintProgressIndicatorSize(Integer printProgressIndicatorSize) {
        this.printProgressIndicatorSize = printProgressIndicatorSize;
    }

    public Boolean getUseFlankingPeaks() {
        return this.useFlankingPeaks;
    }

    public void setUseFlankingPeaks(Boolean useFlankingPeaks) {
        this.useFlankingPeaks = useFlankingPeaks;
    }

    public Boolean getUseNeutralLossPeaks() {
        return this.useNeutralLossPeaks;
    }

    public void setUseNeutralLossPeaks(Boolean useNeutralLossPeaks) {
        this.useNeutralLossPeaks = useNeutralLossPeaks;
    }

    public Double getMzBinWidth() {
        return this.mzBinWidth;
    }

    public void setMzBinWidth(Double mzBinWidth) {
        this.mzBinWidth = mzBinWidth;
    }

    public Double getMzBinOffset() {
        return this.mzBinOffset;
    }

    public void setMzBinOffset(Double mzBinOffset) {
        this.mzBinOffset = mzBinOffset;
    }

    public Boolean getConcatenatTargetDecoy() {
        return this.concatenateTargetDecoy;
    }

    public void setConcatenatTargetDecoy(Boolean concatenate) {
        this.concatenateTargetDecoy = concatenate;
    }

    public String getStoreSpectraFileName() {
        return this.storeSpectraFileName;
    }

    public void setStoreSpectraFileName(String storeSpectraFileName) {
        this.storeSpectraFileName = storeSpectraFileName;
    }

    public Boolean getTextOutput() {
        if (this.textOutput == null) {
            this.textOutput = true;
        }
        return this.textOutput;
    }

    public void setTextOutput(Boolean textOutput) {
        this.textOutput = textOutput;
    }

    public Boolean getSqtOutput() {
        if (this.sqtOutput == null) {
            this.sqtOutput = false;
        }
        return this.sqtOutput;
    }

    public void setSqtOutput(Boolean sqtOutput) {
        this.sqtOutput = sqtOutput;
    }

    public Boolean getPepXmlOutput() {
        if (this.pepXmlOutput == null) {
            this.pepXmlOutput = false;
        }
        return this.pepXmlOutput;
    }

    public void setPepXmlOutput(Boolean pepXmlOutput) {
        this.pepXmlOutput = pepXmlOutput;
    }

    public Boolean getMzidOutput() {
        if (this.mzidOutput == null) {
            this.mzidOutput = false;
        }
        return this.mzidOutput;
    }

    public void setMzidOutput(Boolean mzidOutput) {
        this.mzidOutput = mzidOutput;
    }

    public Boolean getPinOutput() {
        if (this.pinOutput == null) {
            this.pinOutput = false;
        }
        return this.pinOutput;
    }

    public void setPinOutput(Boolean pinOutput) {
        this.pinOutput = pinOutput;
    }

    public String getFastIndexFolderName() {
        return this.fastIndexFolderName;
    }

    public void setFastIndexFolderName(String fastIndexFolderName) {
        this.fastIndexFolderName = fastIndexFolderName;
    }

    public Boolean getRemoveTempFolders() {
        if (this.removeTempFolders == null) {
            this.removeTempFolders = true;
        }
        return this.removeTempFolders;
    }

    public void setRemoveTempFolders(Boolean removeTempFolders) {
        this.removeTempFolders = removeTempFolders;
    }
}

