/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import java.util.ArrayList;

public class PeptideMatch
extends IdentificationMatch {
    static final long serialVersionUID = 7195830246336841081L;
    private Peptide theoreticPeptide;
    private String matchKey;
    private ArrayList<String> spectrumMatchesKeys = new ArrayList();
    private Boolean isDecoy = null;

    public PeptideMatch() {
    }

    @Override
    public String getKey() {
        return this.matchKey;
    }

    public void setKey(String newKey) {
        this.matchKey = newKey;
    }

    public PeptideMatch(Peptide peptide, String matchKey) {
        this.theoreticPeptide = peptide;
        this.matchKey = matchKey;
    }

    public Peptide getTheoreticPeptide() {
        return this.theoreticPeptide;
    }

    public void setTheoreticPeptide(Peptide theoreticPeptide) {
        this.theoreticPeptide = theoreticPeptide;
    }

    public ArrayList<String> getSpectrumMatchesKeys() {
        return this.spectrumMatchesKeys;
    }

    public void addSpectrumMatchKey(String spectrumMatchKey) {
        if (this.spectrumMatchesKeys.contains(spectrumMatchKey)) {
            throw new IllegalArgumentException("Trying to add two times the same spectrum match (" + spectrumMatchKey + ") to the same peptide match (" + this.getKey() + ").");
        }
        this.spectrumMatchesKeys.add(spectrumMatchKey);
    }

    public int getSpectrumCount() {
        return this.spectrumMatchesKeys.size();
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Peptide;
    }
}

