/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences;

import com.compomics.util.experiment.biology.AminoAcid;
import org.apache.commons.math.util.FastMath;

public class AaOccurrence {
    private int[] uniqueAaOccurrence;
    private double[] uniqueAaShareLog;

    public AaOccurrence(int[] aaOccurrence) {
        int i;
        char[] uniqueAminoAcids = AminoAcid.getUniqueAminoAcids();
        int nUnique = AminoAcid.getNUnique();
        this.uniqueAaOccurrence = new int[nUnique];
        this.uniqueAaShareLog = new double[nUnique];
        int sumOccurrences = 0;
        for (i = 0; i < nUnique; ++i) {
            int occurrence;
            char aa = uniqueAminoAcids[i];
            int aaIndex = AminoAcid.getIndex(aa);
            this.uniqueAaOccurrence[i] = occurrence = aaOccurrence[aaIndex];
            if (occurrence == 0) {
                ++sumOccurrences;
                continue;
            }
            sumOccurrences += occurrence;
        }
        for (i = 0; i < nUnique; ++i) {
            int occurrence = this.uniqueAaOccurrence[i];
            this.uniqueAaShareLog[i] = -FastMath.log10((double)((double)Math.max(occurrence, 1) / (double)sumOccurrences));
        }
    }

    public double getP(char aa) {
        int uniqueIndex = AminoAcid.getUniqueIndex(aa);
        return this.uniqueAaShareLog[uniqueIndex];
    }

    public double getP(char[] aas, int startIndex, int endIndex, double pMax) {
        double p = 0.0;
        for (int i = startIndex; i < endIndex; ++i) {
            char aa = aas[i];
            if (!((p += this.getP(aa)) > pMax)) continue;
            return pMax;
        }
        return p;
    }
}

