/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.Distribution;
import com.compomics.util.math.statistics.distributions.NormalDistribution;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.MathException;

public class NonSymmetricalNormalDistribution
implements Distribution {
    static final long serialVersionUID = -5258258835569357886L;
    private double stdUp;
    private double stdDown;
    private double mean;
    private NormalDistribution distributionUp;
    private NormalDistribution distributionDown;

    public NonSymmetricalNormalDistribution(double mean, double stdDown, double stdUp) {
        this.mean = mean;
        this.stdDown = stdDown;
        this.stdUp = stdUp;
        this.distributionDown = new NormalDistribution(mean, stdDown);
        this.distributionUp = new NormalDistribution(mean, stdUp);
    }

    public double getStdUp() {
        return this.stdUp;
    }

    public double getStdDown() {
        return this.stdDown;
    }

    public double getMean() {
        return this.mean;
    }

    public static NonSymmetricalNormalDistribution getRobustNonSymmetricalNormalDistribution(ArrayList<Double> input) {
        ArrayList<Double> sortedInput = new ArrayList<Double>(input);
        Collections.sort(sortedInput);
        return NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistributionFromSortedList(sortedInput);
    }

    public static NonSymmetricalNormalDistribution getRobustNonSymmetricalNormalDistributionFromSortedList(ArrayList<Double> input) {
        double median = BasicMathFunctions.medianSorted(input);
        double percentileDown = BasicMathFunctions.percentileSorted(input, 0.159);
        double percentileUp = BasicMathFunctions.percentileSorted(input, 0.841);
        return new NonSymmetricalNormalDistribution(median, median - percentileDown, percentileUp - median);
    }

    @Override
    public Double getProbabilityAt(double x) {
        if (x >= this.mean) {
            return this.distributionUp.getProbabilityAt(x);
        }
        return this.distributionDown.getProbabilityAt(x);
    }

    @Override
    public Double getCumulativeProbabilityAt(double x) throws MathException {
        if (x >= this.mean) {
            return this.distributionUp.getCumulativeProbabilityAt(x);
        }
        return this.distributionDown.getCumulativeProbabilityAt(x);
    }

    @Override
    public Double getDescendingCumulativeProbabilityAt(double x) throws MathException {
        if (x > this.mean) {
            return this.distributionUp.getDescendingCumulativeProbabilityAt(x);
        }
        return this.distributionDown.getDescendingCumulativeProbabilityAt(x);
    }

    @Override
    public Double getSmallestCumulativeProbabilityAt(double x) throws MathException {
        if (x > this.mean) {
            return this.getDescendingCumulativeProbabilityAt(x);
        }
        this.getCumulativeProbabilityAt(x);
        return 0.5;
    }

    @Override
    public Double getMaxValueForProbability(double p) {
        return this.distributionUp.getMaxValueForProbability(p);
    }

    @Override
    public Double getMinValueForProbability(double p) {
        return this.distributionDown.getMinValueForProbability(p);
    }

    @Override
    public Double getValueAtCumulativeProbability(double p) throws MathException {
        if (p < 0.5) {
            return this.distributionDown.getValueAtCumulativeProbability(p);
        }
        return this.distributionUp.getValueAtCumulativeProbability(p);
    }

    @Override
    public Double getValueAtDescendingCumulativeProbability(double p) throws MathException {
        if (p < 0.5) {
            return this.distributionUp.getValueAtDescendingCumulativeProbability(p);
        }
        return this.distributionDown.getValueAtDescendingCumulativeProbability(p);
    }
}

