/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.identification.ptm.PtmScore;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.Serializable;

public class PTMScoringPreferences
implements Serializable {
    static final long serialVersionUID = -6656074270981104708L;
    private double flr = 1.0;
    private Boolean probabilitsticScoreCalculation = true;
    private PtmScore selectedProbabilisticScore = PtmScore.PhosphoRS;
    private boolean estimateFlr = false;
    private double probabilisticScoreThreshold = 95.0;
    private Boolean probabilisticScoreNeutralLosses = false;
    private SequenceMatchingPreferences sequenceMatchingPreferences = new SequenceMatchingPreferences();
    private Boolean alignNonConfidentPTMs = true;

    public PTMScoringPreferences() {
        this.sequenceMatchingPreferences.setSequenceMatchingType(SequenceMatchingPreferences.MatchingType.aminoAcid);
    }

    public Boolean isProbabilitsticScoreCalculation() {
        return this.probabilitsticScoreCalculation;
    }

    public void setProbabilitsticScoreCalculation(boolean probabilitsticScoreCalculation) {
        this.probabilitsticScoreCalculation = probabilitsticScoreCalculation;
    }

    public PtmScore getSelectedProbabilisticScore() {
        if (this.selectedProbabilisticScore == null) {
            return PtmScore.AScore;
        }
        return this.selectedProbabilisticScore;
    }

    public void setSelectedProbabilisticScore(PtmScore selectedProbabilisticScore) {
        this.selectedProbabilisticScore = selectedProbabilisticScore;
    }

    public boolean isEstimateFlr() {
        return this.estimateFlr;
    }

    public void setEstimateFlr(boolean estimateFlr) {
        this.estimateFlr = estimateFlr;
    }

    public double getProbabilisticScoreThreshold() {
        return this.probabilisticScoreThreshold;
    }

    public void setProbabilisticScoreThreshold(double probabilisticScoreThreshold) {
        this.probabilisticScoreThreshold = probabilisticScoreThreshold;
    }

    public Boolean isProbabilisticScoreNeutralLosses() {
        return this.probabilisticScoreNeutralLosses;
    }

    public void setProbabilisticScoreNeutralLosses(boolean probabilisticScoreNeutralLosses) {
        this.probabilisticScoreNeutralLosses = probabilisticScoreNeutralLosses;
    }

    public SequenceMatchingPreferences getSequenceMatchingPreferences() {
        if (this.sequenceMatchingPreferences == null) {
            this.sequenceMatchingPreferences = new SequenceMatchingPreferences();
            this.sequenceMatchingPreferences.setSequenceMatchingType(SequenceMatchingPreferences.MatchingType.aminoAcid);
        }
        return this.sequenceMatchingPreferences;
    }

    public void setSequenceMatchingPreferences(SequenceMatchingPreferences sequenceMatchingPreferences) {
        this.sequenceMatchingPreferences = sequenceMatchingPreferences;
    }

    public double getFlrThreshold() {
        return this.flr;
    }

    public void setFlrThreshold(double flr) {
        this.flr = flr;
    }

    public Boolean getAlignNonConfidentPTMs() {
        if (this.alignNonConfidentPTMs == null) {
            this.alignNonConfidentPTMs = true;
        }
        return this.alignNonConfidentPTMs;
    }

    public void setAlignNonConfidentPTMs(Boolean alignNonConfidentPTMs) {
        this.alignNonConfidentPTMs = alignNonConfidentPTMs;
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Score: ").append((Object)this.selectedProbabilisticScore).append(".").append(newLine);
        output.append("Include Neutral Losses: ").append(this.probabilisticScoreNeutralLosses).append(".").append(newLine);
        output.append("Threshold Auto: ").append(this.estimateFlr).append(".").append(newLine);
        output.append("Threshold: ").append(this.probabilisticScoreThreshold).append(".").append(newLine);
        output.append("Align PTMs: ").append(this.getAlignNonConfidentPTMs()).append(".").append(newLine);
        return output.toString();
    }

    public boolean equals(PTMScoringPreferences otherPtmScoringPreferences) {
        if (otherPtmScoringPreferences == null) {
            return false;
        }
        double diff = Math.abs(this.flr - otherPtmScoringPreferences.getFlrThreshold());
        if (diff > Double.MIN_VALUE) {
            return false;
        }
        if (this.probabilitsticScoreCalculation.booleanValue() != otherPtmScoringPreferences.isProbabilitsticScoreCalculation().booleanValue()) {
            return false;
        }
        if (this.selectedProbabilisticScore != otherPtmScoringPreferences.getSelectedProbabilisticScore()) {
            return false;
        }
        if (this.estimateFlr != otherPtmScoringPreferences.isEstimateFlr()) {
            return false;
        }
        diff = Math.abs(this.probabilisticScoreThreshold - otherPtmScoringPreferences.getProbabilisticScoreThreshold());
        if (diff > Double.MIN_VALUE) {
            return false;
        }
        if (this.probabilisticScoreNeutralLosses.booleanValue() != otherPtmScoringPreferences.isProbabilisticScoreNeutralLosses().booleanValue()) {
            return false;
        }
        if (this.getAlignNonConfidentPTMs() == false == otherPtmScoringPreferences.getAlignNonConfidentPTMs()) {
            return false;
        }
        return this.sequenceMatchingPreferences.isSameAs(otherPtmScoringPreferences.getSequenceMatchingPreferences());
    }
}

