/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.filtering.Filter;
import java.io.Serializable;
import java.util.ArrayList;

public class ValidationQCPreferences
implements Serializable {
    static final long serialVersionUID = -3984640691136489708L;
    private boolean dbSize = false;
    private boolean firstDecoy = true;
    private Double confidenceMargin = 1.0;
    private ArrayList<Filter> psmFilters;
    private ArrayList<Filter> peptideFilters;
    private ArrayList<Filter> proteinFilters;

    public ValidationQCPreferences() {
    }

    public ValidationQCPreferences(ValidationQCPreferences validationQCPreferences) {
        this.dbSize = validationQCPreferences.isDbSize();
        this.firstDecoy = validationQCPreferences.isFirstDecoy();
        this.confidenceMargin = validationQCPreferences.getConfidenceMargin();
        if (validationQCPreferences.getPsmFilters() != null) {
            this.psmFilters = new ArrayList(validationQCPreferences.getPsmFilters().size());
            for (Filter filter : validationQCPreferences.getPsmFilters()) {
                this.psmFilters.add(filter.clone());
            }
        }
        if (validationQCPreferences.getPeptideFilters() != null) {
            this.peptideFilters = new ArrayList(validationQCPreferences.getPeptideFilters().size());
            for (Filter filter : validationQCPreferences.getPeptideFilters()) {
                this.peptideFilters.add(filter.clone());
            }
        }
        if (validationQCPreferences.getProteinFilters() != null) {
            this.proteinFilters = new ArrayList(validationQCPreferences.getProteinFilters().size());
            for (Filter filter : validationQCPreferences.getProteinFilters()) {
                this.proteinFilters.add(filter.clone());
            }
        }
    }

    public boolean isDbSize() {
        return this.dbSize;
    }

    public void setDbSize(boolean dbSize) {
        this.dbSize = dbSize;
    }

    public boolean isFirstDecoy() {
        return this.firstDecoy;
    }

    public void setFirstDecoy(boolean firstDecoy) {
        this.firstDecoy = firstDecoy;
    }

    public Double getConfidenceMargin() {
        return this.confidenceMargin;
    }

    public void setConfidenceMargin(Double confidenceMargin) {
        this.confidenceMargin = confidenceMargin;
    }

    public ArrayList<Filter> getPsmFilters() {
        return this.psmFilters;
    }

    public void setPsmFilters(ArrayList<Filter> psmFilters) {
        this.psmFilters = psmFilters;
    }

    public ArrayList<Filter> getPeptideFilters() {
        return this.peptideFilters;
    }

    public void setPeptideFilters(ArrayList<Filter> peptideFilters) {
        this.peptideFilters = peptideFilters;
    }

    public ArrayList<Filter> getProteinFilters() {
        return this.proteinFilters;
    }

    public void setProteinFilters(ArrayList<Filter> proteinFilters) {
        this.proteinFilters = proteinFilters;
    }

    public boolean isSameAs(ValidationQCPreferences validationQCPreferences) {
        boolean found;
        if (this.dbSize != validationQCPreferences.isDbSize()) {
            return false;
        }
        if (this.firstDecoy != validationQCPreferences.isFirstDecoy()) {
            return false;
        }
        if (!this.getConfidenceMargin().equals(validationQCPreferences.getConfidenceMargin())) {
            return false;
        }
        if (this.psmFilters != null && validationQCPreferences.getPsmFilters() == null || this.psmFilters == null && validationQCPreferences.getPsmFilters() != null) {
            return false;
        }
        if (this.psmFilters != null && validationQCPreferences.getPsmFilters() != null && this.psmFilters.size() != validationQCPreferences.getPsmFilters().size()) {
            return false;
        }
        if (this.peptideFilters != null && validationQCPreferences.getPeptideFilters() == null || this.peptideFilters == null && validationQCPreferences.getPeptideFilters() != null) {
            return false;
        }
        if (this.peptideFilters != null && validationQCPreferences.getPeptideFilters() != null && this.peptideFilters.size() != validationQCPreferences.getPeptideFilters().size()) {
            return false;
        }
        if (this.proteinFilters != null && validationQCPreferences.getProteinFilters() == null || this.proteinFilters == null && validationQCPreferences.getProteinFilters() != null) {
            return false;
        }
        if (this.proteinFilters != null && validationQCPreferences.getProteinFilters() != null && this.proteinFilters.size() != validationQCPreferences.getProteinFilters().size()) {
            return false;
        }
        if (this.psmFilters != null) {
            for (Filter psmFilter : this.psmFilters) {
                found = false;
                for (Filter newFilter : validationQCPreferences.getPsmFilters()) {
                    if (!newFilter.isSameAs(psmFilter)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        if (this.peptideFilters != null) {
            for (Filter psmFilter : this.peptideFilters) {
                found = false;
                for (Filter newFilter : validationQCPreferences.getPeptideFilters()) {
                    if (!newFilter.isSameAs(psmFilter)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        if (this.proteinFilters != null) {
            for (Filter psmFilter : this.proteinFilters) {
                found = false;
                for (Filter newFilter : validationQCPreferences.getProteinFilters()) {
                    if (!newFilter.isSameAs(psmFilter)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public String getShortDescription() {
        String tempProteinFilters;
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("DB Size Check: ").append(this.dbSize).append(".").append(newLine);
        output.append("First Target Check: ").append(this.firstDecoy).append(".").append(newLine);
        output.append("Confidence Check: ").append(this.confidenceMargin != 0.0).append(".").append(newLine);
        if (this.proteinFilters != null && !this.proteinFilters.isEmpty()) {
            output.append("Protein Filters: ").append(newLine);
            tempProteinFilters = "";
            for (Filter tempFilter : this.proteinFilters) {
                if (!tempProteinFilters.isEmpty()) {
                    tempProteinFilters = tempProteinFilters + ", ";
                }
                tempProteinFilters = tempProteinFilters + tempFilter.getName();
            }
            output.append(tempProteinFilters).append(".").append(newLine);
        }
        if (this.peptideFilters != null && !this.peptideFilters.isEmpty()) {
            output.append("Peptide Filters: ").append(newLine);
            tempProteinFilters = "";
            for (Filter tempFilter : this.peptideFilters) {
                if (!tempProteinFilters.isEmpty()) {
                    tempProteinFilters = tempProteinFilters + ", ";
                }
                tempProteinFilters = tempProteinFilters + tempFilter.getName();
            }
            output.append(tempProteinFilters).append(".").append(newLine);
        }
        if (this.psmFilters != null && !this.psmFilters.isEmpty()) {
            output.append("PSM Filters: ").append(newLine);
            tempProteinFilters = "";
            for (Filter tempFilter : this.psmFilters) {
                if (!tempProteinFilters.isEmpty()) {
                    tempProteinFilters = tempProteinFilters + ", ";
                }
                tempProteinFilters = tempProteinFilters + tempFilter.getName();
            }
            output.append(tempProteinFilters).append(".").append(newLine);
        }
        return output.toString();
    }
}

