/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.ArrayC128;
import org.ojalgo.array.ArrayH256;
import org.ojalgo.array.ArrayQ128;
import org.ojalgo.array.ArrayR032;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.ArrayR128;
import org.ojalgo.array.ArrayR256;
import org.ojalgo.array.ArrayZ008;
import org.ojalgo.array.ArrayZ016;
import org.ojalgo.array.ArrayZ032;
import org.ojalgo.array.ArrayZ064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BufferArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Transformation1D;
import org.ojalgo.tensor.TensorFactory1D;
import org.ojalgo.type.math.MathType;

public final class Array1D<N extends Comparable<N>>
extends AbstractList<N>
implements Access1D.Visitable<N>,
Access1D.Aggregatable<N>,
Access1D.Sliceable<N>,
Access1D.Collectable<N, Mutate1D>,
Mutate1D.ModifiableReceiver<N>,
Mutate1D.Mixable<N>,
Mutate1D.Sortable,
RandomAccess {
    public static final Factory<ComplexNumber> C128 = Array1D.factory(ArrayC128.FACTORY);
    public static final Factory<Quaternion> H256 = Array1D.factory(ArrayH256.FACTORY);
    public static final Factory<RationalNumber> Q128 = Array1D.factory(ArrayQ128.FACTORY);
    public static final Factory<Double> R032 = Array1D.factory(ArrayR032.FACTORY);
    public static final Factory<Double> R064 = Array1D.factory(ArrayR064.FACTORY);
    public static final Factory<Quadruple> R128 = Array1D.factory(ArrayR128.FACTORY);
    public static final Factory<BigDecimal> R256 = Array1D.factory(ArrayR256.FACTORY);
    public static final Factory<Double> Z008 = Array1D.factory(ArrayZ008.FACTORY);
    public static final Factory<Double> Z016 = Array1D.factory(ArrayZ016.FACTORY);
    public static final Factory<Double> Z032 = Array1D.factory(ArrayZ032.FACTORY);
    public static final Factory<Double> Z064 = Array1D.factory(ArrayZ064.FACTORY);
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;
    @Deprecated
    public static final Factory<BigDecimal> BIG = R256;
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    @Deprecated
    public static final Factory<Double> DIRECT32 = Array1D.factory(BufferArray.DIRECT32);
    @Deprecated
    public static final Factory<Double> DIRECT64 = Array1D.factory(BufferArray.DIRECT64);
    @Deprecated
    public static final Factory<Double> PRIMITIVE32 = R032;
    @Deprecated
    public static final Factory<Double> PRIMITIVE64 = R064;
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    public final long length;
    private final BasicArray<N> myDelegate;
    private final long myFirst;
    private final long myLimit;
    private final long myStep;

    public static <N extends Comparable<N>> Factory<N> factory(DenseArray.Factory<N> denseFactory) {
        return new Factory<N>(denseFactory);
    }

    Array1D(BasicArray<N> delegate) {
        this(delegate, 0L, delegate.count(), 1L);
    }

    Array1D(BasicArray<N> delegate, long first, long limit, long step) {
        this.myDelegate = delegate;
        this.myFirst = first;
        this.myLimit = limit;
        this.myStep = step;
        this.length = (this.myLimit - this.myFirst) / this.myStep;
    }

    @Override
    public void add(long index, byte addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public void add(long index, double addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public void add(long index, float addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public void add(long index, int addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public void add(long index, long addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public void add(long index, short addend) {
        this.myDelegate.add(this.convert(index), addend);
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRange(first, limit, visitor);
        return (N)((Comparable)visitor.get());
    }

    @Override
    public byte byteValue(long index) {
        return this.myDelegate.byteValue(this.convert(index));
    }

    @Override
    public void clear() {
        this.myDelegate.reset();
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    @Override
    public long count() {
        return this.length;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(this.convert(index));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof Array1D)) {
            return false;
        }
        Array1D other = (Array1D)obj;
        if (this.length != other.length || this.myFirst != other.myFirst || this.myLimit != other.myLimit || this.myStep != other.myStep) {
            return false;
        }
        return !(this.myDelegate == null ? other.myDelegate != null : !this.myDelegate.equals(other.myDelegate));
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(this.myFirst, this.myLimit, this.myStep, value);
    }

    @Override
    public void fillAll(NullaryFunction<?> supplier) {
        this.myDelegate.fill(this.myFirst, this.myLimit, this.myStep, supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(this.convert(index), values, valueIndex);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myDelegate.fillOne(this.convert(index), value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<?> supplier) {
        this.myDelegate.fillOne(this.convert(index), supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.myDelegate.fill(this.convert(first), this.convert(limit), this.myStep, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<?> supplier) {
        this.myDelegate.fill(this.convert(first), this.convert(limit), this.myStep, supplier);
    }

    @Override
    public float floatValue(long index) {
        return this.myDelegate.floatValue(this.convert(index));
    }

    @Override
    public N get(int index) {
        return this.myDelegate.get(this.convert(index));
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(this.convert(index));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (int)(this.length ^ this.length >>> 32);
        result = prime * result + (this.myDelegate == null ? 0 : this.myDelegate.hashCode());
        result = prime * result + (int)(this.myFirst ^ this.myFirst >>> 32);
        result = prime * result + (int)(this.myLimit ^ this.myLimit >>> 32);
        return prime * result + (int)(this.myStep ^ this.myStep >>> 32);
    }

    @Override
    public int indexOf(Object obj) {
        block3: {
            int tmpLength;
            block2: {
                tmpLength = this.size();
                if (obj != null) break block2;
                for (int i = 0; i < tmpLength; ++i) {
                    if (this.get(i) != null) continue;
                    return i;
                }
                break block3;
            }
            if (!(obj instanceof Comparable)) break block3;
            for (int i = 0; i < tmpLength; ++i) {
                if (!obj.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public long indexOfLargest() {
        long first = this.convert(this.myFirst);
        long limit = this.convert(this.myLimit);
        long step = this.myStep;
        return (this.myDelegate.indexOfLargest(first, limit, step) - first) / step;
    }

    @Override
    public int intValue(long index) {
        return this.myDelegate.intValue(this.convert(index));
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    @Override
    public long longValue(long index) {
        return this.myDelegate.longValue(this.convert(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long index, BinaryFunction<N> mixer, double addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            double oldValue = this.doubleValue(index);
            double newValue = mixer.invoke(oldValue, addend);
            this.set(index, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long index, BinaryFunction<N> mixer, N addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            N oldValue = this.get(index);
            N newValue = mixer.invoke(oldValue, addend);
            this.set(index, (Comparable<?>)newValue);
            return newValue;
        }
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.myDelegate.modify(this.myFirst, this.myLimit, this.myStep, modifier);
    }

    @Override
    public void modifyAny(Transformation1D<N> modifier) {
        modifier.transform(this);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        long limit = Math.min(this.length, left.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Comparable<?>)function.invoke(left.get(i), this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        long limit = Math.min(this.length, right.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Comparable<?>)function.invoke(this.get(i), right.get(i)));
            }
        }
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(this.convert(index), modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        this.myDelegate.modify(this.convert(first), this.convert(limit), this.myStep, modifier);
    }

    @Override
    public void reset() {
        this.myDelegate.reset();
    }

    @Override
    public N set(int index, N value) {
        long tmpIndex = this.convert(index);
        Object retVal = this.myDelegate.get(tmpIndex);
        this.myDelegate.set(tmpIndex, (Comparable<?>)value);
        return retVal;
    }

    @Override
    public void set(long index, byte value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public void set(long index, float value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public void set(long index, int value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public void set(long index, long value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public void set(long index, short value) {
        this.myDelegate.set(this.convert(index), value);
    }

    @Override
    public short shortValue(long index) {
        return this.myDelegate.shortValue(this.convert(index));
    }

    @Override
    public int size() {
        return Math.toIntExact(this.length);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return new Array1D<N>(this.myDelegate, this.convert(first), this.convert(limit), this.myStep);
    }

    @Override
    public void sortAscending() {
        if (this.myDelegate instanceof Mutate1D.Sortable && this.count() == this.myDelegate.count()) {
            ((Mutate1D.Sortable)((Object)this.myDelegate)).sortAscending();
        } else {
            try {
                ForkJoinPool.commonPool().submit(new QuickAscendingSorter(this)).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void sortDescending() {
        if (this.myDelegate instanceof Mutate1D.Sortable && this.count() == this.myDelegate.count()) {
            ((Mutate1D.Sortable)((Object)this.myDelegate)).sortDescending();
        } else {
            try {
                ForkJoinPool.commonPool().submit(new QuickDescendingSorter(this)).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public Array1D<N> subList(int first, int limit) {
        return this.sliceRange(first, limit);
    }

    @Override
    public void supplyTo(Mutate1D receiver) {
        long limit = Math.min(this.length, receiver.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, this.doubleValue(i));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.get(i));
            }
        }
    }

    @Override
    public String toString() {
        return Access1D.toString(this);
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(this.myFirst, this.myLimit, this.myStep, visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(this.convert(index), visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.myDelegate.visit(this.convert(first), this.convert(limit), this.myStep, visitor);
    }

    private long convert(long index) {
        return this.myFirst + this.myStep * index;
    }

    void exchange(long indexA, long indexB) {
        if (this.myDelegate.isPrimitive()) {
            double tmpVal = this.doubleValue(indexA);
            this.set(indexA, this.doubleValue(indexB));
            this.set(indexB, tmpVal);
        } else {
            N tmpVal = this.get(indexA);
            this.set(indexA, (Comparable<?>)this.get(indexB));
            this.set(indexB, (Comparable<?>)tmpVal);
        }
    }

    BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    void sortAscending(long low, long high) {
        long i = low;
        long j = high;
        double pivot = this.doubleValue(low + (high - low) / 2L);
        while (i <= j) {
            while (this.doubleValue(i) < pivot) {
                ++i;
            }
            while (this.doubleValue(j) > pivot) {
                --j;
            }
            if (i > j) continue;
            this.exchange(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.sortAscending(low, j);
        }
        if (i < high) {
            this.sortAscending(i, high);
        }
    }

    void sortDescending(long low, long high) {
        long i = low;
        long j = high;
        double pivot = this.doubleValue(low + (high - low) / 2L);
        while (i <= j) {
            while (this.doubleValue(i) > pivot) {
                ++i;
            }
            while (this.doubleValue(j) < pivot) {
                --j;
            }
            if (i > j) continue;
            this.exchange(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.sortDescending(low, j);
        }
        if (i < high) {
            this.sortDescending(i, high);
        }
    }

    static final class QuickDescendingSorter
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long high;
        private final long low;
        private final Array1D<?> myArray;

        private QuickDescendingSorter(Array1D<?> array, long low, long high) {
            this.myArray = array;
            this.low = low;
            this.high = high;
        }

        QuickDescendingSorter(Array1D<?> array) {
            this(array, 0L, array.count() - 1L);
        }

        @Override
        protected void compute() {
            long i = this.low;
            long j = this.high;
            double pivot = this.myArray.doubleValue(this.low + (this.high - this.low) / 2L);
            while (i <= j) {
                while (this.myArray.doubleValue(i) > pivot) {
                    ++i;
                }
                while (this.myArray.doubleValue(j) < pivot) {
                    --j;
                }
                if (i > j) continue;
                this.myArray.exchange(i, j);
                ++i;
                --j;
            }
            QuickDescendingSorter tmpPartL = null;
            ForkJoinTask tmpPartH = null;
            if (this.low < j) {
                tmpPartL = new QuickDescendingSorter(this.myArray, this.low, j);
                tmpPartL.fork();
            }
            if (i < this.high) {
                tmpPartH = new QuickDescendingSorter(this.myArray, i, this.high);
                tmpPartH.fork();
            }
            if (tmpPartL != null) {
                tmpPartL.join();
            }
            if (tmpPartH != null) {
                tmpPartH.join();
            }
        }
    }

    static final class QuickAscendingSorter
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long high;
        private final long low;
        private final Array1D<?> myArray;

        private QuickAscendingSorter(Array1D<?> array, long low, long high) {
            this.myArray = array;
            this.low = low;
            this.high = high;
        }

        QuickAscendingSorter(Array1D<?> array) {
            this(array, 0L, array.count() - 1L);
        }

        @Override
        protected void compute() {
            long i = this.low;
            long j = this.high;
            double pivot = this.myArray.doubleValue(this.low + (this.high - this.low) / 2L);
            while (i <= j) {
                while (this.myArray.doubleValue(i) < pivot) {
                    ++i;
                }
                while (this.myArray.doubleValue(j) > pivot) {
                    --j;
                }
                if (i > j) continue;
                this.myArray.exchange(i, j);
                ++i;
                --j;
            }
            QuickAscendingSorter tmpPartL = null;
            ForkJoinTask tmpPartH = null;
            if (this.low < j) {
                tmpPartL = new QuickAscendingSorter(this.myArray, this.low, j);
                tmpPartL.fork();
            }
            if (i < this.high) {
                tmpPartH = new QuickAscendingSorter(this.myArray, i, this.high);
                tmpPartH.fork();
            }
            if (tmpPartL != null) {
                tmpPartL.join();
            }
            if (tmpPartH != null) {
                tmpPartH.join();
            }
        }
    }

    public static final class Factory<N extends Comparable<N>>
    implements Factory1D.Dense<Array1D<N>>,
    Factory1D.MayBeSparse<Array1D<N>, Array1D<N>, Array1D<N>> {
        private final BasicArray.Factory<N> myDelegate;

        Factory(DenseArray.Factory<N> denseArray) {
            this.myDelegate = new BasicArray.Factory<N>(denseArray);
        }

        @Override
        public Array1D<N> copy(Access1D<?> source) {
            return this.myDelegate.copy((Access1D)source).wrapInArray1D();
        }

        @Override
        public Array1D<N> copy(Comparable<?>[] source) {
            return this.myDelegate.copy((Comparable[])source).wrapInArray1D();
        }

        @Override
        public Array1D<N> copy(double ... source) {
            return this.myDelegate.copy(source).wrapInArray1D();
        }

        @Override
        public Array1D<N> copy(List<? extends Comparable<?>> source) {
            return this.myDelegate.copy(source).wrapInArray1D();
        }

        public FunctionSet<N> function() {
            return this.myDelegate.function();
        }

        @Override
        public Array1D<N> make(long count) {
            return this.makeDense(count);
        }

        @Override
        public Array1D<N> makeDense(long count) {
            return this.myDelegate.makeToBeFilled(count).wrapInArray1D();
        }

        @Override
        public Array1D<N> makeFilled(long count, NullaryFunction<?> supplier) {
            return this.myDelegate.makeFilled(count, (NullaryFunction)supplier).wrapInArray1D();
        }

        @Override
        public Array1D<N> makeSparse(long count) {
            return this.myDelegate.makeStructuredZero(count).wrapInArray1D();
        }

        public Scalar.Factory<N> scalar() {
            return this.myDelegate.scalar();
        }

        public TensorFactory1D<N, Array1D<N>> tensor() {
            return TensorFactory1D.of(this);
        }

        public Array1D<N> wrap(BasicArray<N> array) {
            return array.wrapInArray1D();
        }

        @Override
        public MathType getMathType() {
            return this.myDelegate.getMathType();
        }
    }
}

