/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.GrowthStrategy;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.math.MathType;

public abstract class StrategyBuildingFactory<N extends Comparable<N>, I extends Access1D<N>, SB extends StrategyBuildingFactory<N, I, SB>> {
    private final DenseArray.Factory<N> myDenseFactory;
    private final GrowthStrategy.Builder myStrategyBuilder;

    public StrategyBuildingFactory(DenseArray.Factory<N> denseFactory) {
        this.myDenseFactory = denseFactory;
        this.myStrategyBuilder = GrowthStrategy.newBuilder(denseFactory);
    }

    public SB chunk(long chunk) {
        this.myStrategyBuilder.chunk(chunk);
        return (SB)this;
    }

    @Deprecated
    public SB fixed(long fixed) {
        return ((StrategyBuildingFactory)this.initial(fixed)).limit(fixed);
    }

    public FunctionSet<N> function() {
        return this.myDenseFactory.function();
    }

    public MathType getMathType() {
        return this.myDenseFactory.getMathType();
    }

    public SB initial(long initial) {
        this.myStrategyBuilder.initial(initial);
        return (SB)this;
    }

    @Deprecated
    public SB limit(long limit) {
        return (SB)this;
    }

    public Scalar.Factory<N> scalar() {
        return this.myDenseFactory.scalar();
    }

    public SB segment(long segment) {
        this.myStrategyBuilder.segment(segment);
        return (SB)this;
    }

    DenseArray.Factory<N> getDenseFactory() {
        return this.myDenseFactory;
    }

    GrowthStrategy getGrowthStrategy() {
        return this.myStrategyBuilder.build();
    }
}

