/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.structure.Structure2D;

public abstract class FillMatchingDual
implements ArrayOperation {
    public static int THRESHOLD = 256;

    public static void fillAll(double[][] target, double value) {
        int limit = target.length;
        for (int i = 0; i < limit; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = value;
            }
        }
    }

    public static void fillAll(double[][] target, DoubleSupplier supplier) {
        int limit = target.length;
        for (int i = 0; i < limit; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = supplier.getAsDouble();
            }
        }
    }

    public static void fillColumn(double[][] target, int row, int col, double value) {
        int limit = target.length;
        for (int i = row; i < limit; ++i) {
            target[i][col] = value;
        }
    }

    public static void fillColumn(double[][] target, int row, int col, DoubleSupplier supplier) {
        int limit = target.length;
        for (int i = row; i < limit; ++i) {
            target[i][col] = supplier.getAsDouble();
        }
    }

    public static void fillDiagonal(double[][] target, int row, int col, double value) {
        int limit = target.length;
        int ij = 0;
        while (row + ij < limit && col + ij < target[row + ij].length) {
            target[row + ij][col + ij] = value;
            ++ij;
        }
    }

    public static void fillDiagonal(double[][] target, int row, int col, DoubleSupplier supplier) {
        int limit = target.length;
        int ij = 0;
        while (row + ij < limit && col + ij < target[row + ij].length) {
            target[row + ij][col + ij] = supplier.getAsDouble();
            ++ij;
        }
    }

    public static void fillMatching(double[][] target, double left, DoubleBinaryOperator function, double[][] right) {
        int limit = target.length;
        for (int i = 0; i < limit; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(left, right[i][j]);
            }
        }
    }

    public static void fillMatching(double[][] target, double[][] left, DoubleBinaryOperator function, double right) {
        int limit = target.length;
        for (int i = 0; i < limit; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(left[i][j], right);
            }
        }
    }

    public static void fillMatching(double[][] target, double[][] left, DoubleBinaryOperator function, double[][] right) {
        int limit = target.length;
        for (int i = 0; i < limit; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                target[i][j] = function.applyAsDouble(left[i][j], right[i][j]);
            }
        }
    }

    public static void fillRange(double[][] target, int first, int limit, double value) {
        int tmpLength = target.length;
        for (int index = first; index < limit; ++index) {
            int tmpRow = Structure2D.row(index, tmpLength);
            int tmpcol = Structure2D.column(index, tmpLength);
            target[tmpRow][tmpcol] = value;
        }
    }

    public static void fillRange(double[][] target, int first, int limit, DoubleSupplier supplier) {
        int tmpLength = target.length;
        for (int index = first; index < limit; ++index) {
            int tmpRow = Structure2D.row(index, tmpLength);
            int tmpcol = Structure2D.column(index, tmpLength);
            target[tmpRow][tmpcol] = supplier.getAsDouble();
        }
    }

    public static void fillRow(double[][] target, int row, int col, double value) {
        double[] targetRow = target[row];
        int limit = targetRow.length;
        for (int j = col; j < limit; ++j) {
            targetRow[j] = value;
        }
    }

    public static void fillRow(double[][] target, int row, int col, DoubleSupplier supplier) {
        double[] targetRow = target[row];
        int limit = targetRow.length;
        for (int j = col; j < limit; ++j) {
            targetRow[j] = supplier.getAsDouble();
        }
    }
}

