/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.data.domain.finance.portfolio.NormalisedPortfolio;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.ErrorFunction;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.type.StandardType;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public abstract class FinancePortfolio
implements Comparable<FinancePortfolio> {
    protected static final MatrixR064.Factory MATRIX_FACTORY = MatrixR064.FACTORY;

    protected FinancePortfolio() {
    }

    @Override
    public final int compareTo(FinancePortfolio reference) {
        return NumberContext.compare(this.getSharpeRatio(), reference.getSharpeRatio());
    }

    public final GeometricBrownianMotion forecast() {
        double tmpInitialValue = PrimitiveMath.ONE;
        double tmpExpectedValue = PrimitiveMath.ONE + this.getMeanReturn();
        double tmpValueVariance = this.getReturnVariance();
        double tmpHorizon = PrimitiveMath.ONE;
        return GeometricBrownianMotion.make(tmpInitialValue, tmpExpectedValue, tmpValueVariance, tmpHorizon);
    }

    public final double getConformance(FinancePortfolio reference) {
        MatrixR064 tmpMyWeights = (MatrixR064)MATRIX_FACTORY.columns(new List[]{this.getWeights()});
        MatrixR064 tmpRefWeights = (MatrixR064)MATRIX_FACTORY.columns(new List[]{reference.getWeights()});
        double tmpNumerator = tmpMyWeights.dot(tmpRefWeights);
        double tmpDenom1 = PrimitiveMath.SQRT.invoke(tmpMyWeights.dot(tmpMyWeights));
        double tmpDenom2 = PrimitiveMath.SQRT.invoke(tmpRefWeights.dot(tmpRefWeights));
        return tmpNumerator / (tmpDenom1 * tmpDenom2);
    }

    public final double getLossProbability() {
        return this.getLossProbability(PrimitiveMath.ONE);
    }

    public final double getLossProbability(Number timePeriod) {
        GeometricBrownianMotion tmpProc = this.forecast();
        double tmpDoubleValue = timePeriod.doubleValue();
        double tmpValue = tmpProc.getValue();
        return tmpProc.getDistribution(tmpDoubleValue).getDistribution(tmpValue);
    }

    public abstract double getMeanReturn();

    public double getReturnVariance() {
        double tmpVolatility = this.getVolatility();
        return tmpVolatility * tmpVolatility;
    }

    public final double getSharpeRatio() {
        return this.getSharpeRatio(null);
    }

    public final double getSharpeRatio(Number riskFreeReturn) {
        if (riskFreeReturn != null) {
            return (this.getMeanReturn() - riskFreeReturn.doubleValue()) / this.getVolatility();
        }
        return this.getMeanReturn() / this.getVolatility();
    }

    public final double getValueAtRisk(Number confidenceLevel, Number timePeriod) {
        double aReturn = this.getMeanReturn();
        double aStdDev = this.getVolatility();
        double tmpConfidenceScale = PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(PrimitiveMath.ONE - PrimitiveMath.TWO * (PrimitiveMath.ONE - confidenceLevel.doubleValue()));
        double tmpTimePeriod = timePeriod.doubleValue();
        return PrimitiveMath.MAX.invoke(PrimitiveMath.SQRT.invoke(tmpTimePeriod) * aStdDev * tmpConfidenceScale - tmpTimePeriod * aReturn, PrimitiveMath.ZERO);
    }

    public final double getValueAtRisk95() {
        return this.getValueAtRisk(0.95, PrimitiveMath.ONE);
    }

    public double getVolatility() {
        return PrimitiveMath.SQRT.invoke(this.getReturnVariance());
    }

    public abstract List<BigDecimal> getWeights();

    public final FinancePortfolio normalise() {
        return new NormalisedPortfolio(this, StandardType.PERCENT);
    }

    public final FinancePortfolio normalise(NumberContext weightsContext) {
        return new NormalisedPortfolio(this, weightsContext);
    }

    public String toString() {
        return TypeUtils.format("{}: Return={}, Variance={}, Volatility={}, Weights={}", this.getClass().getSimpleName(), this.getMeanReturn(), this.getReturnVariance(), this.getVolatility(), this.getWeights());
    }

    protected abstract void reset();

    public static interface Context {
        public double calculatePortfolioReturn(FinancePortfolio var1);

        public double calculatePortfolioVariance(FinancePortfolio var1);

        public MatrixR064 getAssetReturns();

        public MatrixR064 getAssetVolatilities();

        public MatrixR064 getCorrelations();

        public MatrixR064 getCovariances();

        public int size();
    }
}

