/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

public class BasicMachine {
    private static final String BYTES = "bytes/";
    private static final String GIGA = "GB/";
    private static final String KILO = "kB/";
    private static final String MEGA = "MB/";
    private static final String THREAD = "thread";
    private static final String THREADS = "threads";
    public final long memory;
    public final int threads;

    public BasicMachine(long memoryBytes, int nbThreads) {
        this.memory = memoryBytes;
        this.threads = nbThreads;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicMachine)) {
            return false;
        }
        BasicMachine other = (BasicMachine)obj;
        return this.memory == other.memory && this.threads == other.threads;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.memory ^ this.memory >>> 32);
        return 31 * result + this.threads;
    }

    public String toString() {
        int prefix = 1;
        long measure = this.memory / 1024L;
        while (measure / 1024L > 0L) {
            ++prefix;
            measure /= 1024L;
        }
        switch (prefix) {
            case 1: {
                return measure + KILO + this.threads + (this.threads == 1 ? THREAD : THREADS);
            }
            case 2: {
                return measure + MEGA + this.threads + (this.threads == 1 ? THREAD : THREADS);
            }
            case 3: {
                return measure + GIGA + this.threads + (this.threads == 1 ? THREAD : THREADS);
            }
        }
        return this.memory + BYTES + this.threads + (this.threads == 1 ? THREAD : THREADS);
    }
}

