/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.InputStream;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.ojalgo.ProgrammingError;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.ReaderWriterBuilder;
import org.ojalgo.netio.ResourceLocator;
import org.ojalgo.netio.ResourceSpecification;

public final class ServiceClient {
    private final HttpClient.Builder myBuilder = HttpClient.newBuilder();

    public static Response<String> get(String url) {
        return ServiceClient.newRequest(url).method(ResourceLocator.Method.GET).send(HttpResponse.BodyHandlers.ofString());
    }

    public static Request newRequest() {
        return ServiceClient.newSession().newRequest();
    }

    public static Request newRequest(String url) {
        return ServiceClient.newSession().newRequest(url);
    }

    public static Session newSession() {
        ServiceClient serviceClient = new ServiceClient();
        return serviceClient.getSession();
    }

    public static Response<String> post(String url, byte[] body) {
        return ServiceClient.newRequest(url).method(ResourceLocator.Method.POST).body(body).send(HttpResponse.BodyHandlers.ofString());
    }

    public static Response<String> post(String url, ResourceLocator.KeyedValues body) {
        return ServiceClient.newRequest(url).method(ResourceLocator.Method.POST).body(body).send(HttpResponse.BodyHandlers.ofString());
    }

    public ServiceClient() {
        this.myBuilder.executor(ReaderWriterBuilder.executor());
    }

    public ServiceClient authenticator(Authenticator authenticator) {
        this.myBuilder.authenticator(authenticator);
        return this;
    }

    public ServiceClient connectTimeout(Duration duration) {
        this.myBuilder.connectTimeout(duration);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServiceClient)) {
            return false;
        }
        ServiceClient other = (ServiceClient)obj;
        return !(this.myBuilder == null ? other.myBuilder != null : !this.myBuilder.equals(other.myBuilder));
    }

    public ServiceClient executor(Executor executor) {
        this.myBuilder.executor(executor);
        return this;
    }

    public ServiceClient followRedirects(HttpClient.Redirect policy) {
        this.myBuilder.followRedirects(policy);
        return this;
    }

    public Session getSession() {
        return new Session(this.myBuilder);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.myBuilder == null ? 0 : this.myBuilder.hashCode());
    }

    public ServiceClient priority(int priority) {
        this.myBuilder.priority(priority);
        return this;
    }

    public ServiceClient proxy(ProxySelector proxySelector) {
        this.myBuilder.proxy(proxySelector);
        return this;
    }

    public ServiceClient sslContext(SSLContext sslContext) {
        this.myBuilder.sslContext(sslContext);
        return this;
    }

    public ServiceClient sslParameters(SSLParameters sslParameters) {
        this.myBuilder.sslParameters(sslParameters);
        return this;
    }

    public ServiceClient version(HttpClient.Version version) {
        this.myBuilder.version(version);
        return this;
    }

    public static final class Session
    implements BasicLogger.Printable {
        private final HttpClient myClient;
        private final CookieManager myCookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
        private final ResourceLocator.KeyedValues myParameters = new ResourceLocator.KeyedValues(ResourceLocator.DEFAULTS.getValues());

        Session(HttpClient.Builder builder) {
            builder.cookieHandler(this.myCookieManager);
            this.myClient = builder.build();
        }

        public String getParameter(String key) {
            return this.myParameters.get(key);
        }

        public Request newRequest() {
            return new Request(this);
        }

        public Request newRequest(String url) {
            try {
                return new Request(this, new URI(url));
            }
            catch (URISyntaxException cause) {
                throw new ProgrammingError(cause);
            }
        }

        public Session parameter(String key, String value) {
            Objects.requireNonNull(key);
            if (value != null) {
                this.myParameters.put(key, value);
            } else {
                this.myParameters.remove(key);
            }
            return this;
        }

        @Override
        public void print(BasicLogger receiver) {
            receiver.println("Session parameters: {}", this.myParameters);
            receiver.println("Session cookies: {}", this.myCookieManager.getCookieStore().getCookies());
        }

        HttpClient getClient() {
            return this.myClient;
        }

        ResourceLocator.KeyedValues getParameters() {
            return this.myParameters;
        }

        <T> Response<T> send(Request request, HttpResponse.BodyHandler<T> responseBodyHandler) {
            HttpClient client = this.getClient();
            CompletableFuture<HttpResponse<T>> futureResponse = client.sendAsync(request.getRequest(), responseBodyHandler);
            return new Response<T>(request, futureResponse);
        }
    }

    public static final class Response<T>
    implements BasicLogger.Printable {
        private final CompletableFuture<HttpResponse<T>> myFutureResponse;
        private final Session mySession;

        Response(Request request, CompletableFuture<HttpResponse<T>> response) {
            this.mySession = request.getSession();
            this.myFutureResponse = response;
        }

        public boolean cancel() {
            return this.myFutureResponse.cancel(true);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Response)) {
                return false;
            }
            Response other = (Response)obj;
            if (!this.myFutureResponse.equals(other.myFutureResponse)) {
                return false;
            }
            return !(this.mySession == null ? other.mySession != null : !this.mySession.equals(other.mySession));
        }

        public T getBody() {
            return this.getResponse().body();
        }

        public HttpHeaders getHeaders() {
            return this.getResponse().headers();
        }

        public Optional<HttpResponse<T>> getPreviousResponse() {
            return this.getResponse().previousResponse();
        }

        public HttpRequest getRequest() {
            return this.getResponse().request();
        }

        public int getStatusCode() {
            return this.getResponse().statusCode();
        }

        public URI getURI() {
            return this.getResponse().uri();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myFutureResponse == null ? 0 : this.myFutureResponse.hashCode());
            return 31 * result + (this.mySession == null ? 0 : this.mySession.hashCode());
        }

        public boolean isDone() {
            return this.myFutureResponse.isDone();
        }

        public boolean isResponseOK() {
            int statusCode = this.getStatusCode();
            return 200 <= statusCode && statusCode < 300;
        }

        @Override
        public void print(BasicLogger receiver) {
            receiver.println("Response body: {}", this.toString());
            receiver.println("Response headers: {}", this.getResponse().headers().map());
            receiver.println("<Recreated>");
            receiver.println("</Recreated>");
            this.mySession.print(receiver);
        }

        public String toString() {
            return this.myFutureResponse.toString();
        }

        HttpResponse<T> getResponse() {
            try {
                return this.myFutureResponse.get();
            }
            catch (InterruptedException | ExecutionException cause) {
                throw new RuntimeException(cause);
            }
        }
    }

    public static final class Request
    implements BasicLogger.Printable {
        private Object myBody = null;
        private final HttpRequest.Builder myBuilder;
        private final ResourceLocator.KeyedValues myForm = new ResourceLocator.KeyedValues();
        private ResourceLocator.Method myMethod = ResourceLocator.Method.GET;
        private transient HttpRequest myRequest = null;
        private final ResourceSpecification myResourceSpecification;
        private final Session mySession;

        Request(Session session) {
            this.mySession = session;
            this.myBuilder = HttpRequest.newBuilder();
            this.myResourceSpecification = new ResourceSpecification();
            this.copy(session.getParameters());
        }

        Request(Session session, URI uri) {
            this.mySession = session;
            this.myBuilder = HttpRequest.newBuilder(uri);
            this.myResourceSpecification = new ResourceSpecification(uri);
            this.copy(session.getParameters());
        }

        public Request body(Object body) {
            this.myBody = body;
            this.myForm.clear();
            this.myRequest = null;
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Request)) {
                return false;
            }
            Request other = (Request)obj;
            if (this.myBody == null ? other.myBody != null : !this.myBody.equals(other.myBody)) {
                return false;
            }
            if (this.myBuilder == null ? other.myBuilder != null : !this.myBuilder.equals(other.myBuilder)) {
                return false;
            }
            if (!this.myForm.equals(other.myForm) || this.myMethod != other.myMethod) {
                return false;
            }
            if (this.myResourceSpecification == null ? other.myResourceSpecification != null : !this.myResourceSpecification.equals(other.myResourceSpecification)) {
                return false;
            }
            return !(this.mySession == null ? other.mySession != null : !this.mySession.equals(other.mySession));
        }

        public Request expectContinue(boolean enable) {
            this.myBuilder.expectContinue(enable);
            return this;
        }

        public Request form(String form) {
            this.myForm.parse(form);
            this.myBody = this.myForm;
            this.myRequest = null;
            return this;
        }

        public Request form(String key, String value) {
            ProgrammingError.throwIfNull((Object)key);
            if (value != null) {
                this.myForm.put(key, value);
            } else {
                this.myForm.remove(key);
            }
            this.myBody = this.myForm;
            this.myRequest = null;
            return this;
        }

        public Request fragment(String fragment) {
            this.myResourceSpecification.setFragment(fragment);
            this.myRequest = null;
            return this;
        }

        public String getFormValue(String key) {
            return this.myForm.get(key);
        }

        public String getQueryValue(String key) {
            return this.myResourceSpecification.getQueryValue(key);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myBody == null ? 0 : this.myBody.hashCode());
            result = 31 * result + (this.myBuilder == null ? 0 : this.myBuilder.hashCode());
            result = 31 * result + this.myForm.hashCode();
            result = 31 * result + (this.myMethod == null ? 0 : this.myMethod.hashCode());
            result = 31 * result + (this.myResourceSpecification == null ? 0 : this.myResourceSpecification.hashCode());
            return 31 * result + (this.mySession == null ? 0 : this.mySession.hashCode());
        }

        public Request header(String name, String value) {
            this.myBuilder.header(name, value);
            return this;
        }

        public Request host(String host) {
            this.myResourceSpecification.setHost(host);
            this.myRequest = null;
            return this;
        }

        public Request method(ResourceLocator.Method method) {
            this.myMethod = method;
            this.myRequest = null;
            return this;
        }

        public Request method(String method, HttpRequest.BodyPublisher bodyPublisher) {
            this.myBuilder.method(method, bodyPublisher);
            return this;
        }

        public Request path(String path) {
            this.myResourceSpecification.setPath(path);
            this.myRequest = null;
            return this;
        }

        public Request port(int port) {
            this.myResourceSpecification.setPort(port);
            this.myRequest = null;
            return this;
        }

        @Override
        public void print(BasicLogger receiver) {
            this.mySession.print(receiver);
            receiver.println("Request URI: {}", this.getURI());
            if (this.myForm.size() > 0) {
                receiver.println("Request form: {}", this.myForm);
            }
        }

        public Request query(String query) {
            this.myResourceSpecification.setQuery(query);
            this.myRequest = null;
            return this;
        }

        public Request query(String key, String value) {
            this.myResourceSpecification.putQueryEntry(key, value);
            this.myRequest = null;
            return this;
        }

        public Request secure(boolean secure) {
            if (secure) {
                this.myResourceSpecification.setScheme("https");
            } else {
                this.myResourceSpecification.setScheme("http");
            }
            this.myRequest = null;
            return this;
        }

        public <T> Response<T> send(HttpResponse.BodyHandler<T> responseBodyHandler) {
            return this.getSession().send(this, responseBodyHandler);
        }

        public Request timeout(Duration duration) {
            this.myBuilder.timeout(duration);
            return this;
        }

        public String toString() {
            return this.getURI().toString();
        }

        public Request version(HttpClient.Version version) {
            this.myBuilder.version(version);
            return this;
        }

        private void copy(ResourceLocator.KeyedValues sessionParameters) {
            for (Map.Entry<String, String> entry : sessionParameters.entrySet()) {
                this.myBuilder.setHeader(entry.getKey(), entry.getValue());
            }
        }

        HttpRequest.BodyPublisher body() {
            if (this.myBody != null) {
                Class<?> bodyType = this.myBody.getClass();
                if (byte[].class.isAssignableFrom(bodyType)) {
                    return HttpRequest.BodyPublishers.ofByteArray((byte[])this.myBody);
                }
                if (InputStream.class.isAssignableFrom(bodyType)) {
                    return HttpRequest.BodyPublishers.ofInputStream(() -> (InputStream)this.myBody);
                }
                return HttpRequest.BodyPublishers.ofString(this.myBody.toString());
            }
            return HttpRequest.BodyPublishers.noBody();
        }

        HttpRequest getRequest() {
            if (this.myRequest == null) {
                this.myBuilder.uri(this.getURI());
                HttpRequest.BodyPublisher body = this.body();
                switch (this.myMethod) {
                    case DELETE: {
                        this.myBuilder.DELETE();
                        break;
                    }
                    case GET: {
                        this.myBuilder.GET();
                        break;
                    }
                    case POST: {
                        this.myBuilder.POST(body);
                        break;
                    }
                    case PUT: {
                        this.myBuilder.PUT(body);
                        break;
                    }
                    default: {
                        this.myBuilder.method(this.myMethod.name(), body);
                    }
                }
                this.myRequest = this.myBuilder.build();
            }
            return this.myRequest;
        }

        Session getSession() {
            return this.mySession;
        }

        URI getURI() {
            return this.myResourceSpecification.toURI();
        }
    }
}

