/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.BasePrimitiveSolver;
import org.ojalgo.optimisation.convex.ConvexData;
import org.ojalgo.structure.Access2D;

abstract class ConstrainedSolver
extends BasePrimitiveSolver {
    private final Primitive64Store mySlackE;
    private final Primitive64Store mySolutionL;

    protected ConstrainedSolver(ConvexData<Double> convexSolverBuilder, Optimisation.Options optimisationOptions) {
        super(convexSolverBuilder, optimisationOptions);
        int numberOfEqualityConstraints = this.countEqualityConstraints();
        int numberOfInequalityConstraints = this.countInequalityConstraints();
        this.mySlackE = (Primitive64Store)MATRIX_FACTORY.make((long)numberOfEqualityConstraints, 1L);
        this.mySolutionL = (Primitive64Store)MATRIX_FACTORY.make((long)(numberOfEqualityConstraints + numberOfInequalityConstraints), 1L);
    }

    @Override
    protected Optimisation.Result buildResult() {
        Optimisation.Result result = super.buildResult();
        result.multipliers(this.mySolutionL);
        return result;
    }

    @Override
    protected Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationKKT() {
        PhysicalStore<Double> iterQ = this.getIterationQ();
        MatrixStore<Double> iterA = this.getIterationA();
        return iterQ.right(iterA.transpose()).below((Access2D<Double>)iterA);
    }

    @Override
    protected Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationRHS() {
        MatrixStore<Double> iterC = this.getIterationC();
        MatrixStore<Double> iterB = this.getIterationB();
        return iterC.below((Access2D<Double>)iterB);
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        MatrixStore<Double> iterationA;
        boolean spdQ = super.initialise(kickStarter);
        if (this.options.validate && (iterationA = this.getIterationA()) != null) {
            this.computeGeneral((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)(iterationA.countRows() < iterationA.countColumns() ? iterationA.transpose() : iterationA)));
            if ((long)this.getRankGeneral() != iterationA.countRows()) {
                this.setState(Optimisation.State.INVALID);
                if (!this.isLogDebug()) {
                    throw new IllegalArgumentException("A not full (row) rank!");
                }
                this.log("A not full (row) rank!", new Object[0]);
            }
        }
        return spdQ;
    }

    abstract int countIterationConstraints();

    abstract MatrixStore<Double> getIterationA();

    abstract MatrixStore<Double> getIterationB();

    abstract MatrixStore<Double> getIterationC();

    MatrixStore<Double> getIterationL(int[] included) {
        int tmpCountE = this.countEqualityConstraints();
        Access2D tmpLI = this.mySolutionL.offsets(tmpCountE, 0L).rows(included);
        return this.mySolutionL.limits(tmpCountE, 1L).below(tmpLI);
    }

    PhysicalStore<Double> getIterationQ() {
        return this.getMatrixQ();
    }

    PhysicalStore<Double> getSlackE() {
        MatrixStore<Double> mtrxBE = this.getMatrixBE();
        PhysicalStore<Double> mtrxX = this.getSolutionX();
        this.mySlackE.fillMatching(mtrxBE);
        int limit = mtrxBE.getRowDim();
        for (int i = 0; i < limit; ++i) {
            this.mySlackE.add((long)i, -this.getMatrixAE(i).dot(mtrxX));
        }
        return this.mySlackE;
    }

    Primitive64Store getSolutionL() {
        return this.mySolutionL;
    }
}

