/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.ojalgo.concurrent.MultiviewSet;
import org.ojalgo.concurrent.ProcessingService;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.CharacterRing;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.integer.ModelStrategy;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.optimisation.integer.NodeSolver;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.TypeUtils;

public final class IntegerSolver
extends GenericSolver {
    public static final ModelIntegration INTEGRATION = new ModelIntegration();
    private volatile Optimisation.Result myBestResultSoFar = null;
    private final MultiviewSet<NodeKey> myDeferredNodes = new MultiviewSet();
    private final MultiaryFunction.TwiceDifferentiable<Double> myFunction;
    private final ExpressionsBasedModel myIntegerModel;
    private final boolean myMinimisation;
    private final NodeStatistics myNodeStatistics = new NodeStatistics();

    public static IntegerSolver make(ExpressionsBasedModel model) {
        return new IntegerSolver(model);
    }

    static void flush(CharacterRing.RingLogger buffer, BasicLogger receiver) {
        if (buffer != null && receiver != null) {
            buffer.flush(receiver);
        }
    }

    IntegerSolver(ExpressionsBasedModel model) {
        super(model.options);
        this.myIntegerModel = model.simplify();
        this.myFunction = this.myIntegerModel.limitObjective(null, null).toFunction();
        this.myMinimisation = this.myIntegerModel.getOptimisationSense() == Optimisation.Sense.MIN;
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        Optimisation.Result bestSolutionFound;
        Optimisation.Result point = kickStarter != null ? kickStarter : this.myIntegerModel.getVariableValues();
        ModelStrategy strategy = this.options.integer().newModelStrategy(this.myIntegerModel).initialise(this.myFunction, point);
        if (point != null && point.getState().isFeasible() && this.myIntegerModel.validate(point)) {
            this.markInteger(null, point, strategy);
        }
        this.resetIterationsCount();
        ExpressionsBasedModel cutModel = this.myIntegerModel.snapshot();
        NodeSolver cutSolver = cutModel.prepare(NodeSolver::new);
        Optimisation.Result cutResult = cutSolver.solve();
        cutSolver.generateCuts(strategy, this.myIntegerModel);
        NodeKey rootNode = new NodeKey(this.myIntegerModel);
        ExpressionsBasedModel rootModel = this.myIntegerModel.snapshot();
        rootNode.setNodeState(rootModel, strategy);
        CharacterRing.RingLogger rootPrinter = this.newPrinter();
        AtomicBoolean solverNormalExit = new AtomicBoolean(this.compute(rootNode, rootModel.prepare(NodeSolver::new), rootPrinter, strategy));
        rootNode.dispose();
        ConcurrentHashMap views = new ConcurrentHashMap();
        ProcessingService.INSTANCE.process(strategy.getWorkerPriorities(), workerStrategy -> {
            boolean workerNormalExit = solverNormalExit.get();
            MultiviewSet.PrioritisedView view = views.computeIfAbsent(workerStrategy, this.myDeferredNodes::newView);
            CharacterRing.RingLogger nodePrinter = this.newPrinter();
            NodeKey node = null;
            while (workerNormalExit && solverNormalExit.get() && !this.myDeferredNodes.isEmpty()) {
                node = (NodeKey)view.poll();
                if (node != null) {
                    if (!this.isIterationAllowed()) {
                        workerNormalExit = false;
                    } else if (!strategy.isGoodEnough(this.myBestResultSoFar, node.objective)) {
                        workerNormalExit = this.myNodeStatistics.abandoned();
                    } else {
                        ExpressionsBasedModel nodeModel = this.myIntegerModel.snapshot();
                        node.setNodeState(nodeModel, strategy);
                        NodeSolver nodeSolver = nodeModel.prepare(NodeSolver::new);
                        workerNormalExit &= this.compute(node, nodeSolver, nodePrinter, strategy);
                    }
                    node.dispose();
                }
                if (workerNormalExit) continue;
                solverNormalExit.set(workerNormalExit);
            }
        });
        views.clear();
        this.myDeferredNodes.clear();
        if (this.isLogProgress()) {
            this.logProgress(this.countIterations(), this.getClassSimpleName(), this.getDuration());
        }
        if ((bestSolutionFound = this.getBestResultSoFar()).getState().isFeasible()) {
            if (solverNormalExit.get()) {
                return bestSolutionFound.withState(Optimisation.State.OPTIMAL);
            }
            return bestSolutionFound.withState(Optimisation.State.FEASIBLE);
        }
        if (solverNormalExit.get()) {
            return bestSolutionFound.withState(Optimisation.State.INFEASIBLE);
        }
        return bestSolutionFound.withState(Optimisation.State.FAILED);
    }

    public String toString() {
        return TypeUtils.format("Solutions={} Nodes/Iterations={} {}", this.myNodeStatistics.countIntegerSolutions(), this.countIterations(), this.getBestResultSoFar());
    }

    private CharacterRing.RingLogger newPrinter() {
        return this.options.validate || this.isLogProgress() ? CharacterRing.newRingLogger() : null;
    }

    protected Optimisation.Result buildResult() {
        MatrixStore<Double> solution = this.extractSolution();
        double value = this.evaluateFunction(solution);
        Optimisation.State state = this.getState();
        return new Optimisation.Result(state, value, solution);
    }

    protected double evaluateFunction(Access1D<?> solution) {
        if (this.myFunction != null && solution != null && (long)this.myFunction.arity() == solution.count()) {
            return this.myFunction.invoke(Access1D.asPrimitive1D(solution));
        }
        return Double.NaN;
    }

    protected MatrixStore<Double> extractSolution() {
        return (MatrixStore)Primitive64Store.FACTORY.columns(this.getBestResultSoFar());
    }

    protected Optimisation.Result getBestEstimate() {
        return new Optimisation.Result(Optimisation.State.APPROXIMATE, this.getBestResultSoFar());
    }

    protected Optimisation.Result getBestResultSoFar() {
        Optimisation.Result currentlyTheBest = this.myBestResultSoFar;
        if (currentlyTheBest != null) {
            return currentlyTheBest;
        }
        Optimisation.State tmpSate = Optimisation.State.INVALID;
        double tmpValue = this.myMinimisation ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        MatrixStore<Double> tmpSolution = Primitive64Store.FACTORY.makeZero(this.myIntegerModel.countVariables(), 1L);
        return new Optimisation.Result(tmpSate, tmpValue, tmpSolution);
    }

    protected boolean isIterationNecessary() {
        if (this.myBestResultSoFar == null) {
            return true;
        }
        return this.countTime() < this.options.time_suffice && this.countIterations() < this.options.iterations_suffice;
    }

    @Override
    protected void logProgress(int iterationsDone, String classSimpleName, CalendarDateDuration duration) {
        this.log("Done {} {} iterations in {} with {}", iterationsDone, classSimpleName, duration, this.myNodeStatistics);
    }

    protected synchronized void markInteger(NodeKey key, Optimisation.Result result, ModelStrategy strategy) {
        Optimisation.Result previouslyTheBest;
        if (this.isLogProgress()) {
            double low = Double.NEGATIVE_INFINITY;
            double high = Double.POSITIVE_INFINITY;
            if (key != null) {
                if (this.myMinimisation) {
                    low = Math.max(low, key.objective);
                } else {
                    high = Math.min(high, key.objective);
                }
            }
            if (this.myBestResultSoFar != null) {
                if (this.myMinimisation) {
                    high = Math.min(high, this.myBestResultSoFar.getValue());
                } else {
                    low = Math.max(low, this.myBestResultSoFar.getValue());
                }
            }
            this.log("[{}, {}] -> {}", low, high, result.toString());
            if (key != null) {
                this.log("\t @ {}", key);
            }
        }
        if ((previouslyTheBest = this.myBestResultSoFar) == null) {
            this.myBestResultSoFar = result;
            this.setState(Optimisation.State.FEASIBLE);
        } else if (this.myMinimisation ? result.getValue() < previouslyTheBest.getValue() : result.getValue() > previouslyTheBest.getValue()) {
            this.myBestResultSoFar = result;
        }
        strategy.markInteger(key, result);
        double bestIntegerSolutionValue = this.myBestResultSoFar.getValue();
        if (!strategy.getGapTolerance().isZero(bestIntegerSolutionValue)) {
            double nudge = Math.abs(bestIntegerSolutionValue * strategy.getGapTolerance().epsilon());
            if (this.myIntegerModel.getOptimisationSense() != Optimisation.Sense.MAX) {
                BigDecimal upper = TypeUtils.toBigDecimal(Double.valueOf(bestIntegerSolutionValue - nudge), strategy.getIntegralityTolerance());
                this.myIntegerModel.limitObjective(null, upper);
            } else {
                BigDecimal lower = TypeUtils.toBigDecimal(Double.valueOf(bestIntegerSolutionValue + nudge), strategy.getIntegralityTolerance());
                this.myIntegerModel.limitObjective(lower, null);
            }
        }
    }

    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        try {
            retVal = this.myIntegerModel.validate();
            if (!retVal) {
                retVal = false;
                this.setState(Optimisation.State.INVALID);
            }
        }
        catch (Exception cause) {
            retVal = false;
            this.setState(Optimisation.State.FAILED);
        }
        return retVal;
    }

    boolean compute(NodeKey nodeKey, NodeSolver nodeSolver, CharacterRing.RingLogger nodePrinter, ModelStrategy strategy) {
        double displacement;
        if (this.isLogDebug()) {
            nodePrinter.println();
            nodePrinter.println("Branch&Bound Node");
            nodePrinter.println(nodeKey.toString());
            nodePrinter.println(this.toString());
        }
        if (nodeKey.index >= 0) {
            nodeKey.enforceBounds(nodeSolver, strategy);
        }
        Optimisation.Result bestEstimate = this.getBestEstimate();
        Optimisation.Result nodeResult = nodeSolver.solve(bestEstimate);
        this.incrementIterationsCount();
        if (this.isLogDebug()) {
            nodePrinter.println("Node Result: {}", nodeResult);
        }
        if (!nodeResult.getState().isOptimal()) {
            if (this.isLogDebug()) {
                nodePrinter.println("Failed to solve node problem - stop this branch!");
                IntegerSolver.flush(nodePrinter, this.myIntegerModel.options.logger_appender);
            }
            nodeSolver.dispose();
            if (nodeKey.sequence == 0L && (nodeResult.getState().isUnexplored() || !nodeResult.getState().isValid())) {
                return this.myNodeStatistics.failed();
            }
            strategy.markInfeasible(nodeKey, this.myBestResultSoFar != null);
            return this.myNodeStatistics.infeasible();
        }
        if (this.isLogDebug()) {
            nodePrinter.println("Node solved to optimality!");
        }
        if (this.options.validate && !nodeSolver.validate(nodeResult, nodePrinter)) {
            nodePrinter.println("Node solution marked as OPTIMAL, but is actually INVALID/INFEASIBLE/FAILED. Stop this branch!");
            nodePrinter.println("Integer indices: {}", strategy);
            nodePrinter.println("Lower bounds: {}", Arrays.toString(nodeKey.copyLowerBounds()));
            nodePrinter.println("Upper bounds: {}", Arrays.toString(nodeKey.copyUpperBounds()));
            IntegerSolver.flush(nodePrinter, this.myIntegerModel.options.logger_appender);
            return this.myNodeStatistics.failed();
        }
        int branchIntegerIndex = this.identifyNonIntegerVariable(nodeResult, nodeKey, strategy);
        double tmpSolutionValue = this.evaluateFunction(nodeResult);
        if (branchIntegerIndex == -1) {
            if (this.isLogDebug()) {
                nodePrinter.println("Integer solution! Store it among the others, and stop this branch!");
            }
            Optimisation.Result tmpIntegerSolutionResult = new Optimisation.Result(Optimisation.State.FEASIBLE, tmpSolutionValue, nodeResult);
            this.markInteger(nodeKey, tmpIntegerSolutionResult, strategy);
            if (this.isLogDebug()) {
                nodePrinter.println(this.getBestResultSoFar().toString());
                BasicLogger.debug();
                BasicLogger.debug(this.toString());
                IntegerSolver.flush(nodePrinter, this.myIntegerModel.options.logger_appender);
            }
            nodeSolver.dispose();
            return this.myNodeStatistics.integer();
        }
        if (this.isLogDebug()) {
            nodePrinter.println("Not an Integer Solution: " + tmpSolutionValue);
        }
        double variableValue = nodeResult.doubleValue(strategy.getIndex(branchIntegerIndex));
        if (!strategy.isGoodEnough(this.myBestResultSoFar, tmpSolutionValue)) {
            if (this.isLogDebug()) {
                nodePrinter.println("Can't find better integer solutions - stop this branch!");
                IntegerSolver.flush(nodePrinter, this.myIntegerModel.options.logger_appender);
            }
            nodeSolver.dispose();
            return this.myNodeStatistics.exhausted();
        }
        if (this.isLogDebug()) {
            nodePrinter.println("Still hope, branching on {} @ {} >>> {}", branchIntegerIndex, variableValue, nodeSolver.getVariable(strategy.getIndex(branchIntegerIndex)));
            IntegerSolver.flush(nodePrinter, this.myIntegerModel.options.logger_appender);
        }
        if (strategy.cutting && nodeKey.sequence % 10L == 0L && strategy.isCutRatherThanBranch(displacement = nodeKey.getMinimumDisplacement(branchIntegerIndex, variableValue), this.myBestResultSoFar != null)) {
            if (nodeSolver.generateCuts(strategy)) {
                return this.compute(nodeKey, nodeSolver, nodePrinter, strategy);
            }
            strategy.cutting = false;
        }
        NodeKey lowerBranch = nodeKey.createLowerBranch(branchIntegerIndex, variableValue, tmpSolutionValue);
        NodeKey upperBranch = nodeKey.createUpperBranch(branchIntegerIndex, variableValue, tmpSolutionValue);
        if (!strategy.isDirect(lowerBranch, this.myBestResultSoFar != null)) {
            this.myDeferredNodes.add(lowerBranch);
            lowerBranch = null;
        }
        if (lowerBranch != null || !strategy.isDirect(upperBranch, this.myBestResultSoFar != null)) {
            this.myDeferredNodes.add(upperBranch);
            upperBranch = null;
        }
        if (lowerBranch != null && upperBranch != null) {
            throw new IllegalStateException();
        }
        boolean retVal = true;
        if (lowerBranch != null) {
            boolean bl = retVal = retVal && this.compute(lowerBranch, nodeSolver, nodePrinter, strategy);
        }
        if (upperBranch != null) {
            retVal = retVal && this.compute(upperBranch, nodeSolver, nodePrinter, strategy);
        }
        return retVal;
    }

    int identifyNonIntegerVariable(Optimisation.Result nodeResult, NodeKey nodeKey, ModelStrategy strategy) {
        int retVal = -1;
        double comparableDisplacement = PrimitiveMath.ZERO;
        double maxComparable = PrimitiveMath.ZERO;
        int limit = strategy.countIntegerVariables();
        for (int i = 0; i < limit; ++i) {
            int globalIndex = strategy.getIndex(i);
            double displacement = nodeKey.getMinimumDisplacement(i, nodeResult.doubleValue(globalIndex));
            if (strategy.getIntegralityTolerance().isZero(displacement) || !((comparableDisplacement = strategy.toComparable(i, displacement, this.myBestResultSoFar != null)) > maxComparable)) continue;
            retVal = i;
            maxComparable = comparableDisplacement;
        }
        return retVal;
    }

    static final class NodeStatistics {
        private final LongAdder myAbandoned = new LongAdder();
        private final LongAdder myExhausted = new LongAdder();
        private final LongAdder myInfeasible = new LongAdder();
        private final LongAdder myInteger = new LongAdder();

        NodeStatistics() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NodeStatistics [I=");
            builder.append(this.myInteger);
            builder.append(", E=");
            builder.append(this.myExhausted);
            builder.append(", S=");
            builder.append(this.myInfeasible);
            builder.append(", A=");
            builder.append(this.myAbandoned);
            builder.append("]");
            return builder.toString();
        }

        boolean abandoned() {
            this.myAbandoned.increment();
            return true;
        }

        long countEvaluatedNodes() {
            return this.myInteger.longValue() + this.myInfeasible.longValue() + this.myExhausted.longValue();
        }

        int countIntegerSolutions() {
            return this.myInteger.intValue();
        }

        long countSkippedNodes() {
            return this.myAbandoned.longValue();
        }

        long countTotalNodes() {
            return this.countEvaluatedNodes() + this.countSkippedNodes();
        }

        boolean exhausted() {
            this.myExhausted.increment();
            return true;
        }

        boolean failed() {
            return false;
        }

        boolean infeasible() {
            this.myInfeasible.increment();
            return true;
        }

        boolean integer() {
            this.myInteger.increment();
            return true;
        }
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<IntegerSolver> {
        @Override
        public IntegerSolver build(ExpressionsBasedModel model) {
            return IntegerSolver.make(model);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyConstraintQuadratic();
        }
    }
}

