/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.List;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.FactorySupplement;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.math.MathType;

public interface Factory2D<I extends Structure2D>
extends FactorySupplement {
    default public Factory1D<I> asFactory1D() {
        return new Factory1D<I>(){

            @Override
            public FunctionSet<?> function() {
                return Factory2D.this.function();
            }

            @Override
            public I make(long count) {
                return Factory2D.this.make(count, 1L);
            }

            @Override
            public Scalar.Factory<?> scalar() {
                return Factory2D.this.scalar();
            }

            @Override
            public MathType getMathType() {
                return Factory2D.this.getMathType();
            }
        };
    }

    default public I make(int rows, int columns) {
        return this.make((long)rows, (long)columns);
    }

    public I make(long var1, long var3);

    default public I make(Structure2D shape) {
        return this.make(shape.countRows(), shape.countColumns());
    }

    public static interface MayBeSparse<I extends Structure2D, DR extends Mutate2D.ModifiableReceiver<?>, SR extends Mutate2D.Receiver<?>>
    extends Factory2D<I> {
        public DR makeDense(long var1, long var3);

        default public DR makeDense(Structure2D shape) {
            return this.makeDense(shape.countRows(), shape.countColumns());
        }

        public SR makeSparse(long var1, long var3);

        default public SR makeSparse(Structure2D shape) {
            return this.makeSparse(shape.countRows(), shape.countColumns());
        }
    }

    public static interface Dense<I extends Structure2D>
    extends Factory2D<I> {
        default public I column(double ... elements) {
            return this.columns(new double[][]{elements});
        }

        public I columns(Access1D<?> ... var1);

        public I columns(Comparable<?>[] ... var1);

        public I columns(double[] ... var1);

        public I columns(List<? extends Comparable<?>> ... var1);

        public I copy(Access2D<?> var1);

        public I makeFilled(long var1, long var3, NullaryFunction<?> var5);

        default public I makeFilled(Structure2D shape, NullaryFunction<?> supplier) {
            return this.makeFilled(shape.countRows(), shape.countColumns(), supplier);
        }

        default public I row(double ... elements) {
            return this.rows(new double[][]{elements});
        }

        public I rows(Access1D<?> ... var1);

        public I rows(Comparable<?>[] ... var1);

        public I rows(double[] ... var1);

        public I rows(List<? extends Comparable<?>> ... var1);
    }
}

