/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.primitives;

import fr.profi.util.StringUtils;
import fr.profi.util.primitives.package$DataType$;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static package$ MODULE$;
    private final Pattern datePattern;
    private final Pattern dateTimePattern;
    private final SimpleDateFormat localDateFormat;
    private final SimpleDateFormat localDateTimeFormat;

    static {
        new package$();
    }

    private Pattern datePattern() {
        return this.datePattern;
    }

    private Pattern dateTimePattern() {
        return this.dateTimePattern;
    }

    private SimpleDateFormat newDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private SimpleDateFormat newDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    private SimpleDateFormat localDateFormat() {
        return this.localDateFormat;
    }

    private SimpleDateFormat localDateTimeFormat() {
        return this.localDateTimeFormat;
    }

    public boolean isZeroOrNaN(float value) {
        return Predef$.MODULE$.float2Float(value).isNaN() || value == 0.0f;
    }

    public boolean isZeroOrNaN(double value) {
        return Predef$.MODULE$.double2Double(value).isNaN() || value == 0.0;
    }

    public int toIntOrZero(Object v) {
        int n;
        try {
            n = this.toInt(v);
        }
        catch (Throwable e) {
            n = 0;
        }
        return n;
    }

    public float toFloatOrMinusOne(Object v) {
        float f;
        try {
            f = this.toFloat(v);
        }
        catch (Throwable e) {
            f = -1.0f;
        }
        return f;
    }

    public boolean toBoolean(Object value) {
        boolean bl;
        Object object = value;
        if (object instanceof Boolean) {
            boolean bl2;
            bl = bl2 = BoxesRunTime.unboxToBoolean((Object)object);
        } else if (object instanceof Boolean) {
            Boolean bl3 = (Boolean)object;
            bl = bl3;
        } else if (object instanceof String) {
            String string = (String)object;
            bl = Boolean.parseBoolean(this.normalizeString(string));
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Type of value is ").append(this.getTypeAsString(value)).append(" not boolean").toString());
        }
        return bl;
    }

    public int toInt(Object value) {
        int n;
        Object object = value;
        if (object instanceof Integer) {
            int n2;
            n = n2 = BoxesRunTime.unboxToInt((Object)object);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            n = this.checkInt(number.longValue());
        } else if (object instanceof String) {
            String string = (String)object;
            n = this.checkInt(Long.parseLong(this.normalizeString(string)));
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Type of value is ").append(this.getTypeAsString(value)).append(" not integer").toString());
        }
        return n;
    }

    public long toLong(Object value) {
        long l;
        Object object = value;
        if (object instanceof Long) {
            long l2;
            l = l2 = BoxesRunTime.unboxToLong((Object)object);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            l = number.longValue();
        } else if (object instanceof String) {
            String string = (String)object;
            l = Long.parseLong(this.normalizeString(string));
        } else {
            throw new IllegalArgumentException(new StringBuilder(26).append("Type of value is ").append(this.getTypeAsString(value)).append(" not long").toString());
        }
        return l;
    }

    public float toFloat(Object value) {
        float f;
        Object object = value;
        if (object instanceof Float) {
            float f2;
            f = f2 = BoxesRunTime.unboxToFloat((Object)object);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            f = number.floatValue();
        } else if (object instanceof String) {
            String string = (String)object;
            f = Float.parseFloat(this.normalizeString(string));
        } else {
            throw new IllegalArgumentException(new StringBuilder(27).append("Type of value is ").append(this.getTypeAsString(value)).append(" not float").toString());
        }
        return f;
    }

    public double toDouble(Object value) {
        double d;
        Object object = value;
        if (object instanceof Double) {
            double d2;
            d = d2 = BoxesRunTime.unboxToDouble((Object)object);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d = number.doubleValue();
        } else if (object instanceof String) {
            String string = (String)object;
            d = Double.parseDouble(this.normalizeString(string));
        } else {
            throw new IllegalArgumentException(new StringBuilder(28).append("Type of value is ").append(this.getTypeAsString(value)).append(" not double").toString());
        }
        return d;
    }

    public String castToString(Object value) {
        String string;
        if (value == null) {
            return (String)value;
        }
        Object object = value;
        String string2 = object instanceof String ? (string = (String)object) : value.toString();
        return string2;
    }

    public Date castToDate(Object value) {
        Date date;
        if (value == null) {
            return (Date)value;
        }
        Object object = value;
        if (object instanceof Date) {
            Date date2;
            date = date2 = (Date)object;
        } else if (object instanceof String) {
            String string = (String)object;
            date = this.localDateTimeFormat().parse(this.normalizeString(string));
        } else {
            throw new IllegalArgumentException(new StringBuilder(26).append("Type of value is ").append(this.getTypeAsString(value)).append(" not Date").toString());
        }
        return date;
    }

    public Timestamp castToTimestamp(Object value) {
        Timestamp timestamp;
        if (value == null) {
            return (Timestamp)value;
        }
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp2;
            timestamp = timestamp2 = (Timestamp)object;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            timestamp = new Timestamp(date.getTime());
        } else if (object instanceof String) {
            String string = (String)object;
            timestamp = new Timestamp(this.localDateTimeFormat().parse(this.normalizeString(string)).getTime());
        } else {
            throw new IllegalArgumentException(new StringBuilder(26).append("Type of value is ").append(this.getTypeAsString(value)).append(" not Date").toString());
        }
        return timestamp;
    }

    private String normalizeString(String rawStr) {
        if (StringUtils.isEmpty((String)rawStr)) {
            throw new IllegalArgumentException("Invalid raw String value");
        }
        return rawStr.trim();
    }

    private int checkInt(long longValue) {
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer value out of range");
        }
        return (int)longValue;
    }

    /*
     * WARNING - void declaration
     */
    private String getTypeAsString(Object value) {
        void var2_3;
        String string;
        try {
            string = value.getClass().toString();
        }
        catch (Throwable e) {
            string = "unknown";
        }
        String valueType = string;
        return var2_3;
    }

    public Object parseString(String str) {
        Enumeration.Value dataType;
        Enumeration.Value value = dataType = this.inferDataType(str);
        Enumeration.Value value2 = package$DataType$.MODULE$.STRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            try {
                if (this.dateTimePattern().matcher(str).matches()) {
                    return this.localDateTimeFormat().parse(str);
                }
                if (this.datePattern().matcher(str).matches()) {
                    return this.localDateFormat().parse(str);
                }
                return str;
            }
            catch (Exception e) {
                return str;
            }
        }
        Enumeration.Value value4 = package$DataType$.MODULE$.NULL();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return str;
        }
        Enumeration.Value value6 = package$DataType$.MODULE$.BOOLEAN();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(str)).toBoolean());
        }
        Enumeration.Value value8 = package$DataType$.MODULE$.INTEGER();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            try {
                return BoxesRunTime.boxToInteger((int)this.toInt(str));
            }
            catch (Exception e) {
                return BoxesRunTime.boxToLong((long)this.toLong(str));
            }
        }
        Enumeration.Value value10 = package$DataType$.MODULE$.DECIMAL();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            String zeroStrippedStr = str.replaceFirst("\\.0*$|(\\.\\d*?)0+$", "$1");
            int numberOfSigD = zeroStrippedStr.replaceFirst("\\.", "").length();
            if (numberOfSigD > 7) {
                return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(str)).toDouble());
            }
            return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(str)).toFloat());
        }
        throw new Exception("invalid data type");
    }

    public Enumeration.Value inferDataType(String str) {
        int length;
        block12: {
            block11: {
                if (str == null) {
                    return package$DataType$.MODULE$.NULL();
                }
                length = str.length();
                if (length == 0) {
                    return package$DataType$.MODULE$.NULL();
                }
                String string = str;
                String string2 = "true";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block11;
                String string3 = str;
                String string4 = "false";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block12;
            }
            return package$DataType$.MODULE$.BOOLEAN();
        }
        Enumeration.Value dataType = package$DataType$.MODULE$.INTEGER();
        char c = '\u0000';
        int i = 0;
        boolean hasDot = false;
        if (str.charAt(0) == '-') {
            i = 1;
        }
        while (i < length) {
            c = str.charAt(i);
            if (c < '0' || c > '9') {
                if (c == '.') {
                    if (hasDot) {
                        return package$DataType$.MODULE$.STRING();
                    }
                    dataType = package$DataType$.MODULE$.DECIMAL();
                } else {
                    return package$DataType$.MODULE$.STRING();
                }
            }
            ++i;
        }
        return dataType;
    }

    public boolean isValidDate(String text) {
        if (text == null || !this.datePattern().matcher(text).matches()) {
            return false;
        }
        SimpleDateFormat df = this.newDateFormat();
        df.setLenient(false);
        try {
            df.parse(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidDateTime(String text) {
        if (text == null || !this.dateTimePattern().matcher(text).matches()) {
            return false;
        }
        SimpleDateFormat df = this.newDateTimeFormat();
        df.setLenient(false);
        try {
            df.parse(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private package$() {
        MODULE$ = this;
        this.datePattern = Pattern.compile("\\d{4}-[01]\\d-[0-3]\\d");
        this.dateTimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d{3}");
        this.localDateFormat = this.newDateFormat();
        this.localDateTimeFormat = this.newDateTimeFormat();
    }
}

